/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.FileOutputStream;
import java.io.IOException;
import magick.DrawInfo;
import magick.ImageInfo;
import magick.Magick;
import magick.MagickApiException;
import magick.MagickException;
import magick.MagickImage;
import magick.MagickInfo;
import magick.MontageInfo;
import magick.PixelPacket;
import magick.ProfileInfo;
import magick.QuantizeInfo;
import test.MagickWindow;

public class Test {
    private static void displayProfile(ProfileInfo profile) {
        if (profile.getName() == null) {
            System.out.println("Profile name is null");
        } else {
            System.out.println("Profile name is " + profile.getName());
        }
        if (profile.getInfo() == null) {
            System.out.println("No profile info");
        } else {
            System.out.println("Profile length is " + profile.getInfo().length);
        }
    }

    public static void main(String[] args) {
        try {
            Rectangle rect = new Rectangle(0, 0, 80, 40);
            int flags = Magick.parseImageGeometry("60x50", rect);
            System.out.println("Scaled to " + rect.width + "x" + rect.height);
            ImageInfo info = new ImageInfo("pics.jpg");
            info.setPage("50x50+0+0");
            info.setUnits(1);
            info.setColorspace(1);
            info.setBorderColor(PixelPacket.queryColorDatabase("red"));
            MagickImage image = new MagickImage(info);
            image.setImageAttribute("Comment", "Processed by JMagick");
            System.out.println("Colorspace is " + image.getColorspace());
            System.out.println("Resolution units is " + image.getUnits());
            System.out.println("X resolution is " + image.getXResolution());
            System.out.println("Y resolution is " + image.getYResolution());
            System.out.println("Size blob is " + image.sizeBlob());
            System.out.println("Colors " + image.getColors());
            System.out.println("Total colors " + image.getTotalColors());
            image.signatureImage();
            image.setFileName("copy.jpg");
            image.writeImage(info);
            image.setBorderColor(PixelPacket.queryColorDatabase("green"));
            MagickImage borderedImage = image.borderImage(new Rectangle(0, 0, 10, 20));
            borderedImage.setFileName("border.jpg");
            borderedImage.writeImage(info);
            MagickImage raisedImage = new MagickImage(new ImageInfo("pics.jpg"));
            raisedImage.raiseImage(new Rectangle(0, 0, 10, 20), true);
            raisedImage.setFileName("raised.jpg");
            raisedImage.writeImage(info);
            System.out.println("Number of generic profiles " + image.getGenericProfileCount());
            Test.displayProfile(image.getColorProfile());
            image.setColorProfile(new ProfileInfo());
            Test.displayProfile(image.getColorProfile());
            image.setColorProfile(new ProfileInfo("Test", new byte[20]));
            Test.displayProfile(image.getColorProfile());
            MagickImage[] images = new MagickImage[]{image, image};
            MagickImage seqImage = new MagickImage(images);
            MontageInfo montageInfo = new MontageInfo(new ImageInfo());
            montageInfo.setFileName("montage.jpg");
            montageInfo.setTitle("Melbourne");
            montageInfo.setBorderWidth(5);
            MagickImage montage = seqImage.montageImages(montageInfo);
            montage.writeImage(new ImageInfo());
            MagickImage average = seqImage.averageImages();
            average.setFileName("average.jpg");
            average.writeImage(new ImageInfo());
            info = new ImageInfo();
            byte[] blob = image.imageToBlob(info);
            info = new ImageInfo();
            MagickImage blobImage = new MagickImage(info, blob);
            Dimension imageDim = blobImage.getDimension();
            System.out.println("Blob width is " + imageDim.width);
            System.out.println("Blob heght is " + imageDim.height);
            System.out.println(imageDim);
            blobImage.setFileName("blob.jpg");
            blobImage.writeImage(info);
            image.setMagick("GIF");
            blob = image.imageToBlob(info);
            try {
                FileOutputStream out = new FileOutputStream("blob.gif");
                out.write(blob);
                out.close();
            }
            catch (IOException ex) {
                System.out.println("Unable to write blob to file: " + ex);
            }
            image = new MagickImage(new ImageInfo("pics.jpg"));
            MagickImage rotated = image.rotateImage(45.0);
            rotated.setFileName("rotated.jpg");
            rotated.writeImage(info);
            MagickImage sheared = image.shearImage(50.0, 10.0);
            sheared.setFileName("sheared.jpg");
            sheared.writeImage(info);
            MagickImage scaled = image.scaleImage(100, 80);
            scaled.setFileName("scaled.jpg");
            scaled.writeImage(info);
            imageDim = image.getDimension();
            System.out.println("Width is " + imageDim.width);
            System.out.println("Height is " + imageDim.height);
            System.out.println("Depth is " + image.getDepth());
            System.out.println("Storage class is " + image.getStorageClass());
            System.out.println("Comment is \"" + image.getImageAttribute("Comment") + "\"");
            MagickImage clonedImage = image.cloneImage(0, 0, false);
            clonedImage.setFileName("clone.jpg");
            clonedImage.writeImage(info);
            MagickImage quantizedImage = new MagickImage(new ImageInfo("pics.jpg"));
            QuantizeInfo quantizeInfo = new QuantizeInfo();
            quantizeInfo.setColorspace(2);
            quantizeInfo.setNumberColors(256);
            quantizeInfo.setTreeDepth(4);
            System.out.println("QuantizeImage " + quantizedImage.quantizeImage(quantizeInfo));
            System.out.println("Colors " + quantizedImage.getColors());
            System.out.println("Total colors " + quantizedImage.getTotalColors());
            quantizedImage.setFileName("quantized.png");
            quantizedImage.writeImage(info);
            MagickImage blankImage = new MagickImage();
            byte[] pixels = new byte[80000];
            int i = 0;
            while (i < 20000) {
                pixels[4 * i] = -1;
                pixels[4 * i + 1] = -1;
                pixels[4 * i + 2] = -1;
                pixels[4 * i + 3] = 0;
                ++i;
            }
            blankImage.constituteImage(200, 100, "RGBA", pixels);
            DrawInfo drawInfo = new DrawInfo(new ImageInfo());
            drawInfo.setPrimitive("Rectangle 10 10 190 90");
            drawInfo.setStroke(PixelPacket.queryColorDatabase("red"));
            drawInfo.setFill(PixelPacket.queryColorDatabase("white"));
            blankImage.drawImage(drawInfo);
            ImageInfo blankImageInfo = new ImageInfo();
            DrawInfo annotateInfo = new DrawInfo(blankImageInfo);
            annotateInfo.setOpacity(0);
            annotateInfo.setFont("fixed");
            annotateInfo.setFill(PixelPacket.queryColorDatabase("green"));
            annotateInfo.setText("Hello");
            annotateInfo.setGeometry("+30+30");
            blankImage.annotateImage(annotateInfo);
            blankImage.setFileName("blank.jpg");
            blankImage.writeImage(info);
            blankImage.transparentImage(PixelPacket.queryColorDatabase("white"), 65535);
            blankImage.setFileName("transparent.png");
            blankImage.writeImage(info);
            rect = new Rectangle(20, 20, 150, 120);
            MagickImage cropped = image.cropImage(rect);
            cropped.setFileName("cropped.jpg");
            cropped.writeImage(info);
            rect = new Rectangle(0, 0, 150, 120);
            MagickImage chopped = image.chopImage(rect);
            chopped.setFileName("chopped.jpg");
            chopped.writeImage(info);
            MagickImage sharpened = image.sharpenImage(1.0, 5.0);
            sharpened.setFileName("sharpened.jpg");
            sharpened.writeImage(info);
            MagickImage despeckled = image.despeckleImage();
            despeckled.setFileName("despeckled.jpg");
            despeckled.writeImage(info);
            double[] kernel = new double[9];
            int i2 = 0;
            while (i2 < 9) {
                kernel[i2] = 1.0;
                ++i2;
            }
            kernel[4] = 2.0;
            MagickImage convolvedImage = image.convolveImage(3, kernel);
            convolvedImage.setFileName("convolved.jpg");
            convolvedImage.writeImage(info);
            MagickWindow window = new MagickWindow(image);
            window.show();
            MagickInfo minfo = new MagickInfo("JPEG");
            System.out.println("JPG description: " + minfo.getDescription());
        }
        catch (MagickApiException ex) {
            System.err.println("MagickException: " + ex + ": " + ex.getReason() + ", " + ex.getDescription());
        }
        catch (MagickException ex) {
            System.err.println("MagickException: " + ex);
        }
    }
}

