/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.AbstractPartial;
import org.joda.time.field.AbstractPartialFieldProperty;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class Partial
extends AbstractPartial
implements ReadablePartial,
Serializable {
    private static final long serialVersionUID = 12324121189002L;
    private final Chronology iChronology;
    private final DateTimeFieldType[] iTypes;
    private final int[] iValues;
    private transient DateTimeFormatter[] iFormatter;

    public Partial() {
        this((Chronology)null);
    }

    public Partial(Chronology chrono) {
        this.iChronology = DateTimeUtils.getChronology(chrono).withUTC();
        this.iTypes = new DateTimeFieldType[0];
        this.iValues = new int[0];
    }

    public Partial(DateTimeFieldType type, int value) {
        this(type, value, null);
    }

    public Partial(DateTimeFieldType type, int value, Chronology chronology) {
        this.iChronology = chronology = DateTimeUtils.getChronology(chronology).withUTC();
        if (type == null) {
            throw new IllegalArgumentException("The field type must not be null");
        }
        this.iTypes = new DateTimeFieldType[]{type};
        this.iValues = new int[]{value};
        chronology.validate(this, this.iValues);
    }

    public Partial(DateTimeFieldType[] types, int[] values) {
        this(types, values, null);
    }

    public Partial(DateTimeFieldType[] types, int[] values, Chronology chronology) {
        this.iChronology = chronology = DateTimeUtils.getChronology(chronology).withUTC();
        if (types == null) {
            throw new IllegalArgumentException("Types array must not be null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Values array must not be null");
        }
        if (values.length != types.length) {
            throw new IllegalArgumentException("Values array must be the same length as the types array");
        }
        if (types.length == 0) {
            this.iTypes = types;
            this.iValues = values;
            return;
        }
        int i = 0;
        while (i < types.length) {
            if (types[i] == null) {
                throw new IllegalArgumentException("Types array must not contain null: index " + i);
            }
            ++i;
        }
        DurationField lastUnitField = null;
        int i2 = 0;
        while (i2 < types.length) {
            DateTimeFieldType loopType = types[i2];
            DurationField loopUnitField = loopType.getDurationType().getField(this.iChronology);
            if (i2 > 0) {
                int compare = lastUnitField.compareTo(loopUnitField);
                if (compare < 0 || compare != 0 && !loopUnitField.isSupported()) {
                    throw new IllegalArgumentException("Types array must be in order largest-smallest: " + types[i2 - 1].getName() + " < " + loopType.getName());
                }
                if (compare == 0) {
                    if (types[i2 - 1].getRangeDurationType() == null) {
                        if (loopType.getRangeDurationType() == null) {
                            throw new IllegalArgumentException("Types array must not contain duplicate: " + loopType.getName());
                        }
                    } else {
                        DurationField loopRangeField;
                        if (loopType.getRangeDurationType() == null) {
                            throw new IllegalArgumentException("Types array must be in order largest-smallest: " + types[i2 - 1].getName() + " < " + loopType.getName());
                        }
                        DurationField lastRangeField = types[i2 - 1].getRangeDurationType().getField(this.iChronology);
                        if (lastRangeField.compareTo(loopRangeField = loopType.getRangeDurationType().getField(this.iChronology)) < 0) {
                            throw new IllegalArgumentException("Types array must be in order largest-smallest: " + types[i2 - 1].getName() + " < " + loopType.getName());
                        }
                        if (lastRangeField.compareTo(loopRangeField) == 0) {
                            throw new IllegalArgumentException("Types array must not contain duplicate: " + loopType.getName());
                        }
                    }
                }
            }
            lastUnitField = loopUnitField;
            ++i2;
        }
        this.iTypes = (DateTimeFieldType[])types.clone();
        chronology.validate(this, values);
        this.iValues = (int[])values.clone();
    }

    public Partial(ReadablePartial partial) {
        if (partial == null) {
            throw new IllegalArgumentException("The partial must not be null");
        }
        this.iChronology = DateTimeUtils.getChronology(partial.getChronology()).withUTC();
        this.iTypes = new DateTimeFieldType[partial.size()];
        this.iValues = new int[partial.size()];
        int i = 0;
        while (i < partial.size()) {
            this.iTypes[i] = partial.getFieldType(i);
            this.iValues[i] = partial.getValue(i);
            ++i;
        }
    }

    Partial(Partial partial, int[] values) {
        this.iChronology = partial.iChronology;
        this.iTypes = partial.iTypes;
        this.iValues = values;
    }

    Partial(Chronology chronology, DateTimeFieldType[] types, int[] values) {
        this.iChronology = chronology;
        this.iTypes = types;
        this.iValues = values;
    }

    public int size() {
        return this.iTypes.length;
    }

    public Chronology getChronology() {
        return this.iChronology;
    }

    protected DateTimeField getField(int index, Chronology chrono) {
        return this.iTypes[index].getField(chrono);
    }

    public DateTimeFieldType getFieldType(int index) {
        return this.iTypes[index];
    }

    public DateTimeFieldType[] getFieldTypes() {
        return (DateTimeFieldType[])this.iTypes.clone();
    }

    public int getValue(int index) {
        return this.iValues[index];
    }

    public int[] getValues() {
        return (int[])this.iValues.clone();
    }

    public Partial withChronologyRetainFields(Chronology newChronology) {
        newChronology = DateTimeUtils.getChronology(newChronology);
        if ((newChronology = newChronology.withUTC()) == this.getChronology()) {
            return this;
        }
        Partial newPartial = new Partial(newChronology, this.iTypes, this.iValues);
        newChronology.validate(newPartial, this.iValues);
        return newPartial;
    }

    public Partial with(DateTimeFieldType fieldType, int value) {
        if (fieldType == null) {
            throw new IllegalArgumentException("The field type must not be null");
        }
        int index = this.indexOf(fieldType);
        if (index == -1) {
            DateTimeFieldType[] newTypes = new DateTimeFieldType[this.iTypes.length + 1];
            int[] newValues = new int[newTypes.length];
            int i = 0;
            DurationField unitField = fieldType.getDurationType().getField(this.iChronology);
            if (unitField.isSupported()) {
                while (i < this.iTypes.length) {
                    DurationField loopRangeField;
                    DurationField rangeField;
                    int compare;
                    DateTimeFieldType loopType = this.iTypes[i];
                    DurationField loopUnitField = loopType.getDurationType().getField(this.iChronology);
                    if (loopUnitField.isSupported() && ((compare = unitField.compareTo(loopUnitField)) > 0 || compare == 0 && (rangeField = fieldType.getRangeDurationType().getField(this.iChronology)).compareTo(loopRangeField = loopType.getRangeDurationType().getField(this.iChronology)) > 0)) break;
                    ++i;
                }
            }
            System.arraycopy(this.iTypes, 0, newTypes, 0, i);
            System.arraycopy(this.iValues, 0, newValues, 0, i);
            newTypes[i] = fieldType;
            newValues[i] = value;
            System.arraycopy(this.iTypes, i, newTypes, i + 1, newTypes.length - i - 1);
            System.arraycopy(this.iValues, i, newValues, i + 1, newValues.length - i - 1);
            Partial newPartial = new Partial(this.iChronology, newTypes, newValues);
            this.iChronology.validate(newPartial, newValues);
            return newPartial;
        }
        if (value == this.getValue(index)) {
            return this;
        }
        int[] newValues = this.getValues();
        newValues = this.getField(index).set(this, index, newValues, value);
        return new Partial(this, newValues);
    }

    public Partial without(DateTimeFieldType fieldType) {
        int index = this.indexOf(fieldType);
        if (index != -1) {
            DateTimeFieldType[] newTypes = new DateTimeFieldType[this.size() - 1];
            int[] newValues = new int[this.size() - 1];
            System.arraycopy(this.iTypes, 0, newTypes, 0, index);
            System.arraycopy(this.iTypes, index + 1, newTypes, index, newTypes.length - index);
            System.arraycopy(this.iValues, 0, newValues, 0, index);
            System.arraycopy(this.iValues, index + 1, newValues, index, newValues.length - index);
            Partial newPartial = new Partial(this.iChronology, newTypes, newValues);
            this.iChronology.validate(newPartial, newValues);
            return newPartial;
        }
        return this;
    }

    public Partial withField(DateTimeFieldType fieldType, int value) {
        int index = this.indexOfSupported(fieldType);
        if (value == this.getValue(index)) {
            return this;
        }
        int[] newValues = this.getValues();
        newValues = this.getField(index).set(this, index, newValues, value);
        return new Partial(this, newValues);
    }

    public Partial withFieldAdded(DurationFieldType fieldType, int amount) {
        int index = this.indexOfSupported(fieldType);
        if (amount == 0) {
            return this;
        }
        int[] newValues = this.getValues();
        newValues = this.getField(index).add(this, index, newValues, amount);
        return new Partial(this, newValues);
    }

    public Partial withFieldAddWrapped(DurationFieldType fieldType, int amount) {
        int index = this.indexOfSupported(fieldType);
        if (amount == 0) {
            return this;
        }
        int[] newValues = this.getValues();
        newValues = this.getField(index).addWrapPartial(this, index, newValues, amount);
        return new Partial(this, newValues);
    }

    public Partial withPeriodAdded(ReadablePeriod period, int scalar) {
        if (period == null || scalar == 0) {
            return this;
        }
        int[] newValues = this.getValues();
        int i = 0;
        while (i < period.size()) {
            DurationFieldType fieldType = period.getFieldType(i);
            int index = this.indexOf(fieldType);
            if (index >= 0) {
                newValues = this.getField(index).add(this, index, newValues, FieldUtils.safeMultiply(period.getValue(i), scalar));
            }
            ++i;
        }
        return new Partial(this, newValues);
    }

    public Partial plus(ReadablePeriod period) {
        return this.withPeriodAdded(period, 1);
    }

    public Partial minus(ReadablePeriod period) {
        return this.withPeriodAdded(period, -1);
    }

    public Property property(DateTimeFieldType type) {
        return new Property(this, this.indexOfSupported(type));
    }

    public boolean isMatch(ReadableInstant instant) {
        long millis = DateTimeUtils.getInstantMillis(instant);
        Chronology chrono = DateTimeUtils.getInstantChronology(instant);
        int i = 0;
        while (i < this.iTypes.length) {
            int value = this.iTypes[i].getField(chrono).get(millis);
            if (value != this.iValues[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public DateTimeFormatter getFormatter() {
        DateTimeFormatter[] f = this.iFormatter;
        if (f == null) {
            if (this.size() == 0) {
                return null;
            }
            f = new DateTimeFormatter[2];
            try {
                ArrayList<DateTimeFieldType> list = new ArrayList<DateTimeFieldType>(Arrays.asList(this.iTypes));
                f[0] = ISODateTimeFormat.forFields(list, true, false);
                if (list.size() == 0) {
                    f[1] = f[0];
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.iFormatter = f;
        }
        return f[0];
    }

    public String toString() {
        DateTimeFormatter f1;
        DateTimeFormatter[] f = this.iFormatter;
        if (f == null) {
            this.getFormatter();
            f = this.iFormatter;
            if (f == null) {
                return this.toStringList();
            }
        }
        if ((f1 = f[1]) == null) {
            return this.toStringList();
        }
        return f1.print(this);
    }

    public String toStringList() {
        int size = this.size();
        StringBuffer buf = new StringBuffer(20 * size);
        buf.append('[');
        int i = 0;
        while (i < size) {
            if (i > 0) {
                buf.append(',').append(' ');
            }
            buf.append(this.iTypes[i].getName());
            buf.append('=');
            buf.append(this.iValues[i]);
            ++i;
        }
        buf.append(']');
        return buf.toString();
    }

    public String toString(String pattern) {
        if (pattern == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(pattern).print(this);
    }

    public String toString(String pattern, Locale locale) {
        if (pattern == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(pattern).withLocale(locale).print(this);
    }

    public static class Property
    extends AbstractPartialFieldProperty
    implements Serializable {
        private static final long serialVersionUID = 53278362873888L;
        private final Partial iPartial;
        private final int iFieldIndex;

        Property(Partial partial, int fieldIndex) {
            this.iPartial = partial;
            this.iFieldIndex = fieldIndex;
        }

        public DateTimeField getField() {
            return this.iPartial.getField(this.iFieldIndex);
        }

        protected ReadablePartial getReadablePartial() {
            return this.iPartial;
        }

        public Partial getPartial() {
            return this.iPartial;
        }

        public int get() {
            return this.iPartial.getValue(this.iFieldIndex);
        }

        public Partial addToCopy(int valueToAdd) {
            int[] newValues = this.iPartial.getValues();
            newValues = this.getField().add(this.iPartial, this.iFieldIndex, newValues, valueToAdd);
            return new Partial(this.iPartial, newValues);
        }

        public Partial addWrapFieldToCopy(int valueToAdd) {
            int[] newValues = this.iPartial.getValues();
            newValues = this.getField().addWrapField(this.iPartial, this.iFieldIndex, newValues, valueToAdd);
            return new Partial(this.iPartial, newValues);
        }

        public Partial setCopy(int value) {
            int[] newValues = this.iPartial.getValues();
            newValues = this.getField().set(this.iPartial, this.iFieldIndex, newValues, value);
            return new Partial(this.iPartial, newValues);
        }

        public Partial setCopy(String text, Locale locale) {
            int[] newValues = this.iPartial.getValues();
            newValues = this.getField().set(this.iPartial, this.iFieldIndex, newValues, text, locale);
            return new Partial(this.iPartial, newValues);
        }

        public Partial setCopy(String text) {
            return this.setCopy(text, null);
        }

        public Partial withMaximumValue() {
            return this.setCopy(this.getMaximumValue());
        }

        public Partial withMinimumValue() {
            return this.setCopy(this.getMinimumValue());
        }
    }
}

