/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.FieldUtils;

public final class ZeroIsMaxDateTimeField
extends DecoratedDateTimeField {
    private static final long serialVersionUID = 961749798233026866L;

    public ZeroIsMaxDateTimeField(DateTimeField field, DateTimeFieldType type) {
        super(field, type);
        if (field.getMinimumValue() != 0) {
            throw new IllegalArgumentException("Wrapped field's minumum value must be zero");
        }
    }

    public int get(long instant) {
        int value = this.getWrappedField().get(instant);
        if (value == 0) {
            value = this.getMaximumValue();
        }
        return value;
    }

    public long add(long instant, int value) {
        return this.getWrappedField().add(instant, value);
    }

    public long add(long instant, long value) {
        return this.getWrappedField().add(instant, value);
    }

    public long addWrapField(long instant, int value) {
        return this.getWrappedField().addWrapField(instant, value);
    }

    public int[] addWrapField(ReadablePartial instant, int fieldIndex, int[] values, int valueToAdd) {
        return this.getWrappedField().addWrapField(instant, fieldIndex, values, valueToAdd);
    }

    public int getDifference(long minuendInstant, long subtrahendInstant) {
        return this.getWrappedField().getDifference(minuendInstant, subtrahendInstant);
    }

    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        return this.getWrappedField().getDifferenceAsLong(minuendInstant, subtrahendInstant);
    }

    public long set(long instant, int value) {
        int max = this.getMaximumValue();
        FieldUtils.verifyValueBounds(this, value, 1, max);
        if (value == max) {
            value = 0;
        }
        return this.getWrappedField().set(instant, value);
    }

    public boolean isLeap(long instant) {
        return this.getWrappedField().isLeap(instant);
    }

    public int getLeapAmount(long instant) {
        return this.getWrappedField().getLeapAmount(instant);
    }

    public DurationField getLeapDurationField() {
        return this.getWrappedField().getLeapDurationField();
    }

    public int getMinimumValue() {
        return 1;
    }

    public int getMinimumValue(long instant) {
        return 1;
    }

    public int getMinimumValue(ReadablePartial instant) {
        return 1;
    }

    public int getMinimumValue(ReadablePartial instant, int[] values) {
        return 1;
    }

    public int getMaximumValue() {
        return this.getWrappedField().getMaximumValue() + 1;
    }

    public int getMaximumValue(long instant) {
        return this.getWrappedField().getMaximumValue(instant) + 1;
    }

    public int getMaximumValue(ReadablePartial instant) {
        return this.getWrappedField().getMaximumValue(instant) + 1;
    }

    public int getMaximumValue(ReadablePartial instant, int[] values) {
        return this.getWrappedField().getMaximumValue(instant, values) + 1;
    }

    public long roundFloor(long instant) {
        return this.getWrappedField().roundFloor(instant);
    }

    public long roundCeiling(long instant) {
        return this.getWrappedField().roundCeiling(instant);
    }

    public long roundHalfFloor(long instant) {
        return this.getWrappedField().roundHalfFloor(instant);
    }

    public long roundHalfCeiling(long instant) {
        return this.getWrappedField().roundHalfCeiling(instant);
    }

    public long roundHalfEven(long instant) {
        return this.getWrappedField().roundHalfEven(instant);
    }

    public long remainder(long instant) {
        return this.getWrappedField().remainder(instant);
    }
}

