/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.deployment;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.deployment.FSDeploymentRunnable;
import org.alfresco.deployment.StreamDigester;
import org.alfresco.deployment.impl.server.DeployedFile;
import org.alfresco.deployment.impl.server.Deployment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgramRunnable
implements FSDeploymentRunnable {
    private static final long serialVersionUID = -6694971994859005513L;
    private Deployment fDeployment;
    private String fProgram;
    private String fDirectory;
    private List<String> fArguments = new ArrayList<String>();

    ProgramRunnable() {
    }

    @Override
    public void init(Deployment deployment) {
        this.fDeployment = deployment;
    }

    public void setProgram(String program) {
        this.fProgram = program;
    }

    public void setDirectory(String directory) {
        this.fDirectory = directory;
    }

    public void setArguments(List<String> arguments) {
        this.fArguments = arguments;
    }

    @Override
    public void run() {
        try {
            File tempFile = File.createTempFile("deployment", "txt");
            FileWriter out = new FileWriter(tempFile);
            for (DeployedFile file : this.fDeployment) {
                out.write(file.getType().toString() + " '" + file.getPath().replaceAll("'", "\\\\'") + "' " + file.getGuid() + "\n");
            }
            ((Writer)out).close();
            Runtime runTime = Runtime.getRuntime();
            int commandLength = 2 + this.fArguments.size();
            String[] command = new String[commandLength];
            command[0] = this.fProgram;
            command[1] = tempFile.getAbsolutePath();
            int off = 2;
            for (String arg : this.fArguments) {
                command[off++] = arg;
            }
            Map<String, String> envMap = System.getenv();
            String[] env = new String[envMap.size()];
            off = 0;
            for (Map.Entry<String, String> entry : envMap.entrySet()) {
                env[off++] = entry.getKey() + '=' + entry.getValue();
            }
            Process process = runTime.exec(command, env, new File(this.fDirectory));
            StreamDigester errorDigester = new StreamDigester(process.getErrorStream());
            StreamDigester outputDigester = new StreamDigester(process.getInputStream());
            errorDigester.start();
            outputDigester.start();
            process.waitFor();
            tempFile.delete();
        }
        catch (IOException ie) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

