/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.deployment.impl.fsr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.alfresco.deployment.DeploymentTarget;
import org.alfresco.deployment.FSDeploymentRunnable;
import org.alfresco.deployment.FileDescriptor;
import org.alfresco.deployment.FileType;
import org.alfresco.deployment.PathUtil;
import org.alfresco.deployment.impl.DeploymentException;
import org.alfresco.deployment.impl.fsr.CommitThread;
import org.alfresco.deployment.impl.fsr.FileSystemReceiverService;
import org.alfresco.deployment.impl.fsr.ValidateCommand;
import org.alfresco.deployment.impl.server.DeployedFile;
import org.alfresco.deployment.impl.server.Deployment;
import org.alfresco.deployment.impl.server.DeploymentReceiverAuthenticator;
import org.alfresco.deployment.impl.server.DeploymentState;
import org.alfresco.deployment.impl.server.Target;
import org.alfresco.util.Deleter;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemDeploymentTarget
implements Serializable,
DeploymentTarget {
    private static final long serialVersionUID = 1257869549338878302L;
    private boolean isBusy = false;
    private Map<String, Deployment> fDeployments = Collections.synchronizedMap(new HashMap());
    Target metaDataTarget = null;
    private static Log logger = LogFactory.getLog(FileSystemDeploymentTarget.class);
    private String fTargetName;
    private String fRootDirectory;
    private String fMetaDataDirectory;
    private DeploymentReceiverAuthenticator authenticator;
    private boolean autoFix = true;
    private List<FSDeploymentRunnable> postCommit;
    private List<FSDeploymentRunnable> prepare;
    private FileSystemReceiverService fileSystemReceiverService;
    private ValidateCommand validateMeCommand = new ValidateCommand(this);

    public void setAuthenticator(DeploymentReceiverAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public DeploymentReceiverAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public void init() {
        File meta;
        PropertyCheck.mandatory((Object)this, (String)"authenticator", (Object)this.authenticator);
        PropertyCheck.mandatory((Object)this, (String)"rootDirectory", (Object)this.fRootDirectory);
        PropertyCheck.mandatory((Object)this, (String)"metaDataDirectory", (Object)this.fMetaDataDirectory);
        PropertyCheck.mandatory((Object)this, (String)"fileSystemReceiverService", (Object)this.fileSystemReceiverService);
        File rootFile = new File(this.fRootDirectory);
        if (!rootFile.exists()) {
            logger.info((Object)("creating root data directory:" + rootFile.toString()));
            rootFile.mkdirs();
        }
        if (!(meta = new File(this.fMetaDataDirectory)).exists()) {
            logger.info((Object)("creating meta data directory:" + meta.toString()));
            meta.mkdirs();
        }
        this.metaDataTarget = new Target(this.fTargetName, this.fMetaDataDirectory);
        this.fileSystemReceiverService.queueCommand(this.validateMeCommand);
    }

    public String getName() {
        return this.fTargetName;
    }

    public void setName(String name) {
        this.fTargetName = name;
    }

    public String getRootDirectory() {
        return this.fRootDirectory;
    }

    public void setRootDirectory(String root) {
        this.fRootDirectory = root;
    }

    public void setAutoFix(boolean autoFix) {
        this.autoFix = autoFix;
    }

    public boolean isAutoFix() {
        return this.autoFix;
    }

    public void setFileSystemReceiverService(FileSystemReceiverService fileSystemReceiverService) {
        this.fileSystemReceiverService = fileSystemReceiverService;
    }

    public FileSystemReceiverService getFileSystemReceiverService() {
        return this.fileSystemReceiverService;
    }

    @Override
    public synchronized String begin(String targetName, String storeName, int version, String user, char[] password) {
        if (!this.authenticator.logon(user, password)) {
            logger.warn((Object)"Invalid user name or password");
            throw new DeploymentException("Invalid user name or password.");
        }
        File root = new File(this.getRootDirectory());
        if (!root.exists()) {
            throw new DeploymentException("Root directory does not exist. rootDirectory:" + this.getRootDirectory());
        }
        String ticket = GUID.generate();
        logger.debug((Object)("begin deploy, target:" + targetName + ", ticket:" + ticket));
        try {
            Deployment deployment = new Deployment(ticket, targetName, storeName, version);
            this.fDeployments.put(ticket, deployment);
        }
        catch (IOException e) {
            logger.error((Object)"Could not create logfile", (Throwable)e);
            throw new DeploymentException("Could not create logfile; Deployment cannot continue", e);
        }
        this.setBusy(true);
        return ticket;
    }

    @Override
    public void prepare(String ticket) {
        logger.info((Object)("Prepare ticket: " + ticket));
        Deployment deployment = this.fDeployments.get(ticket);
        if (deployment == null) {
            logger.debug((Object)("Could not prepare: invalid token ticket:" + ticket));
            return;
        }
        if (deployment.getState() != DeploymentState.WORKING) {
            throw new DeploymentException("Deployment cannot be prepared: already aborting, or committing.");
        }
        try {
            this.metaDataTarget.cloneMetaData(deployment);
            if (this.prepare != null && this.prepare.size() > 0) {
                for (FSDeploymentRunnable runnable : this.prepare) {
                    try {
                        runnable.init(deployment);
                        runnable.run();
                    }
                    catch (Throwable t) {
                        String msg = "Error thrown in prepare; rolled back";
                        if (t.getCause() != null) {
                            msg = msg + " :" + t.getCause().getMessage();
                        }
                        logger.error((Object)msg, t);
                        throw new DeploymentException(msg, t);
                    }
                }
            }
            deployment.prepare();
            logger.debug((Object)("prepared successfully ticket:" + ticket));
        }
        catch (IOException e) {
            logger.error((Object)("Error while preparing ticket:" + ticket), (Throwable)e);
            throw new DeploymentException("Could not prepare.", e);
        }
    }

    @Override
    public void abort(String ticket) {
        logger.info((Object)("Abort ticket: " + ticket));
        Deployment deployment = this.fDeployments.get(ticket);
        if (deployment == null) {
            logger.debug((Object)("Could not abort: invalid token ticket:" + ticket));
            return;
        }
        if (deployment.getState() != DeploymentState.WORKING && deployment.getState() != DeploymentState.PREPARED) {
            throw new DeploymentException("Deployment cannot be aborted: already aborting, or committing.");
        }
        try {
            deployment.abort();
            for (DeployedFile file : deployment) {
                if (file.getType() != FileType.FILE) continue;
                File toDelete = new File(file.getPreLocation());
                toDelete.delete();
            }
            this.metaDataTarget.rollbackMetaData();
        }
        catch (IOException e) {
            logger.error((Object)("Error while aborting ticket:" + ticket), (Throwable)e);
            throw new DeploymentException("Could not abort.", e);
        }
        finally {
            this.setBusy(false);
            this.fDeployments.remove(ticket);
            if (deployment.isMetaError()) {
                this.fileSystemReceiverService.queueCommand(this.validateMeCommand);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(String ticket) {
        Deployment deployment = this.fDeployments.get(ticket);
        if (deployment == null) {
            String msg = "Could not commit because invalid ticket:" + ticket;
            logger.error((Object)msg);
            throw new DeploymentException(msg);
        }
        if (deployment.getState() != DeploymentState.PREPARED) {
            throw new DeploymentException("Deployment cannot be committed: not prepared.");
        }
        logger.debug((Object)("commit ticket:" + ticket));
        try {
            int i;
            LinkedBlockingQueue<DeployedFile> commitQueue = new LinkedBlockingQueue<DeployedFile>();
            CommitThread[] commitThreads = new CommitThread[]{new CommitMetadataThread(this.metaDataTarget, deployment), new CommitWriterThread(this.metaDataTarget, deployment, commitQueue), new CommitWriterThread(this.metaDataTarget, deployment, commitQueue), new CommitWriterThread(this.metaDataTarget, deployment, commitQueue)};
            logger.debug((Object)"starting deployment.");
            try {
                for (int i2 = 0; i2 < commitThreads.length; ++i2) {
                    commitThreads[i2].start();
                }
                block17: for (DeployedFile file : deployment) {
                    String path = file.getPath();
                    switch (file.getType()) {
                        case DIR: {
                            File f = PathUtil.getFileForPath(this.fRootDirectory, path);
                            if (f.exists()) {
                                if (!f.isFile()) continue block17;
                                File dest = new File(f.getAbsolutePath() + ".alf");
                                f.renameTo(dest);
                                f = PathUtil.getFileForPath(this.fRootDirectory, path);
                                f.mkdir();
                                continue block17;
                            }
                            f.mkdir();
                            continue block17;
                        }
                        case FILE: {
                            commitQueue.add(file);
                            continue block17;
                        }
                        case DELETED: {
                            commitQueue.add(file);
                            continue block17;
                        }
                        case SETGUID: {
                            continue block17;
                        }
                    }
                    logger.error((Object)("Internal error: unknown file type: " + file.getType()));
                    throw new DeploymentException("Internal error: unknown file type: " + file.getType());
                }
            }
            finally {
                for (i = 0; i < commitThreads.length; ++i) {
                    commitThreads[i].setFinish();
                }
            }
            for (i = 0; i < commitThreads.length; ++i) {
                commitThreads[i].join();
                if (commitThreads[i].getException() == null) continue;
                throw commitThreads[i].getException();
            }
            logger.debug((Object)"committed - clean up");
            for (DeployedFile file : deployment) {
                if (file.getType() == FileType.FILE) {
                    File intermediate = new File(file.getPreLocation());
                    intermediate.delete();
                }
                File old = new File(PathUtil.getFileForPath(this.fRootDirectory, file.getPath()).getAbsolutePath() + ".alf");
                Deleter.Delete((File)old);
            }
            File preLocation = new File(this.fileSystemReceiverService.getDataDirectory() + File.separatorChar + ticket);
            preLocation.delete();
            deployment.commit();
            if (this.postCommit != null && this.postCommit.size() > 0) {
                for (FSDeploymentRunnable runnable : this.postCommit) {
                    try {
                        runnable.init(deployment);
                        runnable.run();
                    }
                    catch (Throwable t) {
                        logger.error((Object)("Error from postCommit event t:" + t.toString()), t);
                    }
                }
            }
            logger.debug((Object)("commited successfully ticket:" + ticket));
        }
        catch (Exception exception) {
        }
        finally {
            this.setBusy(false);
            if (deployment.isMetaError()) {
                this.fileSystemReceiverService.queueCommand(this.validateMeCommand);
            }
            this.fDeployments.remove(ticket);
        }
    }

    @Override
    public void delete(String ticket, String path) {
        Deployment deployment = this.fDeployments.get(ticket);
        if (deployment == null) {
            String msg = "Could not delete because invalid ticket:" + ticket;
            throw new DeploymentException(msg);
        }
        try {
            File f = PathUtil.getFileForPath(this.fRootDirectory, path);
            boolean exists = f.exists();
            if (!exists) {
                deployment.setMetaError(true);
                logger.warn((Object)("unable to delete, does not exist, path:" + f.getAbsolutePath()));
                if (this.fileSystemReceiverService.isErrorOnOverwrite()) {
                    throw new DeploymentException("unable to delete, does not exist, path:" + f.getAbsolutePath());
                }
            }
            boolean isFile = f.isFile();
            DeployedFile file = new DeployedFile(FileType.DELETED, null, path, null, false, isFile);
            deployment.add(file);
        }
        catch (IOException e) {
            throw new DeploymentException("Could not update log.", e);
        }
    }

    @Override
    public List<FileDescriptor> getListing(String ticket, String path) {
        Deployment deployment = this.fDeployments.get(ticket);
        if (deployment == null) {
            throw new DeploymentException("getListing invalid ticket. ticket:" + ticket);
        }
        try {
            File f = PathUtil.getFileForPath(this.fRootDirectory, path);
            boolean exists = f.exists();
            SortedSet<FileDescriptor> list = this.metaDataTarget.getListing(path);
            if (!exists) {
                throw new DeploymentException("Directory is missing, path:" + f.getAbsolutePath());
            }
            return new ArrayList<FileDescriptor>(list);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not get listing for path:" + path, e);
        }
    }

    @Override
    public void createDirectory(String ticket, String path, String guid, Set<String> aspects, Map<String, Serializable> props) {
        Deployment deployment = this.fDeployments.get(ticket);
        if (deployment == null) {
            throw new DeploymentException("mkdir invalid ticket. ticket:" + ticket);
        }
        File f = PathUtil.getFileForPath(this.fRootDirectory, path);
        boolean exists = f.exists();
        if (exists) {
            deployment.setMetaError(true);
            logger.warn((Object)("writing to pre-existing directory, path:" + f.getAbsolutePath()));
            if (this.fileSystemReceiverService.isErrorOnOverwrite()) {
                throw new DeploymentException("directory already exists, path:" + f.getAbsolutePath());
            }
        }
        DeployedFile file = new DeployedFile(FileType.DIR, null, path, guid, !exists, false);
        try {
            deployment.add(file);
        }
        catch (IOException e) {
            throw new DeploymentException("Could not log mkdir of " + path + " error: " + e.toString(), e);
        }
    }

    @Override
    public OutputStream send(String ticket, boolean create, String path, String guid, String encoding, String mimeType, Set<String> aspects, Map<String, Serializable> props) {
        Deployment deployment = this.fDeployments.get(ticket);
        if (deployment == null) {
            throw new DeploymentException("Deployment timed out or invalid ticket.");
        }
        try {
            String preLocation = this.fileSystemReceiverService.getDataDirectory() + File.separator + guid;
            FileOutputStream out = new FileOutputStream(preLocation);
            File f = PathUtil.getFileForPath(this.fRootDirectory, path);
            boolean exists = f.exists();
            if (this.fileSystemReceiverService.isErrorOnOverwrite()) {
                if (exists) {
                    if (this.metaDataTarget.lookupMetadataFile(f.getParent(), f.getName()) == null) {
                        throw new DeploymentException("file already exists, path:" + f.getAbsolutePath());
                    }
                } else if (!create) {
                    throw new DeploymentException("file to update does not exist, path:" + f.getAbsolutePath());
                }
            }
            DeployedFile file = new DeployedFile(FileType.FILE, preLocation, path, guid, !exists, true);
            deployment.add(file);
            return out;
        }
        catch (IOException e) {
            throw new DeploymentException("Could not send for path:" + path, e);
        }
    }

    @Override
    public void updateDirectory(String ticket, String path, String guid, Set<String> aspects, Map<String, Serializable> props) {
        Deployment deployment = this.fDeployments.get(ticket);
        if (deployment == null) {
            throw new DeploymentException("Deployment invalid ticket.");
        }
        try {
            DeployedFile file = new DeployedFile(FileType.SETGUID, null, path, guid, false, false);
            deployment.add(file);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not set guid on " + path, e);
        }
    }

    public void validate() {
        this.metaDataTarget.validateMetaData(this.fRootDirectory, this.autoFix);
    }

    public void setBusy(boolean isBusy) {
        this.isBusy = isBusy;
    }

    public boolean isBusy() {
        return this.isBusy;
    }

    public void setPostCommit(List<FSDeploymentRunnable> postCommit) {
        this.postCommit = postCommit;
    }

    public List<FSDeploymentRunnable> getPostCommit() {
        return this.postCommit;
    }

    public void setPrepare(List<FSDeploymentRunnable> prepare) {
        this.prepare = prepare;
    }

    public List<FSDeploymentRunnable> getPrepare() {
        return this.prepare;
    }

    @Override
    public int getCurrentVersion(String target, String storeName) {
        return -1;
    }

    public void setMetaDataDirectory(String dir) {
        this.fMetaDataDirectory = dir;
    }

    public String getMetaDataDirectory() {
        return this.fMetaDataDirectory;
    }

    private class CommitMetadataThread
    extends CommitThread {
        private Deployment deployment;
        private Target target;

        CommitMetadataThread(Target target, Deployment deployment) {
            this.target = target;
            this.deployment = deployment;
        }

        public void run() {
            try {
                logger.debug((Object)"commit meta data");
                this.target.commitMetaData(this.deployment);
                logger.debug((Object)"metadata cloned and prepared");
            }
            catch (Exception e) {
                this.setException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CommitWriterThread
    extends CommitThread {
        private LinkedBlockingQueue<DeployedFile> queue;
        private Deployment deployment;
        private Target target;

        CommitWriterThread(Target target, Deployment deployment, LinkedBlockingQueue<DeployedFile> queue) {
            this.target = target;
            this.deployment = deployment;
            this.queue = queue;
        }

        @Override
        public void run() {
            while (this.getException() == null) {
                DeployedFile file = null;
                try {
                    file = this.queue.poll(3L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e1) {
                    logger.debug((Object)"interrupted");
                }
                if (file == null) {
                    if (!this.isFinish()) continue;
                    logger.debug((Object)"committer thread finished normally");
                    break;
                }
                try {
                    String path = file.getPath();
                    switch (file.getType()) {
                        case FILE: {
                            File dest;
                            logger.debug((Object)("add file:" + path));
                            File f = PathUtil.getFileForPath(FileSystemDeploymentTarget.this.fRootDirectory, path);
                            if (f.exists()) {
                                dest = new File(f.getAbsolutePath() + ".alf");
                                f.renameTo(dest);
                                f = PathUtil.getFileForPath(FileSystemDeploymentTarget.this.fRootDirectory, path);
                            }
                            FileOutputStream out = new FileOutputStream(f);
                            FileInputStream in = new FileInputStream(file.getPreLocation());
                            FileChannel outChannel = out.getChannel();
                            FileChannel inChannel = in.getChannel();
                            int chunkSize = 0x100000;
                            long size = inChannel.size();
                            for (long position = 0L; position < size; position += inChannel.transferTo(position, chunkSize, outChannel)) {
                            }
                            in.close();
                            out.flush();
                            out.close();
                            break;
                        }
                        case DELETED: {
                            logger.debug((Object)("delete file:" + path));
                            File f = PathUtil.getFileForPath(FileSystemDeploymentTarget.this.fRootDirectory, path);
                            if (!f.exists()) break;
                            File dest = new File(f.getAbsolutePath() + ".alf");
                            f.renameTo(dest);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    logger.debug((Object)"exception in committer thread", (Throwable)e);
                    this.setException(e);
                }
            }
        }
    }
}

