/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.deployment.transformers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.alfresco.deployment.transformers.CompressionTransformer;
import org.alfresco.deployment.transformers.SampleEncryptionTransformer;

public class SampleEncryptionTransformerTest
extends TestCase {
    public SampleEncryptionTransformerTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSetProperties() {
        SampleEncryptionTransformer transformer = new SampleEncryptionTransformer();
        String password = "Frobscottle";
        transformer.setPassword(password);
        String cipherName = "PBEWithMD5AndDESAndTripleDES";
        transformer.setPassword(password);
        int iterations = 99;
        transformer.setPassword(password);
        transformer.setCipherName(cipherName);
        transformer.setIterationCount(iterations);
        SampleEncryptionTransformerTest.assertEquals((String)transformer.getPassword(), (String)password);
        SampleEncryptionTransformerTest.assertEquals((String)transformer.getCipherName(), (String)cipherName);
        SampleEncryptionTransformerTest.assertEquals((int)transformer.getIterationCount(), (int)iterations);
    }

    public void testAddFilter() {
        SampleEncryptionTransformer transformer = new SampleEncryptionTransformer();
        transformer.setPassword("Welcome To Hades");
        transformer.setCipherName("PBEWithMD5AndDES");
        String path = "wibble";
        ByteArrayOutputStream compressed = new ByteArrayOutputStream();
        OutputStream out = null;
        out = transformer.addFilter(compressed, path, null, null);
        SampleEncryptionTransformerTest.assertNotNull((String)"null output stream returned", (Object)compressed);
        String clearText = "hello world";
        try {
            out.write(clearText.getBytes());
        }
        catch (IOException ie) {
            SampleEncryptionTransformerTest.fail((String)("unexpected exception thrown" + ie.toString()));
        }
        try {
            out.flush();
            out.close();
        }
        catch (IOException ie) {
            SampleEncryptionTransformerTest.fail((String)("unexpected exception thrown, " + ie.toString()));
        }
        assert (compressed.size() > 0);
        InputStream decompress = null;
        ByteArrayInputStream compressedStream = new ByteArrayInputStream(compressed.toByteArray());
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        decompress = transformer.addFilter(compressedStream, "wibble", null, null);
        try {
            int readLen;
            byte[] readBuffer = new byte[1002];
            while ((readLen = decompress.read(readBuffer)) > 0) {
                result.write(readBuffer, 0, readLen);
            }
        }
        catch (IOException ie) {
            SampleEncryptionTransformerTest.fail((String)("unexpected exception thrown, " + ie.toString()));
        }
        SampleEncryptionTransformerTest.assertTrue((boolean)result.toString().equalsIgnoreCase(clearText));
    }

    public void testEncryptDecryptBigMessage() {
        String sampleData = "Ring-a-ring a roses, a pocket full of posies, atishoo, atishoo, we all fall down. ";
        CompressionTransformer transformer = new CompressionTransformer();
        String path = "wibble";
        ByteArrayOutputStream compressed = new ByteArrayOutputStream();
        OutputStream out = transformer.addFilter(compressed, path, null, null);
        SampleEncryptionTransformerTest.assertNotNull((String)"null output stream returned", (Object)out);
        StringBuffer clearText = new StringBuffer();
        for (int i = 0; i < 1000; ++i) {
            clearText.append(sampleData);
        }
        try {
            out.write(clearText.toString().getBytes());
        }
        catch (IOException ie) {
            SampleEncryptionTransformerTest.fail((String)("unexpected exception thrown, " + ie.toString()));
        }
        try {
            out.flush();
            out.close();
        }
        catch (IOException ie) {
            SampleEncryptionTransformerTest.fail((String)("unexpected exception thrown, " + ie.toString()));
        }
        InputStream decompress = null;
        ByteArrayInputStream compressedStream = new ByteArrayInputStream(compressed.toByteArray());
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        decompress = transformer.addFilter(compressedStream, "wibble", null, null);
        try {
            int readLen;
            byte[] readBuffer = new byte[1002];
            while ((readLen = decompress.read(readBuffer)) > 0) {
                result.write(readBuffer, 0, readLen);
            }
        }
        catch (IOException ie) {
            SampleEncryptionTransformerTest.fail((String)("unexpected exception thrown, " + ie.toString()));
        }
        String resultStr = result.toString();
        SampleEncryptionTransformerTest.assertTrue((resultStr.length() == clearText.length() ? 1 : 0) != 0);
        SampleEncryptionTransformerTest.assertTrue((boolean)resultStr.toString().equalsIgnoreCase(clearText.toString()));
    }

    public void testEncryptDecryptManySends() {
        String sampleData = "Ring-a-ring a roses, a pocket full of posies, atishoo, atishoo, we all fall down.";
        CompressionTransformer transformer = new CompressionTransformer();
        String path = "wibble";
        int numberOfSends = 137;
        ByteArrayOutputStream compressed = new ByteArrayOutputStream();
        OutputStream out = transformer.addFilter(compressed, path, null, null);
        SampleEncryptionTransformerTest.assertNotNull((String)"null output stream returned", (Object)out);
        StringBuffer clearText = new StringBuffer();
        for (int i = 0; i < numberOfSends; ++i) {
            clearText.append(sampleData);
            try {
                out.write(sampleData.toString().getBytes());
                continue;
            }
            catch (IOException ie) {
                SampleEncryptionTransformerTest.fail((String)("unexpected exception thrown, " + ie.toString()));
            }
        }
        try {
            out.flush();
            out.close();
        }
        catch (IOException ie) {
            SampleEncryptionTransformerTest.fail((String)("unexpected exception thrown, " + ie.toString()));
        }
        ByteArrayInputStream compressedStream = new ByteArrayInputStream(compressed.toByteArray());
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        InputStream decompress = transformer.addFilter(compressedStream, "wibble", null, null);
        try {
            int readLen;
            byte[] readBuffer = new byte[509];
            while ((readLen = decompress.read(readBuffer)) > 0) {
                result.write(readBuffer, 0, readLen);
            }
        }
        catch (IOException ie) {
            SampleEncryptionTransformerTest.fail((String)("unexpected exception thrown, " + ie.toString()));
        }
        String resultStr = result.toString();
        SampleEncryptionTransformerTest.assertTrue((clearText.length() > 0 ? 1 : 0) != 0);
        SampleEncryptionTransformerTest.assertTrue((resultStr.length() == clearText.length() ? 1 : 0) != 0);
        SampleEncryptionTransformerTest.assertTrue((boolean)resultStr.toString().equalsIgnoreCase(clearText.toString()));
    }

    public void testWrongPassword() {
        SampleEncryptionTransformer transformer = new SampleEncryptionTransformer();
        transformer.setPassword("Alice");
        transformer.setCipherName("PBEWithMD5AndDES");
        String path = "wibble";
        ByteArrayOutputStream compressed = new ByteArrayOutputStream();
        OutputStream out = null;
        out = transformer.addFilter(compressed, path, null, null);
        SampleEncryptionTransformerTest.assertNotNull((String)"null output stream returned", (Object)compressed);
        String clearText = "hello world";
        try {
            out.write(clearText.getBytes());
        }
        catch (IOException ie) {
            SampleEncryptionTransformerTest.fail((String)("unexpected exception thrown" + ie.toString()));
        }
        try {
            out.flush();
            out.close();
        }
        catch (IOException ie) {
            SampleEncryptionTransformerTest.fail((String)("unexpected exception thrown, " + ie.toString()));
        }
        assert (compressed.size() > 0);
        InputStream decompress = null;
        ByteArrayInputStream compressedStream = new ByteArrayInputStream(compressed.toByteArray());
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        transformer.setPassword("Eve");
        decompress = transformer.addFilter(compressedStream, "wibble", null, null);
        try {
            int readLen;
            byte[] readBuffer = new byte[1002];
            while ((readLen = decompress.read(readBuffer)) > 0) {
                result.write(readBuffer, 0, readLen);
            }
            SampleEncryptionTransformerTest.fail((String)"Decryption should have failed.");
        }
        catch (IOException ie) {
            // empty catch block
        }
    }
}

