/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.crypto.io;

import de.schlichtherle.crypto.io.RaesKeyException;
import de.schlichtherle.crypto.io.RaesParameters;
import de.schlichtherle.crypto.io.RandomAccessEncryptionSpecification;
import java.awt.Container;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JOptionPane;

public abstract class PasswdManager
implements RandomAccessEncryptionSpecification {
    private static final String KEY = "de.schlichtherle.crypto.io.PasswdManager";
    private static PasswdManager passwdManager;
    private static final SortedMap parameters;
    private static boolean prompting;
    private static Window parent;

    public static synchronized PasswdManager getInstance() {
        if (passwdManager == null) {
            passwdManager = PasswdManager.createPasswdManager();
            prompting = !(passwdManager instanceof CancellingPasswdManager);
        }
        return passwdManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PasswdManager createPasswdManager() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String string = System.getProperty(KEY);
            if (string == null) {
                InputStream inputStream = classLoader.getResourceAsStream("META-INF/services/de.schlichtherle.crypto.io.PasswdManager");
                if (inputStream == null) {
                    throw new FileNotFoundException();
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
                try {
                    while ((string = bufferedReader.readLine().trim()).charAt(0) == '#') {
                    }
                }
                finally {
                    bufferedReader.close();
                }
            }
            return (PasswdManager)classLoader.loadClass(string).newInstance();
        }
        catch (Exception exception) {
            return new CancellingPasswdManager();
        }
    }

    public static synchronized boolean isPrompting() {
        if (PasswdManager.getInstance() instanceof CancellingPasswdManager) {
            return false;
        }
        return prompting;
    }

    public static synchronized void setPrompting(boolean bl) {
        prompting = bl;
    }

    public static synchronized Window getParentWindow() {
        Window window;
        for (Container container = window = parent != null ? parent : JOptionPane.getRootFrame(); container != null; container = container.getParent()) {
            if (!(container instanceof Window)) continue;
            window = container;
            if (container.isVisible()) break;
        }
        return window;
    }

    public static synchronized void setParentWindow(Window window) {
        parent = window;
    }

    public static synchronized void resetCancelledPrompts() {
        Iterator iterator = parameters.values().iterator();
        while (iterator.hasNext()) {
            Parameters parameters = (Parameters)iterator.next();
            if (parameters.passwd != null) continue;
            parameters.reset();
            iterator.remove();
        }
    }

    public static synchronized void reset() {
        Iterator iterator = parameters.values().iterator();
        while (iterator.hasNext()) {
            ((Parameters)iterator.next()).reset();
        }
        parameters.clear();
    }

    public static synchronized void reset(String string) {
        Parameters parameters = (Parameters)PasswdManager.parameters.remove(string);
        if (parameters != null) {
            parameters.reset();
        }
    }

    public static synchronized void forceNewPasswd(String string) {
        Parameters parameters = (Parameters)PasswdManager.parameters.get(string);
        if (parameters != null) {
            parameters.promptNewPasswd = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRaesParameters(String string, RaesParameters raesParameters) {
        Class clazz = PasswdManager.class;
        synchronized (clazz) {
            parameters.put(string, raesParameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaesParameters getRaesParameters(String string) {
        Class clazz = PasswdManager.class;
        synchronized (clazz) {
            RaesParameters raesParameters = (RaesParameters)parameters.get(string);
            if (raesParameters == null) {
                raesParameters = this.createNewParameters(string);
                parameters.put(string, raesParameters);
            }
            return raesParameters;
        }
    }

    protected Parameters createNewParameters(String string) {
        return new Parameters(string);
    }

    protected Parameters createNewParameters() {
        return new Parameters();
    }

    public final char[] getPasswd(String string) throws RaesKeyException {
        return this.getRaesParameters(string).getPasswd();
    }

    protected void passwdUnknown(Parameters parameters) {
        this.passwdUnknown(parameters.getResourceId(), parameters);
    }

    protected void passwdUnknown(String string, Parameters parameters) {
    }

    protected void promptParameters(Parameters parameters) {
        this.promptParameters(parameters.getResourceId(), parameters);
    }

    protected void promptParameters(String string, Parameters parameters) {
    }

    protected void passwdWrong(Parameters parameters) {
        this.passwdWrong(parameters.getResourceId(), parameters);
    }

    protected void passwdWrong(String string, Parameters parameters) {
    }

    public final void passwdCorrect(String string, int n) {
        this.getRaesParameters(string).passwdCorrect(n);
    }

    protected void passwdCorrect(Parameters parameters) {
        this.passwdCorrect(parameters.getResourceId(), parameters);
    }

    protected void passwdCorrect(String string, Parameters parameters) {
    }

    public final char[] getNewPasswd(String string) throws RaesKeyException {
        return this.getRaesParameters(string).getNewPasswd();
    }

    public final int getNewKeyStrength(String string) throws RaesKeyException {
        return this.getRaesParameters(string).getNewKeyStrength();
    }

    protected void promptNewParameters(Parameters parameters) {
        this.promptNewParameters(parameters.getResourceId(), parameters);
    }

    protected void promptNewParameters(String string, Parameters parameters) {
    }

    static {
        parameters = new TreeMap();
    }

    protected static class Parameters
    implements RaesParameters {
        private String resourceId;
        public char[] passwd;
        public boolean promptPasswd;
        public boolean promptNewPasswd;
        public int keyStrength;

        public Parameters() {
            this.reset();
        }

        protected Parameters(String string) {
            this.reset();
            this.setResourceId(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Class clazz = class$de$schlichtherle$crypto$io$PasswdManager == null ? (class$de$schlichtherle$crypto$io$PasswdManager = PasswdManager.class$(PasswdManager.KEY)) : class$de$schlichtherle$crypto$io$PasswdManager;
            synchronized (clazz) {
                if (this.passwd != null) {
                    int n = this.passwd.length;
                    while (--n >= 0) {
                        this.passwd[n] = '\u0000';
                    }
                    this.passwd = null;
                }
                this.promptPasswd = true;
                this.promptNewPasswd = true;
                this.keyStrength = 2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void setResourceId(String string) {
            Class clazz = class$de$schlichtherle$crypto$io$PasswdManager == null ? (class$de$schlichtherle$crypto$io$PasswdManager = PasswdManager.class$(PasswdManager.KEY)) : class$de$schlichtherle$crypto$io$PasswdManager;
            synchronized (clazz) {
                if (this.resourceId != null) {
                    throw new IllegalStateException();
                }
                if (string == null) {
                    throw new NullPointerException();
                }
                this.resourceId = string;
            }
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final char[] getPasswd() throws RaesKeyException {
            Class clazz = class$de$schlichtherle$crypto$io$PasswdManager == null ? (class$de$schlichtherle$crypto$io$PasswdManager = PasswdManager.class$(PasswdManager.KEY)) : class$de$schlichtherle$crypto$io$PasswdManager;
            synchronized (clazz) {
                this.checkParameters();
                if (this.passwd != null) {
                    return (char[])this.passwd.clone();
                }
                throw new RaesKeyException();
            }
        }

        private void checkParameters() throws RaesKeyException {
            if (!this.promptPasswd) {
                return;
            }
            if (!PasswdManager.isPrompting()) {
                return;
            }
            PasswdManager passwdManager = PasswdManager.getInstance();
            if (this.passwd != null) {
                passwdManager.passwdWrong(this);
            } else {
                passwdManager.passwdUnknown(this);
            }
            this.passwd = null;
            passwdManager.promptParameters(this);
            this.promptPasswd = this.passwd != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void passwdCorrect(int n) {
            Class clazz = class$de$schlichtherle$crypto$io$PasswdManager == null ? (class$de$schlichtherle$crypto$io$PasswdManager = PasswdManager.class$(PasswdManager.KEY)) : class$de$schlichtherle$crypto$io$PasswdManager;
            synchronized (clazz) {
                this.promptPasswd = false;
                PasswdManager.getInstance().passwdCorrect(this);
            }
        }

        public final char[] getNewPasswd() throws RaesKeyException {
            Class clazz = class$de$schlichtherle$crypto$io$PasswdManager == null ? (class$de$schlichtherle$crypto$io$PasswdManager = PasswdManager.class$(PasswdManager.KEY)) : class$de$schlichtherle$crypto$io$PasswdManager;
            synchronized (clazz) {
                this.checkNewParameters();
                if (this.passwd != null) {
                    return (char[])this.passwd.clone();
                }
                throw new RaesKeyException();
            }
        }

        public final int getNewKeyStrength() throws RaesKeyException {
            Class clazz = class$de$schlichtherle$crypto$io$PasswdManager == null ? (class$de$schlichtherle$crypto$io$PasswdManager = PasswdManager.class$(PasswdManager.KEY)) : class$de$schlichtherle$crypto$io$PasswdManager;
            synchronized (clazz) {
                this.checkNewParameters();
                if (this.passwd != null) {
                    return this.keyStrength;
                }
                throw new RaesKeyException();
            }
        }

        private void checkNewParameters() throws RaesKeyException {
            if (!this.promptNewPasswd) {
                return;
            }
            if (!PasswdManager.isPrompting()) {
                return;
            }
            PasswdManager passwdManager = PasswdManager.getInstance();
            passwdManager.promptNewParameters(this);
            if (this.passwd != null) {
                this.promptNewPasswd = false;
                this.promptPasswd = false;
            }
        }
    }

    private static class CancellingPasswdManager
    extends PasswdManager {
        private CancellingPasswdManager() {
        }

        protected void promptParameters(String string, Parameters parameters) {
        }

        protected void promptNewParameters(String string, Parameters parameters) {
        }
    }
}

