/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.crypto.io.swing;

import de.schlichtherle.crypto.io.RandomAccessEncryptionSpecification;
import de.schlichtherle.crypto.io.swing.PasswdOrFilePanel;
import de.schlichtherle.crypto.io.swing.SwingPasswdManager;
import de.schlichtherle.crypto.io.swing.WeakPasswdException;
import de.schlichtherle.swing.EnhancedPanel;
import de.schlichtherle.swing.event.PanelEvent;
import de.schlichtherle.swing.event.PanelListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.zip.Deflater;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class NewPasswdPanel
extends EnhancedPanel
implements RandomAccessEncryptionSpecification {
    private final ResourceBundle resources = ResourceBundle.getBundle("de/schlichtherle/crypto/io/swing/NewPasswdPanel");
    private final Color defaultForeground;
    private static int MIN_PASSWD_LEN;
    private JLabel error;
    private JComboBox keyStrength;
    private JLabel keyStrengthLong;
    private JLabel keyStrengthShort;
    private JPasswordField newPasswd1;
    private JPasswordField newPasswd2;
    private JLabel newPasswdLong;
    private EnhancedPanel newPasswdPanel;
    private JLabel newPasswdShort1;
    private JLabel newPasswdShort2;
    private PasswdOrFilePanel passwdOrFilePanel;
    private static JTextPane pathname;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NewPasswdPanel() {
        this.initComponents();
        this.defaultForeground = pathname.getForeground();
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                NewPasswdPanel.this.setError(null);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                NewPasswdPanel.this.setError(null);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                NewPasswdPanel.this.setError(null);
            }
        };
        this.newPasswd1.getDocument().addDocumentListener(documentListener);
        this.newPasswd2.getDocument().addDocumentListener(documentListener);
        this.passwdOrFilePanel.pathname.getDocument().addDocumentListener(documentListener);
        this.keyStrength.setModel(new DefaultComboBoxModel<String>(new String[]{this.resources.getString("keyStrength.medium"), this.resources.getString("keyStrength.high"), this.resources.getString("keyStrength.ultra")}));
        this.keyStrength.setSelectedIndex(2);
    }

    private void initComponents() {
        this.newPasswdPanel = new EnhancedPanel();
        this.newPasswdShort1 = new JLabel();
        this.newPasswd1 = new JPasswordField();
        this.newPasswdShort2 = new JLabel();
        this.newPasswd2 = new JPasswordField();
        this.newPasswdLong = new JLabel();
        pathname = new JTextPane();
        this.passwdOrFilePanel = new PasswdOrFilePanel();
        this.keyStrengthLong = new JLabel();
        this.keyStrength = new JComboBox();
        this.keyStrengthShort = new JLabel();
        this.error = new JLabel();
        this.newPasswdPanel.setLayout(new GridBagLayout());
        this.newPasswdPanel.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                NewPasswdPanel.this.newPasswdPanelComponentShown(componentEvent);
            }
        });
        this.newPasswdPanel.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent panelEvent) {
                NewPasswdPanel.this.newPasswdPanelAncestorWindowShown(panelEvent);
            }

            public void ancestorWindowHidden(PanelEvent panelEvent) {
            }
        });
        this.newPasswdShort1.setLabelFor(this.newPasswd1);
        this.newPasswdShort1.setText(this.resources.getString("newPasswdShort1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.newPasswdPanel.add((Component)this.newPasswdShort1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.newPasswdPanel.add((Component)this.newPasswd1, gridBagConstraints);
        this.newPasswdShort2.setLabelFor(this.newPasswd2);
        this.newPasswdShort2.setText(this.resources.getString("newPasswdShort2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.newPasswdPanel.add((Component)this.newPasswdShort2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.newPasswdPanel.add((Component)this.newPasswd2, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        this.newPasswdLong.setLabelFor(pathname);
        this.newPasswdLong.setText(this.resources.getString("newPasswdLong"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.newPasswdLong, gridBagConstraints);
        pathname.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        pathname.setEditable(false);
        pathname.setFont(this.getBoldFont());
        pathname.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)pathname, gridBagConstraints);
        this.passwdOrFilePanel.setPasswdPanel(this.newPasswdPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.passwdOrFilePanel, gridBagConstraints);
        this.keyStrengthLong.setLabelFor(this.keyStrength);
        this.keyStrengthLong.setText(this.resources.getString("keyStrengthLong"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.keyStrengthLong, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.keyStrength, gridBagConstraints);
        this.keyStrengthShort.setLabelFor(this.keyStrength);
        this.keyStrengthShort.setText(this.resources.getString("keyStrengthShort"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.add((Component)this.keyStrengthShort, gridBagConstraints);
        this.error.setForeground(Color.red);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.error, gridBagConstraints);
    }

    private void newPasswdPanelAncestorWindowShown(PanelEvent panelEvent) {
        this.newPasswd1.requestFocusInWindow();
        this.newPasswd1.selectAll();
    }

    private void newPasswdPanelComponentShown(ComponentEvent componentEvent) {
        this.newPasswdPanelAncestorWindowShown(null);
    }

    private Font getBoldFont() {
        Font font = pathname.getFont();
        return new Font(font.getName(), 1, font.getSize());
    }

    public String getPathname() {
        return pathname.getText();
    }

    public void setPathname(String string) {
        String string2 = SwingPasswdManager.lastPathname;
        if (string2 == null) {
            string2 = "";
        }
        if (!"".equals(string2) && !string2.equals(string)) {
            pathname.setForeground(Color.RED);
        } else {
            pathname.setForeground(this.defaultForeground);
        }
        pathname.setText(string);
    }

    public char[] getNewPasswd() {
        try {
            char[] cArray;
            if (this.passwdOrFilePanel.useKeyFile.isSelected()) {
                int n;
                byte[] byArray = new byte[512];
                try {
                    Document document = this.passwdOrFilePanel.pathname.getDocument();
                    n = PasswdOrFilePanel.readKey(document.getText(0, document.getLength()), byArray);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.setError(this.resources.getString("keyFile.fileNotFoundException"));
                    return null;
                }
                catch (IOException iOException) {
                    this.setError(this.resources.getString("keyFile.ioException"));
                    return null;
                }
                if (n != 512) {
                    this.setError(this.resources.getString("keyFile.tooShort"));
                    return null;
                }
                this.checkNewKey(byArray);
                return PasswdOrFilePanel.PKCS12BytesToChars(byArray, 0, n);
            }
            char[] cArray2 = this.newPasswd1.getPassword();
            if (Arrays.equals(cArray2, cArray = this.newPasswd2.getPassword())) {
                SwingPasswdManager.nullify(cArray);
                this.checkNewPasswd(cArray2);
                return cArray2;
            }
            this.setError(this.resources.getString("passwdNoMatch"));
            return null;
        }
        catch (BadLocationException badLocationException) {
            throw new AssertionError((Object)badLocationException);
        }
        catch (WeakPasswdException weakPasswdException) {
            this.setError(weakPasswdException.getLocalizedMessage());
            return null;
        }
    }

    public void resetNewPasswd() {
        this.newPasswd1.setText(null);
        this.newPasswd2.setText(null);
    }

    protected void checkNewKey(byte[] byArray) throws WeakPasswdException {
        Deflater deflater = new Deflater();
        deflater.setInput(byArray);
        deflater.finish();
        if (!$assertionsDisabled && deflater.getTotalOut() != 0) {
            throw new AssertionError();
        }
        int n = deflater.deflate(new byte[byArray.length * 2]);
        if (!$assertionsDisabled && deflater.getTotalOut() != n) {
            throw new AssertionError();
        }
        deflater.end();
        if (n < 64) {
            throw new WeakPasswdException(this.resources, "keyFile.badEntropy");
        }
    }

    protected void checkNewPasswd(char[] cArray) throws WeakPasswdException {
        if (cArray.length < MIN_PASSWD_LEN) {
            throw new WeakPasswdException(this.resources, "passwd.tooShort", new Integer(MIN_PASSWD_LEN));
        }
    }

    public int getKeyStrength() {
        return this.keyStrength.getSelectedIndex();
    }

    public void setKeyStrength(int n) {
        this.keyStrength.setSelectedIndex(n);
    }

    public void setError(String string) {
        this.error.setText(string);
    }

    static {
        $assertionsDisabled = !NewPasswdPanel.class.desiredAssertionStatus();
        MIN_PASSWD_LEN = 6;
    }
}

