/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.crypto.io.PasswdManager;
import de.schlichtherle.crypto.io.RaesOutputStream;
import de.schlichtherle.crypto.io.RaesParameters;
import de.schlichtherle.crypto.io.RaesReadOnlyFile;
import de.schlichtherle.io.File;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import de.schlichtherle.io.ZipDetector;
import de.schlichtherle.io.ZipEntry;
import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.util.zip.ZipFile;
import de.schlichtherle.util.zip.ZipOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class DefaultRaesZipDetector
implements ZipDetector {
    private static final String SFX_ENCODING = System.getProperty("file.encoding");
    protected static final int AUTHENTICATION_TRIGGER = 524288;
    protected Matcher zipMatcher;
    protected Matcher jarMatcher;
    protected Matcher raesMatcher;
    protected Matcher sfxMatcher;

    public DefaultRaesZipDetector(String string) throws PatternSyntaxException {
        this(string, "ear|jar|war|tzp|zip.rae", "tzp|zip.rae", "exe");
    }

    public DefaultRaesZipDetector(String string, String string2, String string3) throws PatternSyntaxException {
        this(string, string2, string3, "exe");
    }

    public DefaultRaesZipDetector(String string, String string2, String string3, String string4) throws PatternSyntaxException {
        this.zipMatcher = Pattern.compile(DefaultRaesZipDetector.fix(string), 66).matcher("");
        this.jarMatcher = Pattern.compile(DefaultRaesZipDetector.fix(string2), 66).matcher("");
        this.raesMatcher = Pattern.compile(DefaultRaesZipDetector.fix(string3), 66).matcher("");
        this.sfxMatcher = Pattern.compile(DefaultRaesZipDetector.fix(string4), 66).matcher("");
    }

    private static String fix(String string) {
        if (string == null) {
            return "\\00";
        }
        StringBuffer stringBuffer = new StringBuffer(".*\\.(");
        String[] stringArray = string.split("\\|");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].replaceAll("\\\\\\.", "\\.");
            if (string2.length() <= 0) continue;
            if (string2.charAt(0) == '.') {
                string2 = string2.substring(1);
            }
            if (i > 0) {
                stringBuffer.append('|');
            }
            stringBuffer.append("\\Q");
            stringBuffer.append(string2);
            stringBuffer.append("\\E");
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isZipFile(String string) {
        Matcher matcher = this.zipMatcher;
        synchronized (matcher) {
            this.zipMatcher.reset(string);
            return this.zipMatcher.matches();
        }
    }

    public ZipFile createZipFile(final String string, ReadOnlyFile readOnlyFile) throws IOException {
        if (this.isRaesFile(string)) {
            RaesReadOnlyFile raesReadOnlyFile = new RaesReadOnlyFile(readOnlyFile, this.getRaesParameters(string));
            if (raesReadOnlyFile.length() < 524288L) {
                raesReadOnlyFile.authenticate();
            }
            readOnlyFile = raesReadOnlyFile;
        }
        return new ZipFile(readOnlyFile, this.getEncoding(string), this.getPreambled(string), this.getPostambled(string)){

            protected de.schlichtherle.util.zip.ZipEntry createZipEntry(String string2) {
                return DefaultRaesZipDetector.this.createZipEntry(string, true, string2);
            }
        };
    }

    public ZipOutputStream createZipOutputStream(String string, OutputStream outputStream) throws IOException {
        String string2 = this.getEncoding(string);
        if (this.isRaesFile(string)) {
            RaesOutputStream raesOutputStream = new RaesOutputStream(outputStream);
            raesOutputStream.init(true, this.getRaesParameters(string));
            return new ZipOutputStream(raesOutputStream, string2);
        }
        return new ZipOutputStream(outputStream, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEncoding(String string) {
        Matcher matcher = this.jarMatcher;
        synchronized (matcher) {
            this.jarMatcher.reset(string);
            if (this.jarMatcher.matches()) {
                return "UTF-8";
            }
        }
        matcher = this.sfxMatcher;
        synchronized (matcher) {
            this.sfxMatcher.reset(string);
            return this.sfxMatcher.matches() ? SFX_ENCODING : "CP437";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getPreambled(String string) {
        Matcher matcher = this.sfxMatcher;
        synchronized (matcher) {
            this.sfxMatcher.reset(string);
            return this.sfxMatcher.matches();
        }
    }

    protected boolean getPostambled(String string) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRaesFile(String string) {
        Matcher matcher = this.raesMatcher;
        synchronized (matcher) {
            this.raesMatcher.reset(string);
            return this.raesMatcher.matches();
        }
    }

    protected RaesParameters getRaesParameters(String string) {
        return PasswdManager.getInstance().getRaesParameters(string);
    }

    public ZipEntry createZipEntry(String string, boolean bl, String string2) {
        return new ZipEntry(string2);
    }

    public File createFile(String string) {
        return new File(string, (ZipDetector)this);
    }

    public File createFile(String string, String string2) {
        return new File(string, string2, (ZipDetector)this);
    }

    public File createFile(java.io.File file, String string) {
        return new File(file, string, (ZipDetector)this);
    }

    public File createFile(URI uRI) {
        return new File(uRI);
    }

    public File createFile(java.io.File file) {
        return new File(file, (ZipDetector)this);
    }

    public File createFile(java.io.File file, File file2) {
        return new File(file, file2, (ZipDetector)this);
    }

    public File createFile(java.io.File file, File file2, File file3) {
        return new File(file, file2, file3);
    }

    public FileInputStream createFileInputStream(java.io.File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    public FileOutputStream createFileOutputStream(java.io.File file, boolean bl) throws FileNotFoundException {
        return new FileOutputStream(file, bl);
    }

    static {
        Logger.getLogger("de.schlichtherle.io.DefaultRaesZipDetector", "de.schlichtherle.io.DefaultRaesZipDetector").log(Level.CONFIG, "sfx.encoding", SFX_ENCODING);
    }
}

