/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.DefaultRaesZipDetector;
import de.schlichtherle.io.FileBusyException;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import de.schlichtherle.io.InputIOException;
import de.schlichtherle.io.ZipBusyException;
import de.schlichtherle.io.ZipController;
import de.schlichtherle.io.ZipControllerException;
import de.schlichtherle.io.ZipDetector;
import de.schlichtherle.io.ZipEntry;
import de.schlichtherle.io.ZipFileSystem;
import de.schlichtherle.io.ZipFileSystemException;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class File
extends java.io.File
implements Cloneable {
    private static ZipDetector defaultZipDetector;
    private static boolean lenient;
    static final String EMPTY = "";
    final java.io.File delegate;
    private ZipDetector zipDetector;
    private File innerZipFile;
    private String innerZipEntryName;
    private File enclZipFile;
    private String enclZipEntryName;
    ZipController zipController;
    private static final HashSet roots;
    private static final String uncPrefix;
    private static final List buffersList;
    static final /* synthetic */ boolean $assertionsDisabled;

    static java.io.File normalize(java.io.File file) {
        String string = file.getPath();
        String string2 = File.normalize(string, separatorChar);
        if (string2 != string) {
            return new java.io.File(string2);
        }
        return file;
    }

    static String normalize(String string, char c) {
        String[] stringArray = File.splitPathName(string, c);
        String string2 = stringArray[0];
        if (string2 == null) {
            return string;
        }
        String string3 = File.normalize(string2, c);
        String string4 = stringArray[1];
        if (".".equals(string3)) {
            return string4;
        }
        if (".".equals(string4)) {
            return string3;
        }
        if ("..".equals(string4)) {
            String[] stringArray2 = File.splitPathName(string3, c);
            String string5 = stringArray2[1];
            if (EMPTY.equals(string5)) {
                return string3;
            }
            if (".".equals(string5)) {
                if (!$assertionsDisabled && !".".equals(string3)) {
                    throw new AssertionError();
                }
                return "..";
            }
            if (!"..".equals(string5)) {
                String string6 = stringArray2[0];
                if (string6 != null) {
                    return string6;
                }
                return ".";
            }
        }
        if (string3 != string2) {
            if (!$assertionsDisabled && EMPTY.equals(string3)) {
                throw new AssertionError();
            }
            return string3 + c + string4;
        }
        return string;
    }

    static String[] splitPathName(String string, char c) {
        int n;
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        int n2 = 0;
        if (c == '\\' && string.length() >= 2) {
            if (string.charAt(1) == ':') {
                n = string.charAt(0);
                if (65 <= n && n <= 90 || 97 <= n && n <= 122) {
                    n2 = 2;
                }
            } else if (string.startsWith("\\\\")) {
                n2 = 1;
            }
        }
        n = string.length();
        if (--n >= 0 && n2 <= n && string.charAt(n) == c) {
            --n;
        }
        int n3 = string.lastIndexOf(c, n);
        ++n;
        String[] stringArray = new String[2];
        if (n3 != -1 && n3 >= n2) {
            stringArray[0] = n3 > n2 ? string.substring(0, n3) : string.substring(0, n3 + 1);
            stringArray[1] = string.substring(n3 + 1, n);
        } else {
            stringArray[0] = 0 < n2 && n2 < n ? string.substring(0, n2) : null;
            stringArray[1] = string.substring(n2, n);
        }
        return stringArray;
    }

    static final String catEntryName(ZipController zipController, String string) {
        return EMPTY != string ? zipController.enclEntryName + "/" + string : zipController.enclEntryName;
    }

    public static final void update() throws ZipControllerException {
        ZipController.updateAll(true, false, true);
    }

    public static final void update(boolean bl) throws ZipControllerException {
        ZipController.updateAll(bl, false, true);
    }

    public static final void umount() throws ZipControllerException {
        ZipController.updateAll(true, true, true);
    }

    public static final void umount(boolean bl) throws ZipControllerException {
        ZipController.updateAll(bl, true, true);
    }

    public static final long getZipSyncTotalByteCountRead() {
        return ZipController.CountingInputStream.getTotal();
    }

    public static final long getZipSyncTotalByteCountWritten() {
        return ZipController.CountingOutputStream.getTotal();
    }

    public static final boolean isLenient() {
        return lenient;
    }

    public static final void setLenient(boolean bl) {
        lenient = bl;
    }

    public static final ZipDetector getDefaultZipDetector() {
        return defaultZipDetector;
    }

    public static final void setDefaultZipDetector(ZipDetector zipDetector) {
        if (zipDetector == null) {
            throw new NullPointerException();
        }
        defaultZipDetector = zipDetector;
    }

    public File(String string) {
        this(string, defaultZipDetector);
    }

    public File(String string, ZipDetector zipDetector) {
        super(string);
        this.delegate = new java.io.File(string);
        this.zipDetector = zipDetector;
        this.init((File)null);
        if (!$assertionsDisabled && !this.assertInvariants(true)) {
            throw new AssertionError();
        }
    }

    public File(String string, String string2) {
        this(string, string2, defaultZipDetector);
    }

    public File(String string, String string2, ZipDetector zipDetector) {
        super(string, string2);
        this.delegate = new java.io.File(string, string2);
        this.zipDetector = zipDetector;
        this.init((File)null);
        if (!$assertionsDisabled && !this.assertInvariants(true)) {
            throw new AssertionError();
        }
    }

    public File(java.io.File file, String string) {
        this(file, string, defaultZipDetector);
    }

    public File(java.io.File file, String string, ZipDetector zipDetector) {
        super(file, string);
        this.delegate = new java.io.File(file, string);
        this.zipDetector = zipDetector;
        if (file instanceof File && string.length() > 0) {
            this.init((File)file);
        } else {
            this.init((File)null);
        }
        if (!$assertionsDisabled && !this.assertInvariants(true)) {
            throw new AssertionError();
        }
    }

    public File(URI uRI) {
        this(uRI, ZipDetector.ALL);
    }

    public File(URI uRI, ZipDetector zipDetector) {
        super(File.unjarFileURI(uRI));
        this.delegate = new java.io.File(super.getPath());
        this.zipDetector = zipDetector;
        this.init(uRI);
        if (!$assertionsDisabled && !this.assertInvariants(true)) {
            throw new AssertionError();
        }
    }

    private static final URI unjarFileURI(URI uRI) {
        try {
            String string = uRI.getScheme();
            String string2 = File.normalize(uRI.getSchemeSpecificPart(), '/');
            return File._unjarFileURI(new URI(string, string2, null));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRI + ": Not a valid (possibly jared) file URI!");
        }
    }

    private static final URI _unjarFileURI(URI uRI) throws URISyntaxException {
        String string = uRI.getScheme();
        if ("jar".equalsIgnoreCase(string)) {
            String string2 = uRI.getRawSchemeSpecificPart();
            int n = string2.endsWith("!") ? string2.length() - 1 : string2.lastIndexOf("!/");
            if (n <= 0) {
                return File.unjarFileURI(new URI(string2));
            }
            URI uRI2 = new URI(string2.substring(0, n) + string2.substring(n + 1));
            String string3 = uRI2.getScheme();
            if ("jar".equalsIgnoreCase(string3)) {
                URI uRI3 = File._unjarFileURI(uRI2);
                if (uRI3 != uRI2) {
                    return uRI3;
                }
            } else if ("file".equalsIgnoreCase(string3)) {
                return uRI2;
            }
        } else if ("file".equalsIgnoreCase(string)) {
            return uRI;
        }
        throw new URISyntaxException(uRI.toString(), "Not a valid (possibly jared) file URI!");
    }

    public File(java.io.File file) {
        this(file, defaultZipDetector);
    }

    public File(java.io.File file, ZipDetector zipDetector) {
        super(file.getPath());
        this.zipDetector = zipDetector;
        if (file instanceof File) {
            File file2 = (File)file;
            this.delegate = file2.delegate;
            this.enclZipFile = file2.enclZipFile;
            this.enclZipEntryName = file2.enclZipEntryName;
            this.innerZipFile = file2.isZipFile() ? this : file2.innerZipFile;
            this.innerZipEntryName = file2.innerZipEntryName;
            this.zipController = file2.zipController;
        } else {
            this.delegate = file;
            this.init((File)null);
        }
        if (!$assertionsDisabled && !this.assertInvariants(true)) {
            throw new AssertionError();
        }
    }

    public File(java.io.File file, File file2, ZipDetector zipDetector) {
        super(file.getPath());
        if (!$assertionsDisabled && !File.assertParams(file, file2, zipDetector)) {
            throw new AssertionError();
        }
        this.delegate = file;
        String string = file.getPath();
        if (file2 != null) {
            int n = file2.getPath().length();
            if (string.length() == n) {
                this.zipDetector = file2.zipDetector;
                this.innerZipFile = this;
                this.innerZipEntryName = EMPTY;
                this.enclZipFile = file2.enclZipFile;
                this.enclZipEntryName = file2.enclZipEntryName;
                this.zipController = ZipController.getInstance(this);
            } else {
                this.zipDetector = zipDetector;
                this.innerZipFile = this.enclZipFile = file2;
                this.innerZipEntryName = this.enclZipEntryName = string.substring(n + 1).replace(separatorChar, '/');
            }
        } else {
            this.zipDetector = zipDetector;
        }
        if (!$assertionsDisabled && !this.assertInvariants(true)) {
            throw new AssertionError();
        }
    }

    private static final boolean assertParams(java.io.File file, File file2, ZipDetector zipDetector) throws AssertionError {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError((Object)"delegate is null!");
        }
        if (!$assertionsDisabled && file instanceof File) {
            throw new AssertionError((Object)"delegate must not be a de.schlichtherle.io.File!");
        }
        if (file2 != null) {
            if (!$assertionsDisabled && !file2.isZipFile()) {
                throw new AssertionError((Object)"innerZipFile must be a ZIP compatible file!");
            }
            if (!$assertionsDisabled && !File._contains(file2, file)) {
                throw new AssertionError((Object)"innerZipFile must contain delegate!");
            }
        }
        if (!$assertionsDisabled && zipDetector == null) {
            throw new AssertionError((Object)"zipDetector is null!");
        }
        return true;
    }

    public File(java.io.File file, File file2, File file3) {
        super(file.getPath());
        if (!$assertionsDisabled && !File.assertParams(file, file2, file3)) {
            throw new AssertionError();
        }
        this.delegate = file;
        this.zipDetector = file2.zipDetector;
        this.enclZipFile = file3;
        this.enclZipEntryName = file2.enclZipEntryName;
        this.innerZipFile = file2.isZipFile() ? this : file3;
        this.innerZipEntryName = file2.innerZipEntryName;
        this.zipController = file2.zipController;
        if (!$assertionsDisabled && !this.assertInvariants(file2.zipController != null)) {
            throw new AssertionError();
        }
    }

    private static final boolean assertParams(java.io.File file, File file2, File file3) throws AssertionError {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError((Object)"delegate is null!");
        }
        if (!$assertionsDisabled && file instanceof File) {
            throw new AssertionError((Object)"delegate must not be a de.schlichtherle.io.File!");
        }
        if (!$assertionsDisabled && file2 == null) {
            throw new AssertionError((Object)"blueprint is null!");
        }
        String string = file.getPath();
        java.io.File file4 = File.normalize(file2);
        String string2 = file4.getPath();
        String string3 = file4.getName();
        if (separatorChar != '/') {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
            string3 = string3.toLowerCase();
        }
        if (!(".".equals(string3) || "..".equals(string3) || string2.startsWith("." + separator) || string2.startsWith(".." + separator))) {
            if (!$assertionsDisabled && !string.endsWith(string2)) {
                throw new AssertionError((Object)"delegate and blueprint must identify the same directory!");
            }
            if (file3 != null) {
                if (!$assertionsDisabled && !file3.isZipFile()) {
                    throw new AssertionError((Object)"enclZipFile must be a ZIP compatible file!");
                }
                if (!$assertionsDisabled && !File._contains(file3, file.getParentFile())) {
                    throw new AssertionError((Object)"enclZipFile must be an ancestor of delegate!");
                }
            }
        }
        return true;
    }

    private void init(File file) {
        if (!$assertionsDisabled && file != null && !super.getPath().startsWith(file.getPath())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.delegate.getPath().equals(super.getPath())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.zipDetector == null) {
            throw new AssertionError();
        }
        this.init(this.zipDetector, file, 0, super.getPath());
        if (this.innerZipFile == this) {
            this.zipController = ZipController.getInstance(this);
        }
    }

    private void init(ZipDetector zipDetector, File file, int n, String string) {
        if (string == null) {
            if (!$assertionsDisabled && this.enclZipFile != null) {
                throw new AssertionError();
            }
            this.enclZipEntryName = null;
            return;
        }
        String[] stringArray = File.splitPathName(string, separatorChar);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        if (!".".equals(string3)) {
            if ("..".equals(string3)) {
                ++n;
            } else if (n > 0) {
                --n;
            } else {
                boolean bl;
                if (file != null) {
                    int n2;
                    int n3 = string.length();
                    if (n3 <= (n2 = file.getPath().length())) {
                        zipDetector = file.zipDetector;
                        bl = n3 == n2 ? file.isZipFile() : zipDetector.isZipFile(string);
                        file = file.enclZipFile;
                    } else {
                        bl = zipDetector.isZipFile(string);
                    }
                } else {
                    bl = zipDetector.isZipFile(string);
                }
                if (this.enclZipEntryName != null) {
                    if (bl) {
                        this.enclZipFile = zipDetector.createFile(string);
                        if (this.innerZipFile != this) {
                            this.innerZipFile = this.enclZipFile;
                            this.innerZipEntryName = this.enclZipEntryName;
                        }
                        return;
                    }
                    this.enclZipEntryName = string3 + "/" + this.enclZipEntryName;
                } else {
                    if (bl) {
                        this.innerZipFile = this;
                        this.innerZipEntryName = EMPTY;
                    }
                    this.enclZipEntryName = string3;
                }
            }
        }
        this.init(zipDetector, file, n, string2);
    }

    private void init(URI uRI) {
        if (!$assertionsDisabled && uRI == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.delegate.getPath().equals(super.getPath())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.zipDetector == null) {
            throw new AssertionError();
        }
        this.init(0, uRI, this.fix(uRI.getSchemeSpecificPart(), '/'));
        if (this.innerZipFile == this) {
            this.zipController = ZipController.getInstance(this);
        }
    }

    private final String fix(String string, char c) {
        int n = string.length() - 1;
        if (n >= 0 && string.charAt(n) == c) {
            return string.substring(0, n);
        }
        return string;
    }

    private void init(int n, URI uRI, String string) {
        String string2 = uRI.getScheme();
        if (string == null || !"jar".equalsIgnoreCase(string2)) {
            if (!$assertionsDisabled && this.enclZipFile != null) {
                throw new AssertionError();
            }
            this.enclZipEntryName = null;
            return;
        }
        String[] stringArray = File.splitPathName(string, '/');
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        if (!".".equals(string4)) {
            if ("..".equals(string4)) {
                ++n;
            } else if (n > 0) {
                --n;
            } else {
                boolean bl;
                int n2 = string4.length() - 1;
                boolean bl2 = bl = string4.charAt(n2) == '!';
                if (this.enclZipEntryName != null) {
                    if (bl) {
                        this.enclZipFile = this.zipDetector.createFile(this.createURI(string2, string));
                        if (this.innerZipFile != this) {
                            this.innerZipFile = this.enclZipFile;
                            this.innerZipEntryName = this.enclZipEntryName;
                        }
                        return;
                    }
                    this.enclZipEntryName = string4 + "/" + this.enclZipEntryName;
                } else if (bl) {
                    this.innerZipFile = this;
                    this.innerZipEntryName = EMPTY;
                    int n3 = string3.indexOf(58);
                    if (!$assertionsDisabled && n3 < 0) {
                        throw new AssertionError();
                    }
                    string2 = string3.substring(0, n3);
                    if (!$assertionsDisabled && !string2.matches("[a-zA-Z]+")) {
                        throw new AssertionError();
                    }
                    if (n3 == string3.length() - 1) {
                        return;
                    }
                    uRI = this.createURI(string3.substring(0, n3), string3.substring(n3 + 1));
                    this.enclZipEntryName = string4.substring(0, n2);
                    string3 = uRI.getSchemeSpecificPart();
                } else {
                    this.enclZipEntryName = string4;
                }
            }
        }
        this.init(n, uRI, string3);
    }

    private URI createURI(String string, String string2) throws IllegalArgumentException {
        try {
            return new URI(string, string2, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            illegalArgumentException.initCause(uRISyntaxException);
            throw illegalArgumentException;
        }
    }

    private boolean assertInvariants(boolean bl) throws AssertionError {
        if (!$assertionsDisabled && this.delegate == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.delegate instanceof File) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.delegate.getPath().equals(super.getPath())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.zipDetector == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.innerZipFile != null != (this.innerZipEntryName != null)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.enclZipFile != null != (this.enclZipEntryName != null)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((this.innerZipFile == this && this.innerZipFile != this.enclZipFile && this.innerZipEntryName == EMPTY && this.innerZipEntryName != this.enclZipEntryName && (bl ? this.zipController != null : this.zipController == null)) ^ (this.innerZipFile == this.enclZipFile && this.innerZipEntryName == this.enclZipEntryName && this.zipController == null))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.enclZipFile != null && (!File._contains(this.enclZipFile, this.delegate.getParentFile()) || this.enclZipEntryName.length() <= 0 || separatorChar != '/' && this.enclZipEntryName.indexOf(separatorChar) != -1)) {
            throw new AssertionError();
        }
        return true;
    }

    public Object clone() {
        return this.zipDetector.createFile(this);
    }

    public java.io.File getParentFile() {
        java.io.File file = this.delegate.getParentFile();
        if (file == null) {
            return null;
        }
        if (!$assertionsDisabled && !super.getName().equals(this.delegate.getName())) {
            throw new AssertionError();
        }
        if (this.enclZipFile != null && this.enclZipFile.getPath().length() == file.getPath().length()) {
            if (!$assertionsDisabled && !this.enclZipFile.getPath().equals(file.getPath())) {
                throw new AssertionError();
            }
            return this.enclZipFile;
        }
        return this.zipDetector.createFile(file, this.enclZipFile);
    }

    public File getNonZippedParentFile() {
        File file = this.enclZipFile;
        return file != null ? file.getNonZippedParentFile() : (File)this.getParentFile();
    }

    public java.io.File getAbsoluteFile() {
        File file = this.enclZipFile;
        if (file != null) {
            file = (File)file.getAbsoluteFile();
        }
        return this.zipDetector.createFile(this.delegate.getAbsoluteFile(), this, file);
    }

    public final java.io.File getAbsoluteUndotifiedFile() {
        return this.getNormalizedAbsoluteFile();
    }

    public File getNormalizedAbsoluteFile() {
        File file = this.enclZipFile;
        if (file != null) {
            file = file.getNormalizedAbsoluteFile();
        }
        return this.zipDetector.createFile(File.normalize(this.delegate.getAbsoluteFile()), this, file);
    }

    public File getNormalizedFile() {
        java.io.File file = File.normalize(this);
        if (file == this) {
            return this;
        }
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && file instanceof File) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && File.normalize(this.enclZipFile) != this.enclZipFile) {
            throw new AssertionError();
        }
        return this.zipDetector.createFile(file, this, this.enclZipFile);
    }

    public java.io.File getCanonicalFile() throws IOException {
        File file = this.enclZipFile;
        if (file != null) {
            file = (File)file.getCanonicalFile();
        }
        return this.zipDetector.createFile(this.delegate.getCanonicalFile(), this, file);
    }

    public final File getCanOrAbsFile() {
        File file = this.enclZipFile;
        if (file != null) {
            file = file.getCanOrAbsFile();
        }
        return this.zipDetector.createFile(File.getCanOrAbsFile(this.delegate), this, file);
    }

    private static java.io.File getCanOrAbsFile(java.io.File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            java.io.File file2 = file.getParentFile();
            return File.normalize(file2 != null ? new java.io.File(File.getCanOrAbsFile(file2), file.getName()) : file.getAbsoluteFile());
        }
    }

    public final boolean isZipFile() {
        return this.innerZipFile == this;
    }

    public final boolean isZipEntry() {
        return this.enclZipEntryName != null;
    }

    public final File getInnerZipFile() {
        return this.innerZipFile;
    }

    public final String getInnerZipEntryName() {
        return this.innerZipEntryName;
    }

    public final File getEnclZipFile() {
        return this.enclZipFile;
    }

    public final String getEnclZipEntryName() {
        return this.enclZipEntryName;
    }

    public final ZipDetector getZipDetector() {
        if (!$assertionsDisabled && this.zipDetector == null) {
            throw new AssertionError();
        }
        return this.zipDetector;
    }

    public final java.io.File getDelegate() {
        if (!$assertionsDisabled && this.delegate == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.delegate instanceof File) {
            throw new AssertionError();
        }
        return this.delegate;
    }

    final ZipController getZipController() {
        return this.zipController;
    }

    public boolean isParentOf(java.io.File file) {
        File file2 = this.getCanOrAbsFile();
        try {
            return File._contains(file2, file.getCanonicalFile().getParentFile());
        }
        catch (IOException iOException) {
            return File._contains(file2, File.normalize(file.getAbsoluteFile()).getParentFile());
        }
    }

    public boolean contains(java.io.File file) {
        return File.contains(this, file);
    }

    public static boolean contains(java.io.File file, java.io.File file2) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            file = File.normalize(file.getAbsoluteFile());
        }
        try {
            file2 = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            file2 = File.normalize(file2.getAbsoluteFile());
        }
        return File._contains(file, file2);
    }

    private static boolean _contains(java.io.File file, java.io.File file2) {
        int n;
        if (file2 == null) {
            return false;
        }
        String string = file.getPath();
        String string2 = file2.getPath();
        if (separatorChar != '/') {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        if (!string2.startsWith(string)) {
            return false;
        }
        int n2 = string.length();
        if (n2 == (n = string2.length())) {
            return true;
        }
        if (n2 < n) {
            return string2.charAt(n2) == separatorChar;
        }
        return false;
    }

    public boolean isFileSystemRoot() {
        File file = this.getCanOrAbsFile();
        return roots.contains(file) || File.isUNC(file.getPath());
    }

    public boolean isUNC() {
        return File.isUNC(this.getCanOrAbsFile().getPath());
    }

    protected static final boolean isUNC(String string) {
        return string.startsWith(uncPrefix) && string.indexOf(separatorChar, 2) > 2;
    }

    public int hashCode() {
        File file = this.enclZipFile;
        if (file != null) {
            return file.hashCode() + this.enclZipEntryName.hashCode();
        }
        return this.delegate.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof File) {
            return this.compareTo((File)object) == 0;
        }
        return super.equals(object);
    }

    public int compareTo(java.io.File file) {
        File file2;
        if (this == file) {
            return 0;
        }
        if (!(file instanceof File)) {
            return super.compareTo(file);
        }
        File file3 = (File)file;
        File file4 = this.enclZipFile;
        if (file4 != null && (file2 = file3.enclZipFile) != null) {
            int n = file4.compareTo(file2);
            if (n == 0) {
                n = this.enclZipEntryName.compareTo(file3.enclZipEntryName);
            }
            return n;
        }
        return super.compareTo(file);
    }

    public File getLeftmostZipFile() {
        File file = this.enclZipFile;
        return file != null ? file.getLeftmostZipFile() : this.innerZipFile;
    }

    public String getAbsolutePath() {
        return this.delegate.getAbsolutePath();
    }

    public String getCanonicalPath() throws IOException {
        return this.delegate.getCanonicalPath();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getParent() {
        return this.delegate.getParent();
    }

    public String getPath() {
        return this.delegate.getPath();
    }

    public boolean isAbsolute() {
        return this.delegate.isAbsolute();
    }

    public boolean isHidden() {
        return this.delegate.isHidden();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public URI toURI() {
        return this.delegate.toURI();
    }

    public URL toURL() throws MalformedURLException {
        return this.delegate.toURL();
    }

    public boolean exists() {
        if (this.enclZipFile == null) {
            return this.delegate.exists();
        }
        return this.exists(this.enclZipFile.getZipController(), this.enclZipEntryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exists(ZipController zipController, String string) {
        try {
            ZipController zipController2 = zipController;
            synchronized (zipController2) {
                ZipFileSystem zipFileSystem = zipController.getFileSystem();
                return zipFileSystem.get(string) != null || zipFileSystem.get(string + "/") != null;
            }
        }
        catch (ZipController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.exists(zipController.enclController, File.catEntryName(zipController, string));
        }
        catch (ZipController.FalsePositiveNativeException falsePositiveNativeException) {
            return this.delegate.exists();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isFile() {
        if (this.innerZipFile == null) {
            return this.delegate.isFile();
        }
        return this.isFile(this.innerZipFile.getZipController(), this.innerZipEntryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFile(ZipController zipController, String string) {
        try {
            ZipController zipController2 = zipController;
            synchronized (zipController2) {
                return zipController.getFileSystem().get(string) != null;
            }
        }
        catch (ZipController.FalsePositiveEntryException falsePositiveEntryException) {
            if (this.isZipFile() && falsePositiveEntryException.getCause() instanceof FileNotFoundException) {
                return false;
            }
            return this.isFile(zipController.enclController, File.catEntryName(zipController, string));
        }
        catch (ZipController.FalsePositiveNativeException falsePositiveNativeException) {
            if (this.isZipFile() && falsePositiveNativeException.getCause() instanceof FileNotFoundException) {
                return false;
            }
            return this.delegate.isFile();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isDirectory() {
        if (this.innerZipFile == null) {
            return this.delegate.isDirectory();
        }
        return this.isDirectory(this.innerZipFile.getZipController(), this.innerZipEntryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirectory(ZipController zipController, String string) {
        try {
            ZipController zipController2 = zipController;
            synchronized (zipController2) {
                return zipController.getFileSystem().get(string + "/") != null;
            }
        }
        catch (ZipController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.isDirectory(zipController.enclController, File.catEntryName(zipController, string));
        }
        catch (ZipController.FalsePositiveNativeException falsePositiveNativeException) {
            return this.delegate.isDirectory();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean canRead() {
        if (this.innerZipFile == null) {
            return this.delegate.canRead();
        }
        return this.canRead(this.innerZipFile.getZipController(), this.innerZipEntryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canRead(ZipController zipController, String string) {
        try {
            ZipController zipController2 = zipController;
            synchronized (zipController2) {
                ZipFileSystem zipFileSystem = zipController.getFileSystem();
                return zipFileSystem.get(string) != null || zipFileSystem.get(string + "/") != null;
            }
        }
        catch (ZipController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.canRead(zipController.enclController, File.catEntryName(zipController, string));
        }
        catch (ZipController.FalsePositiveNativeException falsePositiveNativeException) {
            return this.delegate.canRead();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean canWrite() {
        if (this.innerZipFile == null) {
            return this.delegate.canWrite();
        }
        return this.canWrite(this.innerZipFile.getZipController(), this.innerZipEntryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canWrite(ZipController zipController, String string) {
        try {
            ZipController zipController2 = zipController;
            synchronized (zipController2) {
                ZipFileSystem zipFileSystem = zipController.getFileSystem();
                return !zipFileSystem.isReadOnly() && (zipFileSystem.get(string) != null || zipFileSystem.get(string + "/") != null);
            }
        }
        catch (ZipController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.canWrite(zipController.enclController, File.catEntryName(zipController, string));
        }
        catch (ZipController.FalsePositiveNativeException falsePositiveNativeException) {
            return this.delegate.canWrite();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean setReadOnly() {
        if (this.innerZipFile == null) {
            return this.delegate.setReadOnly();
        }
        return this.setReadOnly(this.innerZipFile.getZipController(), this.innerZipEntryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setReadOnly(ZipController zipController, String string) {
        try {
            ZipController zipController2 = zipController;
            synchronized (zipController2) {
                ZipFileSystem zipFileSystem = zipController.getFileSystem();
                return zipFileSystem.isReadOnly() && (zipFileSystem.get(string) != null || zipFileSystem.get(string + "/") != null);
            }
        }
        catch (ZipController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.setReadOnly(zipController.enclController, File.catEntryName(zipController, string));
        }
        catch (ZipController.FalsePositiveNativeException falsePositiveNativeException) {
            return this.delegate.setReadOnly();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public long length() {
        if (this.innerZipFile == null) {
            return this.delegate.length();
        }
        return this.length(this.innerZipFile.getZipController(), this.innerZipEntryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long length(ZipController zipController, String string) {
        try {
            ZipController zipController2 = zipController;
            synchronized (zipController2) {
                ZipEntry zipEntry = zipController.getFileSystem().get(string);
                if (zipEntry != null) {
                    long l = zipEntry.getSize();
                    long l2 = l != -1L ? l : 0L;
                    return l2;
                }
                return 0L;
            }
        }
        catch (ZipController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.length(zipController.enclController, File.catEntryName(zipController, string));
        }
        catch (ZipController.FalsePositiveNativeException falsePositiveNativeException) {
            return this.delegate.length();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public long lastModified() {
        if (this.innerZipFile == null) {
            return this.delegate.lastModified();
        }
        return this.lastModified(this.innerZipFile.getZipController(), this.innerZipEntryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lastModified(ZipController zipController, String string) {
        try {
            ZipController zipController2 = zipController;
            synchronized (zipController2) {
                ZipFileSystem zipFileSystem = zipController.getFileSystem();
                ZipEntry zipEntry = zipFileSystem.get(string);
                if (zipEntry == null) {
                    zipEntry = zipFileSystem.get(string + "/");
                }
                if (zipEntry != null) {
                    long l = zipEntry.getTime();
                    long l2 = l != -1L ? l : 0L;
                    return l2;
                }
                return 0L;
            }
        }
        catch (ZipController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.lastModified(zipController.enclController, File.catEntryName(zipController, string));
        }
        catch (ZipController.FalsePositiveNativeException falsePositiveNativeException) {
            return this.delegate.lastModified();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public boolean setLastModified(long l) {
        if (this.innerZipFile == null) {
            return this.delegate.setLastModified(l);
        }
        return this.setLastModified(l, this.innerZipFile.getZipController(), this.innerZipEntryName);
    }

    private boolean setLastModified(long l, ZipController zipController, String string) {
        try {
            ZipController zipController2 = zipController;
            synchronized (zipController2) {
                while (true) {
                    ZipFileSystem zipFileSystem;
                    ZipEntry zipEntry;
                    if ((zipEntry = (zipFileSystem = zipController.getFileSystem()).get(string)) == null && (zipEntry = zipFileSystem.get(string + "/")) == null) {
                        return false;
                    }
                    if (zipEntry.compareToTime(l) == 0L) {
                        return !zipFileSystem.isReadOnly();
                    }
                    if (!zipController.isWritten(string)) {
                        zipEntry.touch(l);
                        return true;
                    }
                    zipController.update();
                }
            }
        }
        catch (ZipController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.setLastModified(l, zipController.enclController, File.catEntryName(zipController, string));
        }
        catch (ZipController.FalsePositiveNativeException falsePositiveNativeException) {
            return this.delegate.setLastModified(l);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String[] list() {
        if (this.innerZipFile == null) {
            return this.delegate.list();
        }
        return this.list(this.innerZipFile.getZipController(), this.innerZipEntryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] list(ZipController zipController, String string) {
        try {
            ZipController zipController2 = zipController;
            synchronized (zipController2) {
                ZipEntry zipEntry = zipController.getFileSystem().get(string + "/");
                if (zipEntry != null) {
                    return zipEntry.list();
                }
                return null;
            }
        }
        catch (ZipController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.list(zipController.enclController, File.catEntryName(zipController, string));
        }
        catch (ZipController.FalsePositiveNativeException falsePositiveNativeException) {
            return this.delegate.list();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String[] list(FilenameFilter filenameFilter) {
        if (this.innerZipFile == null) {
            return this.delegate.list(filenameFilter);
        }
        return this.list(filenameFilter, this.innerZipFile.getZipController(), this.innerZipEntryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] list(FilenameFilter filenameFilter, ZipController zipController, String string) {
        try {
            ZipController zipController2 = zipController;
            synchronized (zipController2) {
                ZipEntry zipEntry = zipController.getFileSystem().get(string + "/");
                if (zipEntry != null) {
                    if (filenameFilter != null) {
                        return zipEntry.list(filenameFilter, this);
                    }
                    return zipEntry.list();
                }
                return null;
            }
        }
        catch (ZipController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.list(filenameFilter, zipController.enclController, File.catEntryName(zipController, string));
        }
        catch (ZipController.FalsePositiveNativeException falsePositiveNativeException) {
            return this.delegate.list(filenameFilter);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public java.io.File[] listFiles() {
        return this.listFiles((FilenameFilter)null, this.zipDetector);
    }

    public java.io.File[] listFiles(ZipDetector zipDetector) {
        return this.listFiles((FilenameFilter)null, zipDetector);
    }

    public java.io.File[] listFiles(FilenameFilter filenameFilter) {
        return this.listFiles(filenameFilter, this.zipDetector);
    }

    public java.io.File[] listFiles(FilenameFilter filenameFilter, ZipDetector zipDetector) {
        if (this.innerZipFile == null) {
            return File.plain2smartFiles(this.delegate.listFiles(filenameFilter), zipDetector);
        }
        return this.listFiles(filenameFilter, zipDetector, this.innerZipFile.getZipController(), this.innerZipEntryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private java.io.File[] listFiles(FilenameFilter filenameFilter, ZipDetector zipDetector, ZipController zipController, String string) {
        try {
            ZipController zipController2 = zipController;
            synchronized (zipController2) {
                ZipEntry zipEntry = zipController.getFileSystem().get(string + "/");
                if (zipEntry != null) {
                    return zipEntry.listFiles(filenameFilter, this, zipDetector);
                }
                return null;
            }
        }
        catch (ZipController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.listFiles(filenameFilter, zipDetector, zipController.enclController, File.catEntryName(zipController, string));
        }
        catch (ZipController.FalsePositiveNativeException falsePositiveNativeException) {
            return File.plain2smartFiles(this.delegate.listFiles(filenameFilter), zipDetector);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static java.io.File[] plain2smartFiles(java.io.File[] fileArray, ZipDetector zipDetector) {
        if (fileArray == null) {
            return null;
        }
        int n = fileArray.length;
        while (0 <= --n) {
            fileArray[n] = zipDetector.createFile(fileArray[n]);
        }
        return fileArray;
    }

    public final java.io.File[] listFiles(FileFilter fileFilter) {
        return this.listFiles(fileFilter, this.zipDetector);
    }

    public java.io.File[] listFiles(FileFilter fileFilter, ZipDetector zipDetector) {
        if (this.innerZipFile == null) {
            return this.delegateListFiles(fileFilter, zipDetector);
        }
        return this.listFiles(fileFilter, zipDetector, this.innerZipFile.getZipController(), this.innerZipEntryName);
    }

    private java.io.File[] delegateListFiles(FileFilter fileFilter, ZipDetector zipDetector) {
        ArrayList<File> arrayList = new ArrayList<File>();
        String[] stringArray = this.delegate.list();
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            File file = zipDetector.createFile((java.io.File)this, string);
            if (fileFilter != null && !fileFilter.accept(file)) continue;
            arrayList.add(file);
        }
        java.io.File[] fileArray = new java.io.File[arrayList.size()];
        arrayList.toArray(fileArray);
        return fileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private java.io.File[] listFiles(FileFilter fileFilter, ZipDetector zipDetector, ZipController zipController, String string) {
        try {
            ZipController zipController2 = zipController;
            synchronized (zipController2) {
                ZipEntry zipEntry = zipController.getFileSystem().get(string + "/");
                if (zipEntry != null) {
                    return zipEntry.listFiles(fileFilter, this, zipDetector);
                }
                return null;
            }
        }
        catch (ZipController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.listFiles(fileFilter, zipDetector, zipController.enclController, File.catEntryName(zipController, string));
        }
        catch (ZipController.FalsePositiveNativeException falsePositiveNativeException) {
            return this.delegateListFiles(fileFilter, zipDetector);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean createNewFile() throws IOException {
        if (this.enclZipFile == null) {
            return this.delegate.createNewFile();
        }
        return this.createNewFile(this.enclZipFile.getZipController(), this.enclZipEntryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createNewFile(ZipController zipController, String string) throws IOException {
        try {
            ZipController zipController2 = zipController;
            synchronized (zipController2) {
                ZipFileSystem zipFileSystem = zipController.getFileSystem(File.isLenient());
                if (zipFileSystem.get(string) != null) {
                    return false;
                }
                zipController.getOutputStream(string).close();
                return true;
            }
        }
        catch (ZipController.FalsePositiveException falsePositiveException) {
            return false;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    public boolean mkdir() {
        if (this.innerZipFile == null) {
            return this.delegate.mkdir();
        }
        return this.mkdir(this.innerZipFile.getZipController(), this.innerZipEntryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mkdir(ZipController zipController, String string) {
        try {
            ZipController zipController2 = zipController;
            synchronized (zipController2) {
                if (EMPTY != string) {
                    ZipFileSystem zipFileSystem = zipController.getFileSystem(File.isLenient());
                    try {
                        zipFileSystem.create(string + "/", File.isLenient());
                        return true;
                    }
                    catch (ZipFileSystemException zipFileSystemException) {
                        return false;
                    }
                }
                try {
                    zipController.getFileSystem(false);
                    return false;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    zipController.getFileSystem(true);
                    return true;
                }
            }
        }
        catch (ZipController.FalsePositiveEntryException falsePositiveEntryException) {
            return this.mkdir(zipController.enclController, File.catEntryName(zipController, string));
        }
        catch (ZipController.FalsePositiveNativeException falsePositiveNativeException) {
            if (!$assertionsDisabled && this.isZipFile()) {
                throw new AssertionError();
            }
            return this.delegate.mkdir();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean mkdirs() {
        if (this.innerZipFile == null) {
            return this.delegate.mkdirs();
        }
        File file = (File)this.getParentFile();
        if (file != null && !file.exists()) {
            file.mkdirs();
        }
        return this.mkdir();
    }

    public boolean delete() {
        if (this.innerZipFile == null) {
            return this.delegate.delete();
        }
        return this.delete(this.innerZipFile.getZipController(), this.innerZipEntryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean delete(ZipController zipController, String string) {
        try {
            ZipController zipController2 = zipController;
            synchronized (zipController2) {
                if (zipController.isWritten(string)) {
                    zipController.update();
                }
                ZipFileSystem zipFileSystem = zipController.getFileSystem();
                if (EMPTY != string) {
                    try {
                        if (zipFileSystem.get(string) != null) {
                            zipFileSystem.delete(string);
                            return true;
                        }
                        String string2 = string + "/";
                        if (zipFileSystem.get(string2) != null) {
                            zipFileSystem.delete(string2);
                            return true;
                        }
                    }
                    catch (ZipFileSystemException zipFileSystemException) {
                        // empty catch block
                    }
                    return false;
                }
                if (zipFileSystem.getRoot().size() != 0) {
                    return false;
                }
                zipController.reset();
                if (zipController.usesNativeTargetFile()) {
                    return this.delegate.delete();
                }
                return this.delete(zipController.enclController, EMPTY != string ? zipController.enclEntryName + "/" + string : zipController.enclEntryName);
            }
        }
        catch (ZipController.FalsePositiveDirectoryEntryException falsePositiveDirectoryEntryException) {
            return this.delete(zipController.enclController, File.catEntryName(zipController, string));
        }
        catch (ZipController.FalsePositiveFileEntryException falsePositiveFileEntryException) {
            if (this.isZipFile() && falsePositiveFileEntryException.getCause() instanceof FileNotFoundException) {
                return false;
            }
            return this.delete(zipController.enclController, File.catEntryName(zipController, string));
        }
        catch (ZipController.FalsePositiveNativeException falsePositiveNativeException) {
            if (this.delegate.isDirectory()) {
                return this.delegate.delete();
            }
            if (this.isZipFile() && falsePositiveNativeException.getCause() instanceof FileNotFoundException) {
                return false;
            }
            return this.delegate.delete();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean deleteAll() {
        boolean bl = true;
        if (this.isDirectory()) {
            java.io.File[] fileArray = this.listFiles(ZipDetector.NULL);
            int n = fileArray.length;
            while (--n >= 0) {
                bl &= ((File)fileArray[n]).deleteAll();
            }
        }
        return bl && this.delete();
    }

    public void deleteOnExit() {
        if (this.innerZipFile == null) {
            this.delegate.deleteOnExit();
            return;
        }
        if (this.isZipFile()) {
            this.isDirectory();
        }
        ZipController.ShutdownHook.deleteOnExit.add(this);
    }

    public final boolean renameTo(java.io.File file) {
        return this.renameTo(file, this.zipDetector);
    }

    public boolean renameTo(java.io.File file, ZipDetector zipDetector) {
        if (!(this.innerZipFile != null || file instanceof File && ((File)file).innerZipFile != null)) {
            return this.delegate.renameTo(file);
        }
        return !file.exists() && !File.contains(this, file) && File.rename(this, file, zipDetector);
    }

    private static boolean rename(java.io.File file, java.io.File file2, ZipDetector zipDetector) {
        boolean bl = true;
        if (file.isDirectory()) {
            file2.mkdir();
            Object[] objectArray = file.list();
            if (file2 instanceof File && ((File)file2).innerZipFile != null) {
                Arrays.sort(objectArray);
            }
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                bl &= File.rename(zipDetector.createFile(file, (String)object), zipDetector.createFile(file2, (String)object), zipDetector);
            }
            long l = file.lastModified();
            if (l > 0L || !(file instanceof File) || !((File)file).isZipEntry()) {
                bl &= file2.setLastModified(l);
            }
        } else if (file.isFile()) {
            try {
                File.cp(file, file2, true);
            }
            catch (IOException iOException) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl && file.delete();
    }

    public boolean copyFrom(InputStream inputStream) {
        try {
            FileOutputStream fileOutputStream = this.zipDetector.createFileOutputStream(this, false);
            try {
                File.cp(inputStream, fileOutputStream);
                return true;
            }
            catch (IOException iOException) {
                if (!this.delete()) {
                    this.zipDetector.createFileOutputStream(this, false).close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public boolean copyFrom(java.io.File file) {
        try {
            File.cp(file, this, false);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean copyAllFrom(java.io.File file) {
        return File.copyAll(file, this, this.zipDetector, this.zipDetector, false);
    }

    public boolean copyAllFrom(java.io.File file, ZipDetector zipDetector) {
        return File.copyAll(file, this, zipDetector, zipDetector, false);
    }

    public boolean copyAllFrom(java.io.File file, ZipDetector zipDetector, ZipDetector zipDetector2) {
        return File.copyAll(file, this, zipDetector, zipDetector2, false);
    }

    public boolean copyTo(OutputStream outputStream) {
        try {
            FileInputStream fileInputStream = this.zipDetector.createFileInputStream(this);
            File.cp(fileInputStream, outputStream);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean copyTo(java.io.File file) {
        try {
            File.cp(this, file, false);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean copyAllTo(java.io.File file) {
        return File.copyAll(this, file, this.zipDetector, this.zipDetector, false);
    }

    public boolean copyAllTo(java.io.File file, ZipDetector zipDetector) {
        return File.copyAll(this, file, zipDetector, zipDetector, false);
    }

    public boolean copyAllTo(java.io.File file, ZipDetector zipDetector, ZipDetector zipDetector2) {
        return File.copyAll(this, file, zipDetector, zipDetector2, false);
    }

    public boolean archiveCopyFrom(java.io.File file) {
        try {
            File.cp(file, this, true);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean archiveCopyAllFrom(java.io.File file) {
        return File.copyAll(file, this, this.zipDetector, this.zipDetector, true);
    }

    public boolean archiveCopyAllFrom(java.io.File file, ZipDetector zipDetector) {
        return File.copyAll(file, this, zipDetector, zipDetector, true);
    }

    public boolean archiveCopyAllFrom(java.io.File file, ZipDetector zipDetector, ZipDetector zipDetector2) {
        return File.copyAll(file, this, zipDetector, zipDetector2, true);
    }

    public boolean archiveCopyTo(java.io.File file) {
        try {
            File.cp(this, file, true);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean archiveCopyAllTo(java.io.File file) {
        return File.copyAll(this, file, this.zipDetector, this.zipDetector, true);
    }

    public boolean archiveCopyAllTo(java.io.File file, ZipDetector zipDetector) {
        return File.copyAll(this, file, zipDetector, zipDetector, true);
    }

    public boolean archiveCopyAllTo(java.io.File file, ZipDetector zipDetector, ZipDetector zipDetector2) {
        return File.copyAll(this, file, zipDetector, zipDetector2, true);
    }

    private static final boolean copyAll(java.io.File file, java.io.File file2, ZipDetector zipDetector, ZipDetector zipDetector2, boolean bl) {
        return !File.contains(file, file2) && File._copyAll(file, file2, zipDetector, zipDetector2, bl);
    }

    private static boolean _copyAll(java.io.File file, java.io.File file2, ZipDetector zipDetector, ZipDetector zipDetector2, boolean bl) {
        if (file.isDirectory()) {
            boolean bl2;
            boolean bl3 = bl2 = file2.mkdir() || file2.isDirectory();
            if (bl2) {
                long l;
                Object[] objectArray = file.list();
                if (file2 instanceof File && ((File)file2).innerZipFile != null) {
                    Arrays.sort(objectArray);
                }
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object object = objectArray[i];
                    bl2 &= File._copyAll(zipDetector.createFile(file, (String)object), zipDetector2.createFile(file2, (String)object), zipDetector, zipDetector2, bl);
                }
                if (!(!bl || (l = file.lastModified()) <= 0L && file instanceof File && ((File)file).isZipEntry())) {
                    bl2 &= file2.setLastModified(l);
                }
            }
            return bl2;
        }
        if (file.isFile() && (!file2.exists() || file2.isFile())) {
            try {
                File.cp(file, file2, bl);
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    public static final void cp_p(java.io.File file, java.io.File file2) throws IOException {
        File.cp(file, file2, true);
    }

    public static final void cp(java.io.File file, java.io.File file2) throws IOException {
        File.cp(file, file2, false);
    }

    private static void cp(java.io.File file, java.io.File file2, boolean bl) throws IOException {
        Object object;
        if (file == null || file2 == null) {
            throw new NullPointerException();
        }
        if (file instanceof File) {
            object = (File)file;
            if (((File)object).isZipFile() && (((File)object).isDirectory() || ((File)object).exists() && !((File)object).isFile())) {
                throw new FileNotFoundException(file.getPath() + ": Cannot read (possibly inaccessible) ZIP compatible files!");
            }
            String string = ((File)object).enclZipEntryName;
            if (string != null) {
                File.cp((File)object, ((File)object).enclZipFile.getZipController(), string, file2, bl);
                return;
            }
        }
        try {
            object = new java.io.FileInputStream(file);
        }
        catch (IOException iOException) {
            throw new InputIOException(iOException);
        }
        File.cp(file, (InputStream)object, file2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cp(File file, ZipController zipController, String string, java.io.File file2, boolean bl) throws IOException {
        try {
            ZipController zipController2 = zipController;
            synchronized (zipController2) {
                Object object;
                Object object2;
                ZipEntry zipEntry = zipController.getFileSystem().get(string);
                if (file2 instanceof File) {
                    object2 = (File)file2;
                    if (((File)object2).isZipFile() && (((File)object2).isDirectory() || ((File)object2).exists() && !((File)object2).isFile())) {
                        throw new FileNotFoundException(file2.getPath() + ": Cannot overwrite (possibly inaccessible) ZIP compatible files!");
                    }
                    object = ((File)object2).enclZipEntryName;
                    if (object != null) {
                        File.cp(file, zipController, zipEntry, (File)object2, ((File)object2).enclZipFile.getZipController(), (String)object, bl);
                        return;
                    }
                }
                try {
                    object2 = zipController.getInputStream(string);
                }
                catch (IOException iOException) {
                    throw new InputIOException(iOException);
                }
                try {
                    object = new java.io.FileOutputStream(file2);
                }
                catch (IOException iOException) {
                    ((InputStream)object2).close();
                    throw iOException;
                }
                try {
                    File.cp((InputStream)object2, (OutputStream)object);
                }
                catch (IOException iOException) {
                    if (!file2.delete()) {
                        new java.io.FileOutputStream(file2).close();
                    }
                    throw iOException;
                }
                if (bl && !file2.setLastModified(zipEntry.getTime())) {
                    throw new IOException(file2.getPath() + ": Couldn't preserve last modification time!");
                }
            }
        }
        catch (ZipController.FalsePositiveEntryException falsePositiveEntryException) {
            File.cp(file, zipController.enclController, File.catEntryName(zipController, string), file2, bl);
        }
        catch (ZipController.FalsePositiveNativeException falsePositiveNativeException) {
            File.cp(file.delegate, file2, bl);
        }
        catch (ZipBusyException zipBusyException) {
            throw new FileBusyException(file, zipBusyException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cp(File file, ZipController zipController, ZipEntry zipEntry, File file2, ZipController zipController2, String string, boolean bl) throws IOException {
        try {
            ZipController zipController3 = zipController2;
            synchronized (zipController3) {
                OutputStream outputStream;
                InputStream inputStream;
                if (zipController == zipController2 && zipController2.isWritten(string)) {
                    zipController2.update();
                    zipEntry = zipController.getFileSystem().get(zipEntry.getName());
                }
                try {
                    inputStream = zipController.getInputStream(zipEntry.getName(), false);
                }
                catch (IOException iOException) {
                    throw new InputIOException(iOException);
                }
                try {
                    outputStream = zipController2.getOutputStream(string, bl ? zipEntry.getTime() : -1L, 9, zipEntry);
                }
                catch (IOException iOException) {
                    inputStream.close();
                    throw iOException;
                }
                try {
                    File.cp(inputStream, outputStream);
                }
                catch (IOException iOException) {
                    if (!file2.delete()) {
                        zipController2.getOutputStream(string, -1L, 9, zipEntry).close();
                    }
                    throw iOException;
                }
            }
        }
        catch (ZipController.FalsePositiveEntryException falsePositiveEntryException) {
            File.cp(file, zipController, zipEntry, file2, zipController2.enclController, File.catEntryName(zipController2, string), bl);
        }
        catch (ZipController.FalsePositiveNativeException falsePositiveNativeException) {
            File.cp(file, zipController, zipEntry.getName(), file2.delegate, bl);
        }
        catch (ZipBusyException zipBusyException) {
            throw new FileBusyException(file2, zipBusyException);
        }
    }

    private static void cp(java.io.File file, InputStream inputStream, java.io.File file2, boolean bl) throws IOException {
        Object object;
        if (file2 instanceof File) {
            object = (File)file2;
            if (((File)object).isZipFile() && (((File)object).isDirectory() || ((File)object).exists() && !((File)object).isFile())) {
                inputStream.close();
                throw new FileNotFoundException(file2.getPath() + ": Cannot overwrite (possibly inaccessible) ZIP compatible files!");
            }
            String string = ((File)object).enclZipEntryName;
            if (string != null) {
                File.cp(file, inputStream, (File)object, ((File)object).enclZipFile.getZipController(), string, bl);
                return;
            }
        }
        try {
            object = new java.io.FileOutputStream(file2);
        }
        catch (IOException iOException) {
            inputStream.close();
            throw iOException;
        }
        try {
            File.cp(inputStream, (OutputStream)object);
        }
        catch (IOException iOException) {
            if (!file2.delete()) {
                new java.io.FileOutputStream(file2).close();
            }
            throw iOException;
        }
        if (bl && !file2.setLastModified(file.lastModified())) {
            throw new IOException(file2.getPath() + ": Couldn't preserve last modification time!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cp(java.io.File file, InputStream inputStream, File file2, ZipController zipController, String string, boolean bl) throws IOException {
        try {
            ZipController zipController2 = zipController;
            synchronized (zipController2) {
                OutputStream outputStream;
                try {
                    outputStream = zipController.getOutputStream(string, bl ? file.lastModified() : -1L, 9, null);
                }
                catch (IOException iOException) {
                    inputStream.close();
                    throw iOException;
                }
                try {
                    File.cp(inputStream, outputStream);
                }
                catch (IOException iOException) {
                    if (!file2.delete()) {
                        zipController.getOutputStream(string, -1L, 9, null).close();
                    }
                    throw iOException;
                }
            }
        }
        catch (ZipController.FalsePositiveEntryException falsePositiveEntryException) {
            File.cp(file, inputStream, file2, zipController.enclController, File.catEntryName(zipController, string), bl);
        }
        catch (ZipController.FalsePositiveNativeException falsePositiveNativeException) {
            File.cp(file, inputStream, file2.delegate, bl);
        }
        catch (ZipBusyException zipBusyException) {
            throw new FileBusyException(file2, zipBusyException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cp(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            try {
                File.cat(inputStream, outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new InputIOException(iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean catFrom(InputStream inputStream) {
        try {
            FileOutputStream fileOutputStream = this.zipDetector.createFileOutputStream(this, false);
            try {
                try {
                    File.cat(inputStream, fileOutputStream);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {
                this.delete();
                return false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean catTo(OutputStream outputStream) {
        boolean bl;
        FileInputStream fileInputStream = this.zipDetector.createFileInputStream(this);
        try {
            File.cat(fileInputStream, outputStream);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        ((InputStream)fileInputStream).close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cat(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (inputStream == null || outputStream == null) {
            throw new NullPointerException();
        }
        Buffer[] bufferArray = File.allocateBuffers();
        try {
            class Reader
            extends Thread {
                int off;
                int len;
                volatile InputIOException exception;
                private final /* synthetic */ InputStream val$in;
                private final /* synthetic */ Buffer[] val$buffers;

                Reader(InputStream inputStream, Buffer[] bufferArray) {
                    this.val$in = inputStream;
                    this.val$buffers = bufferArray;
                    super("TrueZIP Async Stream Reader");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int n;
                    InputStream inputStream = this.val$in;
                    Buffer[] bufferArray = this.val$buffers;
                    int n2 = this.val$buffers.length;
                    do {
                        Buffer buffer;
                        Object object = this;
                        synchronized (object) {
                            while (this.len >= n2) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    return;
                                }
                            }
                            buffer = bufferArray[(this.off + this.len) % n2];
                        }
                        object = buffer.buf;
                        try {
                            n = inputStream.read((byte[])object, 0, ((Object)object).length);
                        }
                        catch (IOException iOException) {
                            n = -1;
                            this.exception = new InputIOException(iOException);
                        }
                        if (Thread.interrupted()) {
                            n = -1;
                        }
                        buffer.read = n;
                        Reader reader = this;
                        synchronized (reader) {
                            ++this.len;
                            this.notify();
                        }
                    } while (n != -1);
                }

                private void shutdown() {
                    this.interrupt();
                    while (true) {
                        try {
                            this.join();
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            }
            Reader reader = new Reader(inputStream, bufferArray);
            reader.start();
            int n = bufferArray.length;
            while (true) {
                Buffer buffer;
                int n2;
                Object object = reader;
                synchronized (object) {
                    while (reader.len <= 0) {
                        try {
                            reader.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    n2 = reader.off;
                    buffer = bufferArray[n2];
                }
                int n3 = buffer.read;
                if (n3 == -1) break;
                object = buffer.buf;
                try {
                    outputStream.write((byte[])object, 0, n3);
                }
                catch (IOException iOException) {
                    reader.shutdown();
                    throw iOException;
                }
                Reader reader2 = reader;
                synchronized (reader2) {
                    reader.off = (n2 + 1) % n;
                    --reader.len;
                    reader.notify();
                }
            }
            if (reader.exception != null) {
                throw reader.exception;
            }
        }
        finally {
            File.releaseBuffers(bufferArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Buffer[] allocateBuffers() {
        Buffer[] bufferArray = buffersList;
        synchronized (buffersList) {
            Iterator iterator = buffersList.iterator();
            while (iterator.hasNext()) {
                Buffer[] bufferArray2 = (Buffer[])((Reference)iterator.next()).get();
                iterator.remove();
                if (bufferArray2 == null) continue;
                // ** MonitorExit[var0] (shouldn't be in output)
                return bufferArray2;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            bufferArray = new Buffer[4];
            int n = bufferArray.length;
            while (--n >= 0) {
                bufferArray[n] = new Buffer();
            }
            return bufferArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void releaseBuffers(Buffer[] bufferArray) {
        List list = buffersList;
        synchronized (list) {
            buffersList.add(new SoftReference<Buffer[]>(bufferArray));
        }
    }

    static {
        $assertionsDisabled = !File.class.desiredAssertionStatus();
        defaultZipDetector = DefaultRaesZipDetector.DEFAULT;
        lenient = true;
        roots = new HashSet<java.io.File>(Arrays.asList(File.listRoots()));
        uncPrefix = separator + separator;
        buffersList = new LinkedList();
        Logger.getLogger("de.schlichtherle.io.File", "de.schlichtherle.io.File").config("intro");
    }

    private static class Buffer {
        byte[] buf = new byte[65536];
        int read;

        private Buffer() {
        }
    }
}

