/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.DefaultRaesZipDetector;
import de.schlichtherle.io.File;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import de.schlichtherle.io.ZipEntry;
import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.util.zip.ZipFile;
import de.schlichtherle.util.zip.ZipOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;

public interface ZipDetector {
    public static final String ZIP_ENCODING = "CP437";
    public static final String JAR_ENCODING = "UTF-8";
    public static final String SFX_ENCODING = System.getProperty("file.encoding");
    public static final ZipDetector NULL;
    public static final ZipDetector NONE;
    public static final String EAR_SUFFIXES = "ear";
    public static final ZipDetector EAR;
    public static final String EXE_SUFFIXES = "exe";
    public static final ZipDetector EXE;
    public static final String JAR_SUFFIXES = "jar";
    public static final ZipDetector JAR;
    public static final String RAES_SUFFIXES = "tzp|zip.rae";
    public static final ZipDetector RAES;
    public static final String WAR_SUFFIXES = "war";
    public static final ZipDetector WAR;
    public static final String ZIP_SUFFIXES = "zip";
    public static final ZipDetector ZIP;
    public static final String ZIP_JAR_SUFFIXES = "zip|jar";
    public static final ZipDetector ZIP_JAR;
    public static final String ZIP_RAES_SUFFIXES = "zip|tzp|zip.rae";
    public static final ZipDetector ZIP_RAES;
    public static final String ALL_ZIP_SUFFIXES = "zip";
    public static final String ALL_JAR_SUFFIXES = "ear|jar|war";
    public static final String ALL_RAES_SUFFIXES = "tzp|zip.rae";
    public static final String ALL_SFX_SUFFIXES = "exe";
    public static final String ALL_SUFFIXES = "zip|ear|jar|war|tzp|zip.rae|exe";
    public static final ZipDetector ALL;
    public static final ZipDetector DEFAULT;

    public boolean isZipFile(String var1);

    public ZipFile createZipFile(String var1, ReadOnlyFile var2) throws IOException;

    public ZipOutputStream createZipOutputStream(String var1, OutputStream var2) throws IOException;

    public String getEncoding(String var1);

    public ZipEntry createZipEntry(String var1, boolean var2, String var3);

    public File createFile(String var1);

    public File createFile(String var1, String var2);

    public File createFile(java.io.File var1, String var2);

    public File createFile(URI var1);

    public File createFile(java.io.File var1);

    public File createFile(java.io.File var1, File var2);

    public File createFile(java.io.File var1, File var2, File var3);

    public FileInputStream createFileInputStream(java.io.File var1) throws FileNotFoundException;

    public FileOutputStream createFileOutputStream(java.io.File var1, boolean var2) throws FileNotFoundException;

    static {
        NONE = NULL = new DefaultRaesZipDetector(null);
        EAR = new DefaultRaesZipDetector(EAR_SUFFIXES);
        EXE = new DefaultRaesZipDetector("exe");
        JAR = new DefaultRaesZipDetector(JAR_SUFFIXES);
        RAES = new DefaultRaesZipDetector("tzp|zip.rae");
        WAR = new DefaultRaesZipDetector(WAR_SUFFIXES);
        ZIP = new DefaultRaesZipDetector("zip");
        ZIP_JAR = new DefaultRaesZipDetector(ZIP_JAR_SUFFIXES);
        ZIP_RAES = new DefaultRaesZipDetector(ZIP_RAES_SUFFIXES);
        ALL = new DefaultRaesZipDetector(ALL_SUFFIXES);
        DEFAULT = ZIP_RAES;
    }
}

