/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.rof;

import de.schlichtherle.io.rof.ReadOnlyFile;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class MemoryMappedReadOnlyFile
implements ReadOnlyFile {
    private FileChannel channel;
    private ByteBuffer window;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MemoryMappedReadOnlyFile(File file) throws FileNotFoundException {
        this.channel = new RandomAccessFile(file, "r").getChannel();
        try {
            this.positionWindow(0L);
        }
        catch (IOException iOException) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException();
            fileNotFoundException.initCause(iOException);
            throw fileNotFoundException;
        }
    }

    private void positionWindow(long l) throws IOException {
        if (!$assertionsDisabled && l % Integer.MAX_VALUE != 0L) {
            throw new AssertionError();
        }
        long l2 = this.channel.size();
        if (l > l2) {
            return;
        }
        MappedByteBuffer mappedByteBuffer = this.channel.map(FileChannel.MapMode.READ_ONLY, l, Math.min(l2 - l, Integer.MAX_VALUE));
        this.window = mappedByteBuffer;
    }

    private final void advanceWindow() throws IOException {
        this.positionWindow(this.channel.position() + Integer.MAX_VALUE);
    }

    public long length() throws IOException {
        this.ensureOpen();
        return this.channel.size();
    }

    public long getFilePointer() throws IOException {
        this.ensureOpen();
        return this.channel.position() + (long)this.window.position();
    }

    public void seek(long l) throws IOException {
        if (l < 0L) {
            throw new IOException("File pointer must not be negative!");
        }
        this.ensureOpen();
        if (l > this.channel.size()) {
            throw new IOException("File pointer (" + l + ") is larger than file length (" + this.channel.size() + ")!");
        }
        long l2 = this.channel.position();
        if (l < l2 || l2 + Integer.MAX_VALUE <= l) {
            this.positionWindow(l / Integer.MAX_VALUE * Integer.MAX_VALUE);
        }
        this.window.position((int)(l % Integer.MAX_VALUE));
    }

    public int read() throws IOException {
        if (this.window.remaining() <= 0) {
            this.advanceWindow();
            if (this.window.remaining() <= 0) {
                return -1;
            }
        }
        return this.window.get() & 0xFF;
    }

    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("buf");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        this.ensureOpen();
        int n3 = this.window.remaining();
        if (n3 <= 0) {
            this.advanceWindow();
            n3 = this.window.remaining();
            if (n3 <= 0) {
                return -1;
            }
        }
        if (n2 < n3) {
            n3 = n2;
        }
        this.window.get(byArray, n, n3);
        return n3;
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        do {
            if ((n3 = this.read(byArray, n + n4, n2 - n4)) >= 0) continue;
            throw new EOFException();
        } while ((n4 += n3) < n2);
    }

    public int skipBytes(int n) throws IOException {
        if (n <= 0) {
            return 0;
        }
        this.ensureOpen();
        long l = this.channel.position() + (long)this.window.position();
        long l2 = this.channel.size();
        long l3 = l + (long)n;
        if (l3 > l2) {
            l3 = l2;
        }
        this.seek(l3);
        return (int)(l3 - l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.channel == null) {
            return;
        }
        this.window = null;
        System.gc();
        try {
            this.channel.close();
        }
        finally {
            this.channel = null;
        }
    }

    private final void ensureOpen() throws IOException {
        if (this.channel == null) {
            throw new IOException("Read only file has been closed!");
        }
    }

    static {
        $assertionsDisabled = !MemoryMappedReadOnlyFile.class.desiredAssertionStatus();
    }
}

