/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.swing.tree;

import de.schlichtherle.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FileTreeModel
implements TreeModel {
    private static final Collator collator;
    public static final Comparator FILE_NAME_COMPARATOR;
    private final transient Map cache = new HashMap();
    private final java.io.File root;
    private final FileFilter filter;
    private final transient EventListenerList listeners = new EventListenerList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileTreeModel() {
        this.root = null;
        this.filter = null;
    }

    public FileTreeModel(java.io.File file) {
        this.root = file;
        this.filter = null;
    }

    public FileTreeModel(java.io.File file, FileFilter fileFilter) {
        this.root = file;
        this.filter = fileFilter;
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object object, int n) {
        java.io.File[] fileArray = this.getChildren((java.io.File)object);
        return fileArray != null ? fileArray[n] : null;
    }

    public int getChildCount(Object object) {
        java.io.File[] fileArray = this.getChildren((java.io.File)object);
        return fileArray != null ? fileArray.length : 0;
    }

    public boolean isLeaf(Object object) {
        return !((java.io.File)object).isDirectory();
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object == null || object2 == null) {
            return -1;
        }
        java.io.File[] fileArray = this.getChildren((java.io.File)object);
        if (fileArray == null) {
            return -1;
        }
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            if (!fileArray[i].equals(object2)) continue;
            return i;
        }
        return -1;
    }

    private java.io.File[] getChildren(java.io.File file) {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        java.io.File[] fileArray = (java.io.File[])this.cache.get(file);
        if (fileArray == null) {
            if (this.cache.containsKey(file)) {
                return null;
            }
            fileArray = file.listFiles(this.filter);
            if (fileArray != null) {
                Arrays.sort(fileArray, FILE_NAME_COMPARATOR);
            }
            this.cache.put(file, fileArray);
        }
        return fileArray;
    }

    public TreePath getTreePath(java.io.File file) {
        Object[] objectArray = this.getPath(file);
        return objectArray != null ? new TreePath(objectArray) : null;
    }

    private java.io.File[] getPath(java.io.File file) {
        if (this.root == null) {
            return null;
        }
        return this.getPath(file, 1);
    }

    private java.io.File[] getPath(java.io.File file, int n) {
        java.io.File[] fileArray;
        if (this.root.equals(file)) {
            fileArray = new java.io.File[n];
            fileArray[0] = this.root;
        } else if (file != null) {
            fileArray = this.getPath(file.getParentFile(), n + 1);
            if (fileArray != null) {
                fileArray[fileArray.length - n] = file;
            }
        } else {
            fileArray = null;
        }
        return fileArray;
    }

    public boolean createNewFile(java.io.File file) throws IOException {
        if (!file.createNewFile()) {
            return false;
        }
        this.nodeInserted(file);
        return true;
    }

    public boolean mkdir(java.io.File file) {
        if (!file.mkdir()) {
            return false;
        }
        this.nodeInserted(file);
        return true;
    }

    public boolean mkdirs(java.io.File file) {
        if (!file.mkdirs()) {
            return false;
        }
        this.nodeInserted(file);
        return true;
    }

    public boolean copyFrom(File file, InputStream inputStream) {
        if (!file.copyFrom(inputStream)) {
            return false;
        }
        this.nodeInsertedOrStructureChanged(file);
        return true;
    }

    public boolean copyTo(File file, java.io.File file2) {
        if (!file.copyTo(file2)) {
            return false;
        }
        this.nodeInsertedOrStructureChanged(file2);
        return true;
    }

    public boolean copyAllTo(File file, java.io.File file2) {
        if (!file.copyAllTo(file2)) {
            return false;
        }
        this.nodeInsertedOrStructureChanged(file2);
        return true;
    }

    public boolean archiveCopyTo(File file, java.io.File file2) {
        if (!file.archiveCopyTo(file2)) {
            return false;
        }
        this.nodeInsertedOrStructureChanged(file2);
        return true;
    }

    public boolean archiveCopyAllTo(File file, java.io.File file2) {
        if (!file.archiveCopyAllTo(file2)) {
            return false;
        }
        this.nodeInsertedOrStructureChanged(file2);
        return true;
    }

    public boolean renameTo(java.io.File file, java.io.File file2) {
        boolean bl = file2.exists();
        if (!file.renameTo(file2)) {
            return false;
        }
        this.nodeRemoved(file);
        this.nodeInserted(file2);
        return true;
    }

    public boolean delete(java.io.File file) {
        if (!file.delete()) {
            return false;
        }
        this.nodeRemoved(file);
        return true;
    }

    public boolean deleteAll(File file) {
        if (!file.deleteAll()) {
            return false;
        }
        this.nodeRemoved(file);
        return true;
    }

    public void nodeInsertedOrStructureChanged(java.io.File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        if (this.cache.containsKey(file)) {
            this.structureChanged(file);
        } else {
            this.nodeInserted(file);
        }
    }

    public void nodeInserted(java.io.File file) {
        if (this.cache.containsKey(file)) {
            return;
        }
        java.io.File file2 = file.getParentFile();
        if (!$assertionsDisabled && file2 == null) {
            throw new AssertionError();
        }
        this.forget(file2, false);
        int n = this.getIndexOfChild(file2, file);
        if (n == -1) {
            return;
        }
        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, this.getTreePath(file2), new int[]{n}, (Object[])new java.io.File[]{file}));
    }

    public void nodeChanged(java.io.File file) {
        java.io.File file2 = file.getParentFile();
        if (!$assertionsDisabled && file2 == null) {
            throw new AssertionError();
        }
        int n = this.getIndexOfChild(file2, file);
        if (n == -1) {
            return;
        }
        this.fireTreeNodesChanged(new TreeModelEvent((Object)this, this.getTreePath(file2), new int[]{n}, (Object[])new java.io.File[]{file}));
    }

    public void nodeRemoved(java.io.File file) {
        java.io.File file2 = file.getParentFile();
        if (!$assertionsDisabled && file2 == null) {
            throw new AssertionError();
        }
        if (!this.cache.containsKey(file2)) {
            return;
        }
        int n = this.getIndexOfChild(file2, file);
        if (n == -1) {
            return;
        }
        this.forget(file);
        this.forget(file2, false);
        this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, this.getTreePath(file2), new int[]{n}, (Object[])new java.io.File[]{file}));
    }

    public void refresh() {
        this.cache.clear();
        if (this.root != null) {
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, this.getTreePath(this.root), null, null));
        }
    }

    public final void refresh(java.io.File file) {
        this.structureChanged(file);
    }

    public void structureChanged(java.io.File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.forget(file);
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, this.getTreePath(file), null, null));
    }

    public final void forget(java.io.File file) {
        this.forget(file, true);
    }

    private void forget(java.io.File file, boolean bl) {
        java.io.File[] fileArray = (java.io.File[])this.cache.remove(file);
        if (fileArray != null && bl) {
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                this.forget(fileArray[i], bl);
            }
        }
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(TreeModelListener.class, treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(TreeModelListener.class, treeModelListener);
    }

    protected void fireTreeNodesChanged(TreeModelEvent treeModelEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(TreeModelListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TreeModelListener)eventListenerArray[i]).treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent treeModelEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(TreeModelListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TreeModelListener)eventListenerArray[i]).treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent treeModelEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(TreeModelListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TreeModelListener)eventListenerArray[i]).treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent treeModelEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(TreeModelListener.class);
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ((TreeModelListener)eventListenerArray[i]).treeStructureChanged(treeModelEvent);
        }
    }

    static {
        $assertionsDisabled = !FileTreeModel.class.desiredAssertionStatus();
        collator = Collator.getInstance();
        collator.setDecomposition(0);
        collator.setStrength(java.io.File.separatorChar == '\\' ? 1 : 2);
        FILE_NAME_COMPARATOR = new Comparator(){

            public final int compare(Object object, Object object2) {
                return this.compare((java.io.File)object, (java.io.File)object2);
            }

            public int compare(java.io.File file, java.io.File file2) {
                if (file.isDirectory()) {
                    if (file2.isDirectory()) {
                        return collator.compare(file.getName(), file2.getName());
                    }
                    return -1;
                }
                if (file2.isDirectory()) {
                    return 1;
                }
                return collator.compare(file.getName(), file2.getName());
            }
        };
    }
}

