/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.swing;

import de.schlichtherle.swing.event.PanelEvent;
import de.schlichtherle.swing.event.PanelListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.EventListener;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.EventListenerList;

public class EnhancedPanel
extends JPanel {
    private final ComponentListener cl = new ComponentListener(){

        public void componentHidden(ComponentEvent componentEvent) {
            EnhancedPanel.this.fireAncestorWindowHidden(new PanelEvent(EnhancedPanel.this));
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
            EnhancedPanel.this.fireAncestorWindowShown(new PanelEvent(EnhancedPanel.this));
        }
    };
    private EventListenerList listenerList;

    public EnhancedPanel(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
        this.init();
    }

    public EnhancedPanel(LayoutManager layoutManager) {
        super(layoutManager);
        this.init();
    }

    public EnhancedPanel(boolean bl) {
        super(bl);
        this.init();
    }

    public EnhancedPanel() {
        this.init();
    }

    private void init() {
        this.addAncestorListener(new AncestorListener(){

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                Window window = EnhancedPanel.getAncestorWindow(ancestorEvent.getAncestor());
                window.addComponentListener(EnhancedPanel.this.cl);
                if (window.isVisible() || window == JOptionPane.getRootFrame()) {
                    EnhancedPanel.this.cl.componentShown(null);
                }
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                Window window = EnhancedPanel.getAncestorWindow(ancestorEvent.getAncestorParent());
                window.removeComponentListener(EnhancedPanel.this.cl);
                if (!window.isVisible() || window == JOptionPane.getRootFrame()) {
                    EnhancedPanel.this.cl.componentHidden(null);
                }
            }
        });
    }

    public Window getAncestorWindow() {
        return EnhancedPanel.getAncestorWindow(this);
    }

    private static Window getAncestorWindow(Component component) {
        Container container;
        for (container = component.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
        }
        return (Window)container;
    }

    public void addPanelListener(PanelListener panelListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(PanelListener.class, panelListener);
    }

    public void removePanelListener(PanelListener panelListener) {
        if (this.listenerList == null) {
            return;
        }
        this.listenerList.remove(PanelListener.class, panelListener);
    }

    public PanelListener[] getPanelListeners() {
        if (this.listenerList != null) {
            return (PanelListener[])this.listenerList.getListeners(PanelListener.class);
        }
        return new PanelListener[0];
    }

    public EventListener[] getListeners(Class clazz) {
        if (clazz == PanelListener.class) {
            return this.getPanelListeners();
        }
        return super.getListeners(clazz);
    }

    protected void fireAncestorWindowShown(PanelEvent panelEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$de$schlichtherle$swing$event$PanelListener == null ? EnhancedPanel.class$("de.schlichtherle.swing.event.PanelListener") : class$de$schlichtherle$swing$event$PanelListener)) continue;
            ((PanelListener)objectArray[i + 1]).ancestorWindowShown(panelEvent);
        }
    }

    protected void fireAncestorWindowHidden(PanelEvent panelEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$de$schlichtherle$swing$event$PanelListener == null ? EnhancedPanel.class$("de.schlichtherle.swing.event.PanelListener") : class$de$schlichtherle$swing$event$PanelListener)) continue;
            ((PanelListener)objectArray[i + 1]).ancestorWindowHidden(panelEvent);
        }
    }
}

