/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.CalendarData;
import com.ibm.icu.impl.PatternTokenizer;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.Freezable;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DateTimePatternGenerator
implements Freezable,
Cloneable {
    static Transliterator fromHex = Transliterator.getInstance("hex-any");
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int QUARTER = 2;
    public static final int MONTH = 3;
    public static final int WEEK_OF_YEAR = 4;
    public static final int WEEK_OF_MONTH = 5;
    public static final int WEEKDAY = 6;
    public static final int DAY = 7;
    public static final int DAY_OF_YEAR = 8;
    public static final int DAY_OF_WEEK_IN_MONTH = 9;
    public static final int DAYPERIOD = 10;
    public static final int HOUR = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int FRACTIONAL_SECOND = 14;
    public static final int ZONE = 15;
    public static final int TYPE_LIMIT = 16;
    private TreeMap skeleton2pattern = new TreeMap();
    private TreeMap basePattern_pattern = new TreeMap();
    private String decimal = "?";
    private String dateTimeFormat = "{0} {1}";
    private String[] appendItemFormats = new String[16];
    private String[] appendItemNames = new String[16];
    private transient DateTimeMatcher current;
    private transient FormatParser fp;
    private transient DistanceInfo _distanceInfo;
    private transient boolean isComplete;
    private transient DateTimeMatcher skipMatcher;
    private transient boolean frozen;
    private static final int FRACTIONAL_MASK = 16384;
    private static final int SECOND_AND_FRACTIONAL_MASK = 24576;
    private static String[] CLDR_FIELD_APPEND = new String[]{"Era", "Year", "Quarter", "Month", "Week", "*", "Day-Of-Week", "Day", "*", "*", "*", "Hour", "Minute", "Second", "*", "Timezone"};
    private static String[] CLDR_FIELD_NAME = new String[]{"era", "year", "quarter", "month", "week", "*", "weekday", "day", "*", "*", "dayperiod", "hour", "minute", "second", "*", "zone"};
    private static String[] FIELD_NAME = new String[]{"Era", "Year", "Quarter", "Month", "Week_in_Year", "Week_in_Month", "Weekday", "Day", "Day_Of_Year", "Day_of_Week_in_Month", "Dayperiod", "Hour", "Minute", "Second", "Fractional_Second", "Zone"};
    private static String[] CANONICAL_ITEMS = new String[]{"G", "y", "Q", "M", "w", "W", "e", "d", "D", "F", "H", "m", "s", "S", "v"};
    private static Set CANONICAL_SET = new HashSet<String>(Arrays.asList(CANONICAL_ITEMS));
    private static final int DATE_MASK = 1023;
    private static final int TIME_MASK = 64512;
    private static final int DELTA = 16;
    private static final int NUMERIC = 256;
    private static final int NONE = 0;
    private static final int NARROW = -256;
    private static final int SHORT = -257;
    private static final int LONG = -258;
    private static final int EXTRA_FIELD = 65536;
    private static final int MISSING_FIELD = 4096;
    private static int[][] types = new int[][]{{71, 0, -257, 1, 3}, {71, 0, -258, 4}, {121, 1, 256, 1, 20}, {89, 1, 272, 1, 20}, {117, 1, 288, 1, 20}, {81, 2, 256, 1, 2}, {81, 2, -257, 3}, {81, 2, -258, 4}, {77, 3, 256, 1, 2}, {77, 3, -257, 3}, {77, 3, -258, 4}, {77, 3, -256, 5}, {76, 3, 272, 1, 2}, {76, 3, -273, 3}, {76, 3, -274, 4}, {76, 3, -272, 5}, {119, 4, 256, 1, 2}, {87, 5, 272, 1}, {101, 6, 272, 1, 2}, {101, 6, -273, 3}, {101, 6, -274, 4}, {101, 6, -272, 5}, {69, 6, -257, 1, 3}, {69, 6, -258, 4}, {69, 6, -256, 5}, {99, 6, 288, 1, 2}, {99, 6, -289, 3}, {99, 6, -290, 4}, {99, 6, -288, 5}, {100, 7, 256, 1, 2}, {68, 8, 272, 1, 3}, {70, 9, 288, 1}, {103, 7, 304, 1, 20}, {97, 10, -257, 1}, {72, 11, 416, 1, 2}, {107, 11, 432, 1, 2}, {104, 11, 256, 1, 2}, {75, 11, 272, 1, 2}, {109, 12, 256, 1, 2}, {115, 13, 256, 1, 2}, {83, 14, 272, 1, 1000}, {65, 13, 288, 1, 1000}, {118, 15, -289, 1}, {118, 15, -290, 4}, {122, 15, -257, 1, 3}, {122, 15, -258, 4}, {90, 15, -273, 1, 3}, {90, 15, -274, 4}};

    public static DateTimePatternGenerator newInstance() {
        return new DateTimePatternGenerator();
    }

    protected DateTimePatternGenerator() {
        for (int i = 0; i < 16; ++i) {
            this.appendItemFormats[i] = "{0} \u251c{2}: {1}\u2524";
            this.appendItemNames[i] = "F" + i;
        }
        this.current = new DateTimeMatcher();
        this.fp = new FormatParser();
        this._distanceInfo = new DistanceInfo();
        this.isComplete = false;
        this.skipMatcher = null;
        this.frozen = false;
        this.complete();
    }

    public static DateTimePatternGenerator getInstance() {
        return DateTimePatternGenerator.getInstance(ULocale.getDefault());
    }

    public static DateTimePatternGenerator getInstance(ULocale uLocale) {
        DateTimePatternGenerator result = new DateTimePatternGenerator();
        PatternInfo returnInfo = new PatternInfo();
        String hackPattern = null;
        for (int i = 0; i <= 3; ++i) {
            SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance(i, uLocale);
            result.add(df.toPattern(), false, returnInfo);
            df = (SimpleDateFormat)DateFormat.getTimeInstance(i, uLocale);
            result.add(df.toPattern(), false, returnInfo);
            if (i != 2) continue;
            hackPattern = df.toPattern();
        }
        UResourceBundle rb = UResourceBundle.getBundleInstance("com.ibm.icu.impl.data.DateData$MyDateResources", uLocale);
        Enumeration<String> en = rb.getKeys();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            String value = rb.getString(key);
            String[] keyParts = key.split("/");
            if (keyParts[0].equals("pattern")) {
                result.add(value, false, returnInfo);
                continue;
            }
            if (keyParts[0].equals("append")) {
                result.setAppendItemFormats(DateTimePatternGenerator.getAppendFormatNumber(keyParts[1]), value);
                continue;
            }
            if (!keyParts[0].equals("field")) continue;
            result.setAppendItemNames(DateTimePatternGenerator.getAppendNameNumber(keyParts[1]), value);
        }
        if (hackPattern != null) {
            DateTimePatternGenerator.hackTimes(result, returnInfo, hackPattern);
        }
        Calendar cal = Calendar.getInstance(uLocale);
        CalendarData calData = new CalendarData(uLocale, cal.getType());
        String[] patterns = calData.get("DateTimePatterns").getStringArray();
        result.setDateTimeFormat(patterns[8]);
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(uLocale);
        result.setDecimal(String.valueOf(dfs.getDecimalSeparator()));
        return result;
    }

    private static void hackTimes(DateTimePatternGenerator result, PatternInfo returnInfo, String hackPattern) {
        result.fp.set(hackPattern);
        String mmss = new String();
        boolean gotMm = false;
        for (int i = 0; i < result.fp.items.size(); ++i) {
            Object item = result.fp.items.get(i);
            if (item instanceof String) {
                if (!gotMm) continue;
                mmss = mmss + result.fp.quoteLiteral(item.toString());
                continue;
            }
            char ch = item.toString().charAt(0);
            if (ch == 'm') {
                gotMm = true;
                mmss = mmss + item;
                continue;
            }
            if (ch == 's') {
                if (!gotMm) break;
                mmss = mmss + item;
                result.add(mmss, false, returnInfo);
                break;
            }
            if (gotMm || ch == 'z' || ch == 'Z' || ch == 'v' || ch == 'V') break;
        }
        BitSet variables = new BitSet();
        BitSet nuke = new BitSet();
        for (int i = 0; i < result.fp.items.size(); ++i) {
            Object item = result.fp.items.get(i);
            if (!(item instanceof VariableField)) continue;
            variables.set(i);
            char ch = item.toString().charAt(0);
            if (ch != 's' && ch != 'S') continue;
            nuke.set(i);
            for (int j = i - 1; j >= 0 && !variables.get(j); ++j) {
                nuke.set(i);
            }
        }
        String hhmm = DateTimePatternGenerator.getFilteredPattern(result.fp, nuke);
        result.add(hhmm, false, returnInfo);
    }

    private static String getFilteredPattern(FormatParser fp, BitSet nuke) {
        String result = new String();
        for (int i = 0; i < fp.items.size(); ++i) {
            if (nuke.get(i)) continue;
            Object item = fp.items.get(i);
            result = item instanceof String ? result + fp.quoteLiteral(item.toString()) : result + item.toString();
        }
        return result;
    }

    private static int getAppendNameNumber(String string) {
        for (int i = 0; i < CLDR_FIELD_NAME.length; ++i) {
            if (!CLDR_FIELD_NAME[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    private static int getAppendFormatNumber(String string) {
        for (int i = 0; i < CLDR_FIELD_APPEND.length; ++i) {
            if (!CLDR_FIELD_APPEND[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public String getBestPattern(String skeleton) {
        this.current.set(skeleton, this.fp);
        String best = this.getBestRaw(this.current, -1, this._distanceInfo);
        if (this._distanceInfo.missingFieldMask == 0 && this._distanceInfo.extraFieldMask == 0) {
            return this.adjustFieldTypes(best, this.current, false);
        }
        int neededFields = this.current.getFieldMask();
        String datePattern = this.getBestAppending(neededFields & 0x3FF);
        String timePattern = this.getBestAppending(neededFields & 0xFC00);
        if (datePattern == null) {
            return timePattern == null ? "" : timePattern;
        }
        if (timePattern == null) {
            return datePattern;
        }
        return MessageFormat.format(this.getDateTimeFormat(), new Object[]{datePattern, timePattern});
    }

    public DateTimePatternGenerator add(String pattern, boolean override, PatternInfo returnInfo) {
        String previousValue;
        DateTimeMatcher matcher;
        String basePattern;
        String previousPatternWithSameBase;
        this.checkFrozen();
        if (pattern.indexOf("\\u") >= 0) {
            String oldPattern = pattern;
            pattern = fromHex.transliterate(pattern);
        }
        if ((previousPatternWithSameBase = (String)this.basePattern_pattern.get(basePattern = (matcher = new DateTimeMatcher().set(pattern, this.fp)).getBasePattern())) != null) {
            returnInfo.status = 1;
            returnInfo.conflictingPattern = previousPatternWithSameBase;
            if (!override) {
                return this;
            }
        }
        if ((previousValue = (String)this.skeleton2pattern.get(matcher)) != null) {
            returnInfo.status = 2;
            returnInfo.conflictingPattern = previousValue;
            if (!override) {
                return this;
            }
        }
        returnInfo.status = 0;
        returnInfo.conflictingPattern = "";
        this.skeleton2pattern.put(matcher, pattern);
        this.basePattern_pattern.put(basePattern, pattern);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSkeleton(String pattern) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(pattern, this.fp);
            return this.current.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBaseSkeleton(String pattern) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            this.current.set(pattern, this.fp);
            return this.current.getBasePattern();
        }
    }

    public Map getSkeletons(Map result) {
        if (result == null) {
            result = new LinkedHashMap<String, String>();
        }
        Iterator it = this.skeleton2pattern.keySet().iterator();
        while (it.hasNext()) {
            DateTimeMatcher item = (DateTimeMatcher)it.next();
            String pattern = (String)this.skeleton2pattern.get(item);
            if (CANONICAL_SET.contains(pattern)) continue;
            result.put(item.toString(), pattern);
        }
        return result;
    }

    public Set getBaseSkeletons(Set result) {
        if (result == null) {
            result = new HashSet();
        }
        result.addAll(this.basePattern_pattern.keySet());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String replaceFieldTypes(String pattern, String skeleton) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            return this.adjustFieldTypes(pattern, this.current.set(skeleton, this.fp), false);
        }
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.checkFrozen();
        this.dateTimeFormat = dateTimeFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDecimal(String decimal) {
        this.checkFrozen();
        this.decimal = decimal;
    }

    public String getDecimal() {
        return this.decimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getRedundants(Collection output) {
        DateTimePatternGenerator dateTimePatternGenerator = this;
        synchronized (dateTimePatternGenerator) {
            if (output == null) {
                output = new LinkedHashSet<String>();
            }
            Iterator it = this.skeleton2pattern.keySet().iterator();
            while (it.hasNext()) {
                DateTimeMatcher current = (DateTimeMatcher)it.next();
                String pattern = (String)this.skeleton2pattern.get(current);
                if (CANONICAL_SET.contains(pattern)) continue;
                this.skipMatcher = current;
                String trial = this.getBestPattern(current.toString());
                if (!trial.equals(pattern)) continue;
                output.add(pattern);
            }
            return output;
        }
    }

    public void setAppendItemFormats(int field, String value) {
        this.checkFrozen();
        this.appendItemFormats[field] = value;
    }

    public String getAppendItemFormats(int field) {
        return this.appendItemFormats[field];
    }

    public void setAppendItemNames(int field, String value) {
        this.checkFrozen();
        this.appendItemNames[field] = value;
    }

    public String getAppendItemNames(int field) {
        return this.appendItemNames[field];
    }

    public static boolean isSingleField(String skeleton) {
        char first = skeleton.charAt(0);
        for (int i = 1; i < skeleton.length(); ++i) {
            if (skeleton.charAt(i) == first) continue;
            return false;
        }
        return true;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public Object freeze() {
        this.frozen = true;
        return this;
    }

    public Object cloneAsThawed() {
        DateTimePatternGenerator result = (DateTimePatternGenerator)this.clone();
        this.frozen = false;
        return result;
    }

    public Object clone() {
        try {
            DateTimePatternGenerator result = (DateTimePatternGenerator)super.clone();
            result.skeleton2pattern = (TreeMap)this.skeleton2pattern.clone();
            result.basePattern_pattern = (TreeMap)this.basePattern_pattern.clone();
            result.appendItemFormats = (String[])this.appendItemFormats.clone();
            result.appendItemNames = (String[])this.appendItemNames.clone();
            result.current = new DateTimeMatcher();
            result.fp = new FormatParser();
            result._distanceInfo = new DistanceInfo();
            result.frozen = false;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Internal Error");
        }
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
    }

    private String getBestAppending(int missingFields) {
        String resultPattern = null;
        if (missingFields != 0) {
            resultPattern = this.getBestRaw(this.current, missingFields, this._distanceInfo);
            resultPattern = this.adjustFieldTypes(resultPattern, this.current, false);
            while (this._distanceInfo.missingFieldMask != 0) {
                if ((this._distanceInfo.missingFieldMask & 0x6000) == 16384 && (missingFields & 0x6000) == 24576) {
                    resultPattern = this.adjustFieldTypes(resultPattern, this.current, true);
                    this._distanceInfo.missingFieldMask &= 0xFFFFBFFF;
                    continue;
                }
                int startingMask = this._distanceInfo.missingFieldMask;
                String temp = this.getBestRaw(this.current, this._distanceInfo.missingFieldMask, this._distanceInfo);
                temp = this.adjustFieldTypes(temp, this.current, false);
                int foundMask = startingMask & ~this._distanceInfo.missingFieldMask;
                int topField = this.getTopBitNumber(foundMask);
                resultPattern = MessageFormat.format(this.getAppendFormat(topField), new Object[]{resultPattern, temp, this.getAppendName(topField)});
            }
        }
        return resultPattern;
    }

    private String getAppendName(int foundMask) {
        return "'" + this.appendItemNames[foundMask] + "'";
    }

    private String getAppendFormat(int foundMask) {
        return this.appendItemFormats[foundMask];
    }

    private String adjustSeconds(DateTimeMatcher current2) {
        return null;
    }

    private int getTopBitNumber(int foundMask) {
        int i = 0;
        while (foundMask != 0) {
            foundMask >>>= 1;
            ++i;
        }
        return i - 1;
    }

    private void complete() {
        PatternInfo patternInfo = new PatternInfo();
        for (int i = 0; i < CANONICAL_ITEMS.length; ++i) {
            char c = (char)types[i][0];
            this.add(String.valueOf(CANONICAL_ITEMS[i]), false, patternInfo);
        }
        this.isComplete = true;
    }

    private String getBestRaw(DateTimeMatcher source, int includeMask, DistanceInfo missingFields) {
        int bestDistance = Integer.MAX_VALUE;
        String bestPattern = "";
        DistanceInfo tempInfo = new DistanceInfo();
        Iterator it = this.skeleton2pattern.keySet().iterator();
        while (it.hasNext()) {
            int distance;
            DateTimeMatcher trial = (DateTimeMatcher)it.next();
            if (trial.equals(this.skipMatcher) || (distance = source.getDistance(trial, includeMask, tempInfo)) >= bestDistance) continue;
            bestDistance = distance;
            bestPattern = (String)this.skeleton2pattern.get(trial);
            missingFields.setTo(tempInfo);
            if (distance != 0) continue;
            break;
        }
        return bestPattern;
    }

    private String adjustFieldTypes(String pattern, DateTimeMatcher inputRequest, boolean fixFractionalSeconds) {
        this.fp.set(pattern);
        StringBuffer newPattern = new StringBuffer();
        Iterator it = this.fp.getItems().iterator();
        while (it.hasNext()) {
            String newField;
            Object item = it.next();
            if (item instanceof String) {
                newPattern.append(this.fp.quoteLiteral((String)item));
                continue;
            }
            String field = ((VariableField)item).string;
            int canonicalIndex = DateTimePatternGenerator.getCanonicalIndex(field);
            if (canonicalIndex < 0) continue;
            int type = types[canonicalIndex][1];
            if (fixFractionalSeconds && type == 13) {
                newField = inputRequest.original[14];
                field = field + this.decimal + newField;
            } else if (inputRequest.type[type] != 0) {
                newField = inputRequest.original[type];
                if (type != 11) {
                    field = newField;
                } else if (field.length() != newField.length()) {
                    char c = field.charAt(0);
                    field = "";
                    for (int i = newField.length(); i > 0; --i) {
                        field = field + c;
                    }
                }
            }
            newPattern.append(field);
        }
        return newPattern.toString();
    }

    public String getFields(String pattern) {
        this.fp.set(pattern);
        StringBuffer newPattern = new StringBuffer();
        Iterator it = this.fp.getItems().iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (item instanceof String) {
                newPattern.append(this.fp.quoteLiteral((String)item));
                continue;
            }
            newPattern.append("{" + DateTimePatternGenerator.getName(item.toString()) + "}");
        }
        return newPattern.toString();
    }

    private static String showMask(int mask) {
        String result = "";
        for (int i = 0; i < 16; ++i) {
            if ((mask & 1 << i) == 0) continue;
            if (result.length() != 0) {
                result = result + " | ";
            }
            result = result + FIELD_NAME[i] + " ";
        }
        return result;
    }

    private static String getName(String s) {
        boolean string;
        int i = DateTimePatternGenerator.getCanonicalIndex(s);
        String name = FIELD_NAME[types[i][1]];
        int subtype = types[i][2];
        boolean bl = string = subtype < 0;
        if (string) {
            subtype = -subtype;
        }
        name = subtype < 0 ? name + ":S" : name + ":N";
        return name;
    }

    private static int getCanonicalIndex(String s) {
        int len = s.length();
        char ch = s.charAt(0);
        for (int i = 0; i < types.length; ++i) {
            int[] row = types[i];
            if (row[0] != ch || row[3] > len || row[row.length - 1] < len) continue;
            return i;
        }
        return -1;
    }

    private static class DistanceInfo {
        int missingFieldMask;
        int extraFieldMask;

        private DistanceInfo() {
        }

        void clear() {
            this.extraFieldMask = 0;
            this.missingFieldMask = 0;
        }

        void setTo(DistanceInfo other) {
            this.missingFieldMask = other.missingFieldMask;
            this.extraFieldMask = other.extraFieldMask;
        }

        void addMissing(int field) {
            this.missingFieldMask |= 1 << field;
        }

        void addExtra(int field) {
            this.extraFieldMask |= 1 << field;
        }

        public String toString() {
            return "missingFieldMask: " + DateTimePatternGenerator.showMask(this.missingFieldMask) + ", extraFieldMask: " + DateTimePatternGenerator.showMask(this.extraFieldMask);
        }
    }

    private static class DateTimeMatcher
    implements Comparable {
        private int[] type = new int[16];
        private String[] original = new String[16];
        private String[] baseOriginal = new String[16];

        private DateTimeMatcher() {
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < 16; ++i) {
                if (this.original[i].length() == 0) continue;
                result.append(this.original[i]);
            }
            return result.toString();
        }

        String getBasePattern() {
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < 16; ++i) {
                if (this.baseOriginal[i].length() == 0) continue;
                result.append(this.baseOriginal[i]);
            }
            return result.toString();
        }

        DateTimeMatcher set(String pattern, FormatParser fp) {
            if (pattern.indexOf("\\u") >= 0) {
                String oldPattern = pattern;
                pattern = fromHex.transliterate(pattern);
            }
            for (int i = 0; i < 16; ++i) {
                this.type[i] = 0;
                this.original[i] = "";
                this.baseOriginal[i] = "";
            }
            fp.set(pattern);
            Iterator it = fp.getVariableFields(new ArrayList()).iterator();
            while (it.hasNext()) {
                String field = (String)it.next();
                if (field.charAt(0) == 'a') continue;
                int canonicalIndex = DateTimePatternGenerator.getCanonicalIndex(field);
                if (canonicalIndex < 0) {
                    throw new IllegalArgumentException("Illegal field:\t" + field + "\t in " + pattern);
                }
                int[] row = types[canonicalIndex];
                int typeValue = row[1];
                if (this.original[typeValue].length() != 0) {
                    throw new IllegalArgumentException("Conflicting fields:\t" + this.original[typeValue] + ", " + field + "\t in " + pattern);
                }
                this.original[typeValue] = field;
                char repeatChar = (char)row[0];
                int repeatCount = row[3];
                if (repeatCount > 3) {
                    repeatCount = 3;
                }
                if ("GEzvQ".indexOf(repeatChar) >= 0) {
                    repeatCount = 1;
                }
                this.baseOriginal[typeValue] = Utility.repeat(String.valueOf(repeatChar), repeatCount);
                int subTypeValue = row[2];
                if (subTypeValue > 0) {
                    subTypeValue += field.length();
                }
                this.type[typeValue] = (byte)subTypeValue;
            }
            return this;
        }

        int getFieldMask() {
            int result = 0;
            for (int i = 0; i < this.type.length; ++i) {
                if (this.type[i] == 0) continue;
                result |= 1 << i;
            }
            return result;
        }

        void extractFrom(DateTimeMatcher source, int fieldMask) {
            for (int i = 0; i < this.type.length; ++i) {
                if ((fieldMask & 1 << i) != 0) {
                    this.type[i] = source.type[i];
                    this.original[i] = source.original[i];
                    continue;
                }
                this.type[i] = 0;
                this.original[i] = "";
            }
        }

        int getDistance(DateTimeMatcher other, int includeMask, DistanceInfo distanceInfo) {
            int result = 0;
            distanceInfo.clear();
            for (int i = 0; i < this.type.length; ++i) {
                int otherType;
                int myType = (includeMask & 1 << i) == 0 ? 0 : this.type[i];
                if (myType == (otherType = other.type[i])) continue;
                if (myType == 0) {
                    result += 65536;
                    distanceInfo.addExtra(i);
                    continue;
                }
                if (otherType == 0) {
                    result += 4096;
                    distanceInfo.addMissing(i);
                    continue;
                }
                result += Math.abs(myType - otherType);
            }
            return result;
        }

        public int compareTo(Object o) {
            DateTimeMatcher that = (DateTimeMatcher)o;
            for (int i = 0; i < this.original.length; ++i) {
                int comp = this.original[i].compareTo(that.original[i]);
                if (comp == 0) continue;
                return -comp;
            }
            return 0;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            DateTimeMatcher that = (DateTimeMatcher)other;
            for (int i = 0; i < this.original.length; ++i) {
                if (this.original[i].equals(that.original[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = 0;
            for (int i = 0; i < this.original.length; ++i) {
                result ^= this.original[i].hashCode();
            }
            return result;
        }
    }

    public static class FormatParser {
        private transient PatternTokenizer tokenizer = new PatternTokenizer().setSyntaxCharacters(new UnicodeSet("[a-zA-Z]")).setUsingQuote(true);
        private List items = new ArrayList();
        private static UnicodeSet alpha = new UnicodeSet("[:alphabetic:]");

        public FormatParser set(String string) {
            this.items.clear();
            if (string.length() == 0) {
                return this;
            }
            this.tokenizer.setPattern(string);
            StringBuffer buffer = new StringBuffer();
            StringBuffer variable = new StringBuffer();
            while (true) {
                buffer.setLength(0);
                int status = this.tokenizer.next(buffer);
                if (status == 0) break;
                if (status == 1) {
                    if (variable.length() != 0 && buffer.charAt(0) != variable.charAt(0)) {
                        this.addVariable(variable);
                    }
                    variable.append(buffer);
                    continue;
                }
                this.addVariable(variable);
                this.items.add(buffer.toString());
            }
            this.addVariable(variable);
            return this;
        }

        private void addVariable(StringBuffer variable) {
            if (variable.length() != 0) {
                this.items.add(new VariableField(variable.toString()));
                variable.setLength(0);
            }
        }

        private List getVariableFields(List output) {
            if (output == null) {
                output = new ArrayList<String>();
            }
            Iterator it = this.items.iterator();
            block3: while (it.hasNext()) {
                Object item = it.next();
                if (!(item instanceof VariableField)) continue;
                String s = item.toString();
                switch (s.charAt(0)) {
                    case 'a': {
                        continue block3;
                    }
                }
                output.add(s);
            }
            return output;
        }

        public String getVariableFieldString() {
            List list = this.getVariableFields(null);
            StringBuffer result = new StringBuffer();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                String item = (String)it.next();
                result.append(item);
            }
            return result.toString();
        }

        public List getItems() {
            return this.items;
        }

        public String toString() {
            return this.toString(0, this.items.size());
        }

        public String toString(int start, int limit) {
            StringBuffer result = new StringBuffer();
            for (int i = start; i < limit; ++i) {
                result.append(this.items.get(i).toString());
            }
            return result.toString();
        }

        public boolean hasDateAndTimeFields() {
            int foundMask = 0;
            Iterator it = this.items.iterator();
            while (it.hasNext()) {
                Object item = it.next();
                if (!(item instanceof VariableField)) continue;
                int type = this.getType(item);
                foundMask |= 1 << type;
            }
            boolean isDate = (foundMask & 0x3FF) != 0;
            boolean isTime = (foundMask & 0xFC00) != 0;
            return isDate && isTime;
        }

        public List getAutoPatterns(String value, List result) {
            Object nextItem;
            Object previousItem;
            int i;
            int type;
            Object item;
            if (result == null) {
                result = new ArrayList<String>();
            }
            int fieldCount = 0;
            int minField = Integer.MAX_VALUE;
            int maxField = Integer.MIN_VALUE;
            Iterator it = this.items.iterator();
            while (it.hasNext()) {
                item = it.next();
                if (!(item instanceof VariableField)) continue;
                try {
                    type = this.getType(item);
                    if (minField > type) {
                        minField = type;
                    }
                    if (maxField < type) {
                        maxField = type;
                    }
                    if (type == 15 || type == 10 || type == 6) {
                        return result;
                    }
                    ++fieldCount;
                }
                catch (Exception e) {
                    return result;
                }
            }
            if (fieldCount < 3) {
                return result;
            }
            for (i = 0; i < this.items.size(); ++i) {
                item = this.items.get(i);
                if (!(item instanceof VariableField)) continue;
                type = this.getType(item);
                if (type != minField && type != maxField || i > 0 && alpha.containsSome((previousItem = this.items.get(0)).toString())) break;
                int start = i + 1;
                if (start < this.items.size() && (nextItem = this.items.get(start)) instanceof String) {
                    if (alpha.containsSome(nextItem.toString())) break;
                    ++start;
                }
                result.add(this.toString(start, this.items.size()));
                break;
            }
            for (i = this.items.size() - 1; i >= 0; --i) {
                item = this.items.get(i);
                if (!(item instanceof VariableField)) continue;
                type = this.getType(item);
                if (type != minField && type != maxField || i < this.items.size() - 1 && alpha.containsSome((previousItem = this.items.get(this.items.size() - 1)).toString())) break;
                int end = i - 1;
                if (end > 0 && (nextItem = this.items.get(end)) instanceof String) {
                    if (alpha.containsSome(nextItem.toString())) break;
                    --end;
                }
                result.add(this.toString(0, end + 1));
                break;
            }
            return result;
        }

        private int getType(Object item) {
            String s = item.toString();
            int canonicalIndex = DateTimePatternGenerator.getCanonicalIndex(s);
            if (canonicalIndex < 0) {
                throw new IllegalArgumentException("Illegal field:\t" + s);
            }
            int type = types[canonicalIndex][1];
            return type;
        }

        public Object quoteLiteral(String string) {
            return this.tokenizer.quoteLiteral(string);
        }
    }

    public static class VariableField {
        private String string;

        public VariableField(String string) {
            this.string = string;
        }

        public String toString() {
            return this.string;
        }
    }

    public static final class PatternInfo {
        public static final int OK = 0;
        public static final int BASE_CONFLICT = 1;
        public static final int CONFLICT = 2;
        public int status;
        public String conflictingPattern;
    }
}

