/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.encoding;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import junit.framework.TestCase;
import org.alfresco.repo.content.encoding.ContentCharsetFinder;
import org.alfresco.util.DataModelTestApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class CharsetFinderTest
extends TestCase {
    private static ApplicationContext ctx = DataModelTestApplicationContextHelper.getApplicationContext();
    private ContentCharsetFinder charsetFinder;

    public void setUp() throws Exception {
        this.charsetFinder = (ContentCharsetFinder)ctx.getBean("charset.finder");
    }

    public void testPlainText() throws Exception {
        String test = "The quick brown fox jumps over the lazy dog\n\nLe renard brun rapide saute par-dessus le chien paresseux\n\nDer schnelle braune Fuchs springt \u00fcber den faulen Hund\n\n\u0628\u0631\u0627\u0648\u0646 \u0648\u0643\u0633 \u0627\u0644\u0633\u0631\u064a\u0639 \u064a\u0642\u0641\u0632 \u0641\u0648\u0642 \u0627\u0644\u0643\u0644\u0628 \u0643\u0633\u0627\u0644\u064a";
        BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(test.getBytes("UTF-8")));
        Charset charset = this.charsetFinder.getCharset(is, "text/plain");
        CharsetFinderTest.assertNotNull((Object)charset);
    }
}

