/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.Locale;
import org.alfresco.repo.dictionary.M2DataType;
import org.alfresco.repo.dictionary.M2Label;
import org.alfresco.repo.dictionary.ModelQuery;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.I18NUtil;

class M2DataTypeDefinition
implements DataTypeDefinition {
    private ModelDefinition model;
    private QName name;
    private M2DataType dataType;

    M2DataTypeDefinition(ModelDefinition model, M2DataType propertyType, NamespacePrefixResolver resolver) {
        this.model = model;
        this.name = QName.createQName(propertyType.getName(), resolver);
        if (!model.isNamespaceDefined(this.name.getNamespaceURI())) {
            throw new DictionaryException("Cannot define data type " + this.name.toPrefixString() + " as namespace " + this.name.getNamespaceURI() + " is not defined by model " + model.getName().toPrefixString());
        }
        this.dataType = propertyType;
    }

    void resolveDependencies(ModelQuery query) {
        String javaClass = this.dataType.getJavaClassName();
        if (javaClass == null) {
            throw new DictionaryException("Java class of data type " + this.name.toPrefixString() + " must be specified");
        }
        try {
            Class.forName(javaClass);
        }
        catch (ClassNotFoundException e) {
            throw new DictionaryException("Java class " + javaClass + " of data type " + this.name.toPrefixString() + " is invalid", e);
        }
    }

    public String toString() {
        return this.getName().toString();
    }

    public ModelDefinition getModel() {
        return this.model;
    }

    public QName getName() {
        return this.name;
    }

    public String getTitle() {
        String value = M2Label.getLabel(this.model, "datatype", this.name, "title");
        if (value == null) {
            value = this.dataType.getTitle();
        }
        return value;
    }

    public String getDescription() {
        String value = M2Label.getLabel(this.model, "datatype", this.name, "description");
        if (value == null) {
            value = this.dataType.getDescription();
        }
        return value;
    }

    public String getAnalyserClassName() {
        return this.getAnalyserClassName(I18NUtil.getLocale());
    }

    public String getAnalyserClassName(Locale locale) {
        String value = M2Label.getLabel(locale, this.model, "datatype", this.name, "analyzer");
        if (value == null) {
            value = this.dataType.getAnalyserClassName();
        }
        return value;
    }

    public String getJavaClassName() {
        return this.dataType.getJavaClassName();
    }
}

