/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.query;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;

public class CaseInsensitiveTermRangeEnum
extends FilteredTermEnum {
    private boolean endEnum = false;
    String expandedFieldName;
    String lowerTermText;
    String upperTermText;
    boolean includeLower;
    boolean includeUpper;

    public CaseInsensitiveTermRangeEnum(IndexReader reader, String expandedFieldName, String lowerTermText, String upperTermText, boolean includeLower, boolean includeUpper) throws IOException {
        this.expandedFieldName = expandedFieldName;
        this.lowerTermText = lowerTermText.toLowerCase();
        this.upperTermText = upperTermText.toLowerCase();
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
        this.setEnum(reader.terms(new Term(expandedFieldName, "")));
    }

    public float difference() {
        return 1.0f;
    }

    protected boolean endEnum() {
        return this.endEnum;
    }

    protected boolean termCompare(Term term) {
        if (this.expandedFieldName.equals(term.field())) {
            String searchText = term.text().toLowerCase();
            return this.checkLower(searchText) && this.checkUpper(searchText);
        }
        this.endEnum = true;
        return false;
    }

    private boolean checkLower(String searchText) {
        if (this.includeLower) {
            return this.lowerTermText.compareTo(searchText) <= 0;
        }
        return this.lowerTermText.compareTo(searchText) < 0;
    }

    private boolean checkUpper(String searchText) {
        if (this.includeUpper) {
            return this.upperTermText.compareTo(searchText) >= 0;
        }
        return this.upperTermText.compareTo(searchText) > 0;
    }
}

