/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.query;

import java.io.IOException;
import org.alfresco.repo.search.impl.lucene.query.AbstractStructuredFieldPosition;

public class RelativeStructuredFieldPosition
extends AbstractStructuredFieldPosition {
    int relativePosition = 1;

    public RelativeStructuredFieldPosition(String termText) {
        super(termText.equals("*") ? null : termText, true, false);
    }

    public RelativeStructuredFieldPosition() {
        super(null, false, false);
    }

    public int matches(int start, int end, int offset) throws IOException {
        if (this.getCachingTermPositions() != null) {
            this.getCachingTermPositions().reset();
            int count = this.getCachingTermPositions().freq();
            int requiredPosition = offset + this.relativePosition;
            int realPosition = 0;
            int adjustedPosition = 0;
            for (int i = 0; i < count; ++i) {
                realPosition = this.getCachingTermPositions().nextPosition();
                adjustedPosition = realPosition - start;
                if (end != -1 && realPosition > end) {
                    return -1;
                }
                if (adjustedPosition == requiredPosition) {
                    return adjustedPosition;
                }
                if (adjustedPosition <= requiredPosition) continue;
                return -1;
            }
        } else {
            return offset + 1;
        }
        return -1;
    }

    public String getDescription() {
        return "Relative Named child";
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.relativePosition;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelativeStructuredFieldPosition other = (RelativeStructuredFieldPosition)obj;
        return this.relativePosition == other.relativePosition;
    }
}

