/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.service.cmr.repository.PeriodProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Period
implements Serializable {
    private static final long serialVersionUID = -7978001474638355909L;
    private static transient ConcurrentHashMap<String, PeriodProvider> providers = new ConcurrentHashMap();
    private String periodType;
    private String expression;

    public static void registerProvider(PeriodProvider periodProvider) {
        providers.put(periodProvider.getPeriodType(), periodProvider);
    }

    public static PeriodProvider getProvider(String periodType) {
        PeriodProvider provider = providers.get(periodType);
        if (provider == null) {
            throw new IllegalStateException("No period provider for period type " + periodType);
        }
        return provider;
    }

    public static Set<String> getProviderNames() {
        return providers.keySet();
    }

    public Period(String period) {
        String[] parts = period.split("\\|", 2);
        this.periodType = parts[0];
        if (parts.length == 2) {
            this.expression = parts[1];
        }
    }

    public String getPeriodType() {
        return this.periodType;
    }

    public String getExpression() {
        return this.expression;
    }

    public Date getNextDate(Date date) {
        if (this.periodType == null || this.periodType.length() == 0) {
            return null;
        }
        PeriodProvider provider = Period.getProvider(this.periodType);
        return provider.getNextDate(date, this.expression != null ? this.expression : provider.getDefaultExpression());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.periodType == null ? 0 : this.periodType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Period other = (Period)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        return !(this.periodType == null ? other.periodType != null : !this.periodType.equals(other.periodType));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.periodType);
        if (this.expression != null) {
            builder.append("|");
            builder.append(this.expression);
        }
        return builder.toString();
    }
}

