/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class TransformXSLT
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/TR/1999/REC-xslt-19991116";
    static final String XSLTSpecNS = "http://www.w3.org/1999/XSL/Transform";
    static final String defaultXSLTSpecNSprefix = "xslt";
    static final String XSLTSTYLESHEET = "stylesheet";

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput, Transform transform) throws IOException, TransformationException {
        return this.enginePerformTransform(xMLSignatureInput, null, transform);
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput, OutputStream outputStream, Transform transform) throws IOException, TransformationException {
        try {
            Element element = transform.getElement();
            Element element2 = XMLUtils.selectNode(element.getFirstChild(), XSLTSpecNS, XSLTSTYLESHEET, 0);
            if (element2 == null) {
                Object[] objectArray = new Object[]{"xslt:stylesheet", "Transform"};
                throw new TransformationException("xml.WrongContent", objectArray);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            StreamSource streamSource = new StreamSource(new ByteArrayInputStream(xMLSignatureInput.getBytes()));
            Object object = new ByteArrayOutputStream();
            Object object2 = transformerFactory.newTransformer();
            Object object3 = new DOMSource(element2);
            StreamResult streamResult = new StreamResult((OutputStream)object);
            ((Transformer)object2).transform((Source)object3, streamResult);
            StreamSource streamSource2 = new StreamSource(new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray()));
            object = transformerFactory.newTransformer(streamSource2);
            if (outputStream == null) {
                object2 = new ByteArrayOutputStream();
                object3 = new StreamResult((OutputStream)object2);
                ((Transformer)object).transform(streamSource, (Result)object3);
                return new XMLSignatureInput(((ByteArrayOutputStream)object2).toByteArray());
            }
            object2 = new StreamResult(outputStream);
            ((Transformer)object).transform(streamSource, (Result)object2);
            object3 = new XMLSignatureInput((byte[])null);
            ((XMLSignatureInput)object3).setOutputStream(outputStream);
            return object3;
        }
        catch (XMLSecurityException xMLSecurityException) {
            Object[] objectArray = new Object[]{xMLSecurityException.getMessage()};
            throw new TransformationException("generic.EmptyMessage", objectArray, xMLSecurityException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            Object[] objectArray = new Object[]{transformerConfigurationException.getMessage()};
            throw new TransformationException("generic.EmptyMessage", objectArray, transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            Object[] objectArray = new Object[]{transformerException.getMessage()};
            throw new TransformationException("generic.EmptyMessage", objectArray, transformerException);
        }
    }
}

