/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.ftp;

import java.net.InetAddress;
import org.alfresco.jlan.ftp.FTPAuthenticator;
import org.alfresco.jlan.ftp.FTPSiteInterface;
import org.alfresco.jlan.ftp.LocalAuthenticator;
import org.alfresco.jlan.server.config.ConfigSection;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.element.GenericConfigElement;

public class FTPConfigSection
extends ConfigSection {
    public static final String SectionName = "FTP";
    private InetAddress m_ftpBindAddress;
    private int m_ftpPort = -1;
    private boolean m_ftpAllowAnonymous;
    private String m_ftpAnonymousAccount;
    private String m_ftpRootPath;
    private int m_ftpDataPortLow;
    private int m_ftpDataPortHigh;
    private FTPAuthenticator m_ftpAuthenticator = new LocalAuthenticator();
    private boolean m_localFtpAuthenticator = true;
    private int m_ftpDebug;
    private FTPSiteInterface m_ftpSiteInterface;
    private String m_ftpCharSet;
    private boolean m_ipv6;
    private String m_keyStorePath;
    private String m_trustStorePath;
    private char[] m_passphrase;
    private boolean m_requireSecureSess;

    public FTPConfigSection(ServerConfiguration config) {
        super(SectionName, config);
        try {
            this.m_ftpAuthenticator.initialize(config, (ConfigElement)new GenericConfigElement("ftpAuthenticator"));
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            // empty catch block
        }
    }

    public final InetAddress getFTPBindAddress() {
        return this.m_ftpBindAddress;
    }

    public final int getFTPPort() {
        return this.m_ftpPort;
    }

    public final FTPAuthenticator getFTPAuthenticator() {
        return this.m_ftpAuthenticator;
    }

    public final boolean allowAnonymousFTP() {
        return this.m_ftpAllowAnonymous;
    }

    public final String getAnonymousFTPAccount() {
        return this.m_ftpAnonymousAccount;
    }

    public final int getFTPDebug() {
        return this.m_ftpDebug;
    }

    public final boolean hasFTPRootPath() {
        return this.m_ftpRootPath != null;
    }

    public final String getFTPRootPath() {
        return this.m_ftpRootPath;
    }

    public final boolean hasFTPDataPortRange() {
        return this.m_ftpDataPortLow > 0 && this.m_ftpDataPortHigh > 0;
    }

    public final int getFTPDataPortLow() {
        return this.m_ftpDataPortLow;
    }

    public final int getFTPDataPortHigh() {
        return this.m_ftpDataPortHigh;
    }

    public final boolean hasFTPSiteInterface() {
        return this.m_ftpSiteInterface != null;
    }

    public final FTPSiteInterface getFTPSiteInterface() {
        return this.m_ftpSiteInterface;
    }

    public final String getFTPCharacterSet() {
        return this.m_ftpCharSet;
    }

    public final boolean isIPv6Enabled() {
        return this.m_ipv6;
    }

    public final boolean isFTPSEnabled() {
        return this.getKeyStorePath() != null && this.getTrustStorePath() != null && this.getPassphrase() != null;
    }

    public final String getKeyStorePath() {
        return this.m_keyStorePath;
    }

    public final String getTrustStorePath() {
        return this.m_trustStorePath;
    }

    public final char[] getPassphrase() {
        return this.m_passphrase;
    }

    public final boolean requireSecureSession() {
        return this.m_requireSecureSess;
    }

    public final void setFTPCharacterSet(String charSet) {
        this.m_ftpCharSet = charSet;
    }

    public final int setFTPBindAddress(InetAddress addr) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(196609, addr);
        this.m_ftpBindAddress = addr;
        return sts;
    }

    public final int setFTPPort(int port) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(196610, new Integer(port));
        this.m_ftpPort = port;
        return sts;
    }

    public final int setFTPDataPortLow(int port) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(196616, new Integer(port));
        this.m_ftpDataPortLow = port;
        return sts;
    }

    public final int setFTPDataPortHigh(int port) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(196617, new Integer(port));
        this.m_ftpDataPortHigh = port;
        return sts;
    }

    public final int setFTPRootPath(String path) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(196615, path);
        this.m_ftpRootPath = path;
        return sts;
    }

    public final int setAllowAnonymousFTP(boolean ena) throws InvalidConfigurationException {
        int sts = 0;
        if (this.m_ftpAllowAnonymous != ena) {
            sts = this.fireConfigurationChange(196611, new Boolean(ena));
            this.m_ftpAllowAnonymous = ena;
        }
        return sts;
    }

    public final int setAnonymousFTPAccount(String acc) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(196612, acc);
        this.m_ftpAnonymousAccount = acc;
        return sts;
    }

    public final int setFTPDebug(int dbg) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(196613, new Integer(dbg));
        this.m_ftpDebug = dbg;
        return sts;
    }

    public final int setFTPSiteInterface(FTPSiteInterface siteInterface) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(196618, siteInterface);
        this.m_ftpSiteInterface = siteInterface;
        return sts;
    }

    public final int setAuthenticator(String authClass, ConfigElement params) throws InvalidConfigurationException {
        int sts = 0;
        FTPAuthenticator auth = null;
        try {
            Object authObj = Class.forName(authClass).newInstance();
            if (!(authObj instanceof FTPAuthenticator)) {
                throw new InvalidConfigurationException("Authenticator is not derived from required base class");
            }
            auth = (FTPAuthenticator)authObj;
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidConfigurationException("Authenticator class " + authClass + " not found");
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("Authenticator class error");
        }
        auth.initialize(this.getServerConfiguration(), params);
        sts = this.setAuthenticator(auth);
        this.m_localFtpAuthenticator = true;
        return sts;
    }

    public final int setAuthenticator(FTPAuthenticator auth) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(196619, auth);
        this.m_ftpAuthenticator = auth;
        this.m_localFtpAuthenticator = false;
        return sts;
    }

    public final int setIPv6Enabled(boolean ipv6ena) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(196620, new Boolean(ipv6ena));
        this.m_ipv6 = ipv6ena;
        return sts;
    }

    public final int setKeyStorePath(String path) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(196621, path);
        this.m_keyStorePath = path;
        return sts;
    }

    public final int setTrustStorePath(String path) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(196622, path);
        this.m_trustStorePath = path;
        return sts;
    }

    public final int setPassphrase(String passphrase) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(196623, passphrase);
        this.m_passphrase = passphrase.toCharArray();
        return sts;
    }

    public final int setRequireSecureSession(boolean reqSecureSess) throws InvalidConfigurationException {
        int sts = this.fireConfigurationChange(196624, new Boolean(reqSecureSess));
        this.m_requireSecureSess = reqSecureSess;
        return sts;
    }

    public final void closeConfig() {
        if (this.m_localFtpAuthenticator && this.m_ftpAuthenticator != null) {
            this.m_ftpAuthenticator.closeAuthenticator();
        }
        this.m_ftpAuthenticator = null;
    }
}

