/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.locking;

import java.util.Vector;
import org.alfresco.jlan.locking.FileLock;

public class FileLockList {
    private Vector<FileLock> m_lockList = new Vector();

    public final void addLock(FileLock lock) {
        this.m_lockList.add(lock);
    }

    public final FileLock removeLock(FileLock lock) {
        return this.removeLock(lock.getOffset(), lock.getLength(), lock.getProcessId());
    }

    public final FileLock removeLock(long offset, long len, int pid) {
        if (this.numberOfLocks() == 0) {
            return null;
        }
        for (int i = 0; i < this.numberOfLocks(); ++i) {
            FileLock curLock = this.getLockAt(i);
            if (curLock.getOffset() != offset || curLock.getLength() != len || curLock.getProcessId() != pid) continue;
            this.m_lockList.removeElementAt(i);
            return curLock;
        }
        return null;
    }

    public final void removeAllLocks() {
        this.m_lockList.removeAllElements();
    }

    public final FileLock getLockAt(int idx) {
        if (idx < this.m_lockList.size()) {
            return this.m_lockList.get(idx);
        }
        return null;
    }

    public final boolean allowsLock(FileLock lock) {
        if (this.numberOfLocks() == 0) {
            return true;
        }
        for (int i = 0; i < this.numberOfLocks(); ++i) {
            FileLock curLock = this.getLockAt(i);
            if (!curLock.hasOverlap(lock)) continue;
            return false;
        }
        return true;
    }

    public final boolean canReadFile(long offset, long len, int pid) {
        if (this.numberOfLocks() == 0) {
            return true;
        }
        for (int i = 0; i < this.numberOfLocks(); ++i) {
            FileLock curLock = this.getLockAt(i);
            if (curLock.getProcessId() == pid || !curLock.hasOverlap(offset, len)) continue;
            return false;
        }
        return true;
    }

    public final boolean canWriteFile(long offset, long len, int pid) {
        if (this.numberOfLocks() == 0) {
            return true;
        }
        for (int i = 0; i < this.numberOfLocks(); ++i) {
            FileLock curLock = this.getLockAt(i);
            if (curLock.getProcessId() == pid || !curLock.hasOverlap(offset, len)) continue;
            return false;
        }
        return true;
    }

    public final int numberOfLocks() {
        return this.m_lockList.size();
    }
}

