/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.oncrpc;

import java.io.IOException;
import java.net.Socket;
import org.alfresco.jlan.oncrpc.MultiThreadedTcpRpcSessionHandler;
import org.alfresco.jlan.oncrpc.RpcPacket;
import org.alfresco.jlan.oncrpc.RpcPacketHandler;
import org.alfresco.jlan.oncrpc.RpcProcessor;
import org.alfresco.jlan.oncrpc.TcpRpcPacketHandler;
import org.alfresco.jlan.oncrpc.TcpRpcSessionHandler;

public class MultiThreadedTcpRpcPacketHandler
extends TcpRpcPacketHandler
implements RpcPacketHandler {
    public MultiThreadedTcpRpcPacketHandler(TcpRpcSessionHandler handler, int sessId, RpcProcessor server, Socket socket, int maxRpcSize) throws IOException {
        super(handler, sessId, server, socket, maxRpcSize);
    }

    protected final MultiThreadedTcpRpcSessionHandler getSessionHandler() {
        return (MultiThreadedTcpRpcSessionHandler)this.getHandler();
    }

    protected RpcPacket allocateRpcPacket(int maxSize) {
        return this.getSessionHandler().allocateRpcPacket(maxSize);
    }

    protected void deallocateRpcPacket(RpcPacket pkt) {
        if (pkt.isAllocatedFromPool()) {
            pkt.getOwnerPacketPool().releasePacket(pkt);
        }
    }

    protected void processRpc(RpcPacket rpc) throws IOException {
        rpc.setPacketHandler(this);
        this.getSessionHandler().queueRpcRequest(rpc);
    }

    public void sendRpcResponse(RpcPacket rpc) throws IOException {
        this.sendRpc(rpc);
    }
}

