/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.oncrpc;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.oncrpc.RpcPacket;
import org.alfresco.jlan.oncrpc.RpcPacketHandler;
import org.alfresco.jlan.oncrpc.RpcPacketPool;
import org.alfresco.jlan.oncrpc.RpcProcessor;
import org.alfresco.jlan.oncrpc.RpcRequestQueue;
import org.alfresco.jlan.oncrpc.RpcRequestThreadPool;
import org.alfresco.jlan.oncrpc.UdpRpcDatagramHandler;
import org.alfresco.jlan.server.NetworkServer;

public class MultiThreadedUdpRpcDatagramHandler
extends UdpRpcDatagramHandler
implements RpcPacketHandler {
    public static final int DefaultPacketPoolSize = 50;
    public static final int DefaultSmallPacketSize = 512;
    private RpcPacketPool m_packetPool;
    private RpcRequestThreadPool m_threadPool;
    private RpcRequestQueue m_txQueue;
    private DatagramSender m_txThread;
    private RpcPacket m_rxPkt;

    public MultiThreadedUdpRpcDatagramHandler(String name, String protocol, RpcProcessor rpcServer, NetworkServer server, InetAddress addr, int port, int maxSize) {
        super(name, protocol, rpcServer, server, addr, port, maxSize);
    }

    public void initializeSessionHandler(NetworkServer server) throws IOException {
        this.m_txQueue = new RpcRequestQueue();
        this.m_txThread = new DatagramSender("UDP_Tx_" + this.getProtocolName());
        if (this.m_packetPool == null) {
            this.m_packetPool = new RpcPacketPool(512, 50, this.getMaximumDatagramSize(), 50);
        }
        if (this.m_threadPool == null) {
            this.m_threadPool = new RpcRequestThreadPool(this.getHandlerName(), this.getRpcProcessor());
        }
        super.initializeSessionHandler(server);
    }

    protected boolean processDatagram(DatagramPacket pkt) throws IOException {
        if (pkt.getData() != this.m_rxPkt.getBuffer()) {
            throw new IOException("Received datagram is not in expected buffer");
        }
        this.m_rxPkt.setBuffer(pkt.getData(), 0, pkt.getLength());
        this.m_rxPkt.setClientDetails(pkt.getAddress(), pkt.getPort(), 17);
        this.m_rxPkt.setPacketHandler(this);
        this.queueRpcRequest(this.m_rxPkt);
        return false;
    }

    protected final void queueRpcRequest(RpcPacket rpc) {
        this.m_threadPool.queueRpcRequest(rpc);
    }

    protected byte[] allocateBuffer(int bufSize) {
        this.m_rxPkt = this.m_packetPool.allocatePacket(bufSize);
        return this.m_rxPkt.getBuffer();
    }

    public void sendRpcResponse(RpcPacket rpc) throws IOException {
        this.m_txQueue.addRequest(rpc);
    }

    public final void setPacketPool(int smallSize, int smallPool, int largeSize, int largePool) {
        if (this.m_packetPool == null) {
            this.m_packetPool = new RpcPacketPool(smallSize, smallPool, largeSize, largePool);
        }
    }

    public final void setPacketPool(int poolSize) {
        if (this.m_packetPool == null) {
            this.m_packetPool = new RpcPacketPool(512, poolSize, this.getMaximumDatagramSize(), poolSize);
        }
    }

    public final void setPacketPool(RpcPacketPool pktPool) {
        if (this.m_packetPool == null) {
            this.m_packetPool = pktPool;
        }
    }

    public final void setThreadPool(int numThreads) {
        if (this.m_threadPool == null) {
            this.m_threadPool = new RpcRequestThreadPool(this.getHandlerName(), numThreads, this.getRpcProcessor());
        }
    }

    public final void setThreadPool(RpcRequestThreadPool threadPool) {
        if (this.m_threadPool == null) {
            this.m_threadPool = threadPool;
        }
    }

    public void closeSessionHandler(NetworkServer server) {
        this.m_txThread.shutdownRequest();
        super.closeSessionHandler(server);
    }

    protected class DatagramSender
    implements Runnable {
        private Thread mi_thread = new Thread(this);
        private DatagramPacket mi_txPkt;
        private boolean mi_shutdown = false;

        public DatagramSender(String name) {
            this.mi_thread.setName(name);
            this.mi_thread.setDaemon(true);
            this.mi_thread.start();
        }

        public final void shutdownRequest() {
            this.mi_shutdown = true;
            try {
                this.mi_thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.mi_txPkt = new DatagramPacket(new byte[4], 4);
            RpcPacket rpc = null;
            while (!this.mi_shutdown) {
                Object var4_5;
                try {
                    rpc = MultiThreadedUdpRpcDatagramHandler.this.m_txQueue.removeRequest();
                }
                catch (InterruptedException ex) {
                    if (this.mi_shutdown) break;
                }
                if (rpc == null) continue;
                try {
                    try {
                        this.mi_txPkt.setAddress(rpc.getClientAddress());
                        this.mi_txPkt.setPort(rpc.getClientPort());
                        this.mi_txPkt.setData(rpc.getBuffer(), rpc.getOffset(), rpc.getLength());
                        MultiThreadedUdpRpcDatagramHandler.this.getDatagramSocket().send(this.mi_txPkt);
                    }
                    catch (Throwable ex) {
                        if (!this.mi_shutdown) {
                            Debug.println("DatagramSender " + Thread.currentThread().getName() + ":");
                            Debug.println(ex);
                        }
                        var4_5 = null;
                        if (!rpc.isAllocatedFromPool()) continue;
                        rpc.getOwnerPacketPool().releasePacket(rpc);
                        continue;
                    }
                    var4_5 = null;
                    if (!rpc.isAllocatedFromPool()) continue;
                    rpc.getOwnerPacketPool().releasePacket(rpc);
                }
                catch (Throwable throwable) {
                    var4_5 = null;
                    if (rpc.isAllocatedFromPool()) {
                        rpc.getOwnerPacketPool().releasePacket(rpc);
                    }
                    throw throwable;
                }
            }
        }
    }
}

