/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.sample;

import java.util.Enumeration;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.auth.InvalidUserException;
import org.alfresco.jlan.server.auth.UserAccount;
import org.alfresco.jlan.server.config.ConfigurationListener;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.SecurityConfigSection;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.core.ShareMapper;
import org.alfresco.jlan.server.core.ShareType;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.server.core.SharedDeviceList;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.FilesystemsConfigSection;
import org.alfresco.jlan.smb.server.disk.JavaFileDiskDriver;
import org.springframework.extensions.config.ConfigElement;

public class HomeShareMapper
implements ShareMapper,
ConfigurationListener {
    public static final String HOME_DIRECTORY_SHARE = "HOME";
    private ServerConfiguration m_config;
    private SecurityConfigSection m_securityConfig;
    private FilesystemsConfigSection m_filesysConfig;
    private boolean m_debug;

    public void initializeMapper(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        this.m_config = config;
        this.m_securityConfig = (SecurityConfigSection)this.m_config.getConfigSection("Security");
        this.m_filesysConfig = (FilesystemsConfigSection)this.m_config.getConfigSection("Filesystems");
        if (this.m_filesysConfig == null) {
            this.m_config.addListener(this);
        }
        if (params.getChild("debug") != null) {
            this.m_debug = true;
        }
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SharedDevice findShare(String host, String name, int typ, SrvSession sess, boolean create) throws InvalidUserException {
        SharedDevice share = null;
        if ((typ == 0 || typ == -1) && name.compareTo(HOME_DIRECTORY_SHARE) == 0 && sess.getClientInformation() != null) {
            UserAccount acc;
            ClientInfo client = sess.getClientInformation();
            if (this.hasDebug()) {
                Debug.println("Map share " + name + ", type=" + ShareType.TypeAsString(typ) + ", client=" + client);
            }
            if ((acc = this.m_securityConfig.getUserAccounts().findUser(client.getUserName())) == null) throw new InvalidUserException("No home directory");
            if (!acc.hasHomeDirectory()) throw new InvalidUserException("No home directory");
            if (sess.hasDynamicShares()) {
                share = sess.getDynamicShareList().findShare(name, typ, false);
                if (this.hasDebug() && share != null) {
                    Debug.println("  Reusing existing dynamic share for " + name);
                }
            }
            if (share == null && create) {
                JavaFileDiskDriver diskDrv = new JavaFileDiskDriver();
                DiskDeviceContext diskCtx = new DiskDeviceContext(acc.getHomeDirectory());
                DiskSharedDevice diskShare = new DiskSharedDevice(HOME_DIRECTORY_SHARE, diskDrv, diskCtx, 8);
                sess.addDynamicShare(diskShare);
                share = diskShare;
                if (this.hasDebug()) {
                    Debug.println("  Mapped share " + name + " to " + acc.getHomeDirectory());
                }
            }
        } else {
            share = this.m_filesysConfig.getShares().findShare(name, typ, false);
            if (share == null) {
                share = this.m_filesysConfig.getShares().findShare(name, typ, true);
            }
        }
        if (share == null) return share;
        if (share.getContext() == null) return share;
        if (share.getContext().isAvailable()) return share;
        return null;
    }

    public void deleteShares(SrvSession sess) {
        if (!sess.hasDynamicShares()) {
            return;
        }
        SharedDeviceList shares = sess.getDynamicShareList();
        Enumeration<SharedDevice> enm = shares.enumerateShares();
        while (enm.hasMoreElements()) {
            SharedDevice shr = enm.nextElement();
            shr.getContext().CloseContext();
            if (!this.hasDebug()) continue;
            Debug.println("Deleted dynamic share " + shr);
        }
    }

    public SharedDeviceList getShareList(String host, SrvSession sess, boolean allShares) {
        if (this.m_filesysConfig == null) {
            return null;
        }
        SharedDeviceList shrList = new SharedDeviceList(this.m_filesysConfig.getShares());
        if (sess != null && sess.hasDynamicShares()) {
            shrList.addShares(sess.getDynamicShareList());
        }
        if (!allShares) {
            shrList.removeUnavailableShares();
        }
        return shrList;
    }

    public void closeMapper() {
    }

    public int configurationChanged(int id, ServerConfiguration config, Object newVal) throws InvalidConfigurationException {
        if (id == 0x10000001) {
            if (newVal instanceof FilesystemsConfigSection) {
                this.m_filesysConfig = (FilesystemsConfigSection)newVal;
            }
            return 1;
        }
        return 0;
    }
}

