/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.asn;

import java.io.IOException;
import org.alfresco.jlan.server.auth.asn.DERBuffer;
import org.alfresco.jlan.server.auth.asn.DERObject;

public class DERGeneralString
extends DERObject {
    private String m_string;

    public DERGeneralString() {
    }

    public DERGeneralString(String str) {
        this.m_string = str;
    }

    public final String getValue() {
        return this.m_string;
    }

    public void derDecode(DERBuffer buf) throws IOException {
        if (buf.unpackType() == 27) {
            int len = buf.unpackLength();
            if (len > 0) {
                byte[] byts = buf.unpackBytes(len);
                this.m_string = new String(byts);
            } else {
                this.m_string = null;
            }
        } else {
            throw new IOException("Wrong DER type, expected GeneralString");
        }
    }

    public void derEncode(DERBuffer buf) throws IOException {
        buf.packByte(27);
        if (this.m_string != null) {
            byte[] byts = this.m_string.getBytes();
            buf.packLength(byts.length);
            buf.packBytes(byts, 0, byts.length);
        } else {
            buf.packLength(0);
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[GeneralString:");
        str.append(this.m_string);
        str.append("]");
        return str.toString();
    }
}

