/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.asn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.alfresco.jlan.server.auth.asn.DER;
import org.alfresco.jlan.server.auth.asn.DERBuffer;
import org.alfresco.jlan.server.auth.asn.DERObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DERSequence
extends DERObject {
    private List<DERObject> m_list;

    public DERSequence() {
        this.m_list = new ArrayList<DERObject>();
    }

    public DERSequence(int tagNo) {
        this.setTagNo(tagNo);
        this.m_list = new ArrayList<DERObject>();
    }

    public final int numberOfObjects() {
        return this.m_list.size();
    }

    public final DERObject getObjectAt(int idx) {
        DERObject derObj = null;
        if (idx >= 0 && idx < this.m_list.size()) {
            derObj = this.m_list.get(idx);
        }
        return derObj;
    }

    public final DERObject getTaggedObject(int tagNo) {
        if (this.m_list == null || this.m_list.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.m_list.size(); ++i) {
            DERObject derObj = this.m_list.get(i);
            if (derObj.getTagNo() != tagNo) continue;
            return derObj;
        }
        return null;
    }

    public final void addObject(DERObject derObj) {
        this.m_list.add(derObj);
    }

    @Override
    public void derDecode(DERBuffer buf) throws IOException {
        int typ = buf.unpackType();
        if (DER.isType(typ) != 16) {
            throw new IOException("Wrong DER type, expected Sequence");
        }
        int len = buf.unpackLength();
        int pos = buf.getPosition();
        this.m_list.clear();
        this.setTagNo(-1);
        if (len > 0) {
            while (buf.getPosition() - pos < len) {
                DERObject obj = buf.unpackObject();
                this.addObject(obj);
            }
        }
    }

    @Override
    public void derEncode(DERBuffer buf) throws IOException {
        int totLen = 0;
        DERBuffer objBuf = new DERBuffer();
        if (this.numberOfObjects() > 0) {
            for (int i = 0; i < this.numberOfObjects(); ++i) {
                DERObject derObj = this.getObjectAt(i);
                objBuf.packObject(derObj);
            }
            totLen = objBuf.getLength();
        }
        buf.packByte(48);
        buf.packLength(totLen);
        if (totLen > 0) {
            buf.packBytes(objBuf);
        }
    }

    public final Iterator<DERObject> getObjects() {
        return this.m_list.iterator();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[Sequence:");
        str.append(this.numberOfObjects());
        str.append("]");
        return str.toString();
    }
}

