/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.ntlm;

import org.alfresco.jlan.server.auth.ntlm.NTLMMessage;
import org.alfresco.jlan.util.HexDump;

public class Type3NTLMMessage
extends NTLMMessage {
    public static final int MinimalMessageLength = 52;
    public static final int OffsetLMResponse = 12;
    public static final int OffsetNTLMResponse = 20;
    public static final int OffsetDomain = 28;
    public static final int OffsetUserName = 36;
    public static final int OffsetWorkstationName = 44;
    public static final int OffsetDataMinimum = 52;
    public static final int OffsetSessionKey = 52;
    public static final int OffsetFlags = 60;
    public static final int OffsetData = 64;
    private boolean m_unicode;
    private int m_dataOffset = -1;

    public Type3NTLMMessage() {
    }

    public Type3NTLMMessage(byte[] buf) {
        super(buf, 0, buf.length);
    }

    public Type3NTLMMessage(byte[] buf, int offset, int len, boolean unicode) {
        super(buf, offset, len);
        this.m_unicode = unicode;
    }

    public int getFlags() {
        return this.getIntValue(60);
    }

    public final int getLMHashLength() {
        return this.getShortValue(12);
    }

    public final byte[] getLMHash() {
        return this.getByteValue(12);
    }

    public final int getNTLMHashLength() {
        return this.getShortValue(20);
    }

    public final byte[] getNTLMHash() {
        return this.getByteValue(20);
    }

    public final String getDomain() {
        return this.getStringValue(28, this.hasFlag(1));
    }

    public final String getUserName() {
        return this.getStringValue(36, this.hasFlag(1));
    }

    public final String getWorkstation() {
        return this.getStringValue(44, this.hasFlag(1));
    }

    public final boolean hasSessionKey() {
        return this.getShortValue(52) > 0;
    }

    public final byte[] getSessionKey() {
        if (!this.hasSessionKey()) {
            return null;
        }
        return this.getByteValue(52);
    }

    public final void buildType3(byte[] lmHash, byte[] ntlmHash, String domain, String username, String wksname, byte[] sessKey, int flags) {
        this.initializeHeader(3, 0);
        int dataOff = 64;
        dataOff = this.setStringValue(28, domain, dataOff, this.m_unicode);
        dataOff = this.setStringValue(36, username, dataOff, this.m_unicode);
        dataOff = this.setStringValue(44, wksname, dataOff, this.m_unicode);
        dataOff = this.setByteValue(12, lmHash, dataOff);
        dataOff = this.setByteValue(20, ntlmHash, dataOff);
        dataOff = this.setByteValue(52, sessKey, dataOff);
        int typ3flags = 516;
        if (this.m_unicode) {
            ++flags;
        }
        this.setIntValue(60, typ3flags);
        this.setLength(dataOff);
    }

    protected void setFlags(int flags) {
        this.setIntValue(60, flags);
    }

    private final int findDataBlockOffset() {
        int offset = this.getByteOffset(12);
        if (this.m_dataOffset == -1 || offset < this.m_dataOffset) {
            this.m_dataOffset = offset;
        }
        if ((offset = this.getByteOffset(20)) < this.m_dataOffset) {
            this.m_dataOffset = offset;
        }
        if ((offset = this.getStringOffset(28)) < this.m_dataOffset) {
            this.m_dataOffset = offset;
        }
        if ((offset = this.getStringOffset(36)) < this.m_dataOffset) {
            this.m_dataOffset = offset;
        }
        if ((offset = this.getStringOffset(44)) < this.m_dataOffset) {
            this.m_dataOffset = offset;
        }
        return this.m_dataOffset;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[Type3:");
        str.append(",LM:");
        if (this.getLMHash() != null) {
            str.append(HexDump.hexString(this.getLMHash()));
        } else {
            str.append("<Null>");
        }
        str.append(",NTLM:");
        if (this.getNTLMHash() != null) {
            str.append(HexDump.hexString(this.getNTLMHash()));
        } else {
            str.append("<Null>");
        }
        str.append(",Dom:");
        str.append(this.getDomain());
        str.append(",User:");
        str.append(this.getUserName());
        str.append(",Wks:");
        str.append(this.getWorkstation());
        if (this.hasSessionKey()) {
            str.append(",SessKey:");
            str.append(HexDump.hexString(this.getSessionKey()));
            str.append(",Flags:0x");
            str.append(Integer.toHexString(this.getFlags()));
        }
        str.append("]");
        return str.toString();
    }
}

