/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.config;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import org.alfresco.jlan.server.NetworkServer;
import org.alfresco.jlan.server.NetworkServerList;
import org.alfresco.jlan.server.config.ConfigSection;
import org.alfresco.jlan.server.config.ConfigurationListener;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfigurationAccessor;
import org.alfresco.jlan.util.Platform;

public class ServerConfiguration
implements ServerConfigurationAccessor {
    private String m_serverName;
    private NetworkServerList m_serverList;
    private HashMap<String, ConfigSection> m_configSections = new HashMap();
    private Vector<ConfigurationListener> m_listeners;
    private boolean m_updated;

    public ServerConfiguration(String name) {
        this.m_serverList = new NetworkServerList();
        this.m_serverName = name;
    }

    public final void addConfigSection(ConfigSection config) {
        this.m_configSections.put(config.getSectionName(), config);
        try {
            this.fireConfigurationChange(0x10000001, config);
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            // empty catch block
        }
    }

    public final boolean hasConfigSection(String name) {
        return this.m_configSections.containsKey(name);
    }

    public final ConfigSection getConfigSection(String name) {
        return this.m_configSections.get(name);
    }

    public final ConfigSection removeConfigSection(String name) {
        return this.m_configSections.remove(name);
    }

    public final void removeAllConfigSections() {
        this.m_configSections.clear();
    }

    public final String getServerName() {
        return this.m_serverName;
    }

    public final void addServer(NetworkServer srv) {
        this.m_serverList.addServer(srv);
    }

    public final NetworkServer findServer(String proto) {
        return this.m_serverList.findServer(proto);
    }

    public final NetworkServer removeServer(String proto) {
        return this.m_serverList.removeServer(proto);
    }

    public final int numberOfServers() {
        return this.m_serverList.numberOfServers();
    }

    public final boolean isServerRunning(String proto) {
        NetworkServer srv = this.findServer(proto);
        if (srv != null) {
            return srv.isActive();
        }
        return false;
    }

    public final Platform.Type getPlatformType() {
        return Platform.isPlatformType();
    }

    public final String getPlatformTypeString() {
        return Platform.isPlatformType().toString();
    }

    public final NetworkServer getServer(int idx) {
        return this.m_serverList.getServer(idx);
    }

    public final boolean isUpdated() {
        return this.m_updated;
    }

    protected final void setUpdated(boolean upd) {
        this.m_updated = upd;
    }

    public final void setServerName(String name) {
        this.m_serverName = name;
    }

    public final void addListener(ConfigurationListener listener) {
        if (this.m_listeners == null) {
            this.m_listeners = new Vector();
        }
        this.m_listeners.addElement(listener);
    }

    public final void removeListener(ConfigurationListener listener) {
        if (this.m_listeners == null) {
            return;
        }
        this.m_listeners.removeElement(listener);
    }

    public final boolean hasConfigurationListeners() {
        if (this.m_listeners == null) {
            return false;
        }
        return this.m_listeners.size() > 0;
    }

    protected final int fireConfigurationChange(int id, Object newVal) throws InvalidConfigurationException {
        this.setUpdated(true);
        if (!this.hasConfigurationListeners()) {
            return 0;
        }
        int sts = 0;
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            ConfigurationListener cl = this.m_listeners.elementAt(i);
            int clSts = cl.configurationChanged(id, this, newVal);
            if (clSts <= sts) continue;
            sts = clSts;
        }
        return sts;
    }

    public void loadConfiguration(String location) throws IOException, InvalidConfigurationException {
        throw new IOException("Not implemented");
    }

    public void saveConfiguration(String location) throws IOException {
        throw new IOException("Not implemented");
    }

    public void closeConfiguration() {
        if (this.m_configSections != null) {
            Set<String> keys = this.m_configSections.keySet();
            for (String configName : keys) {
                ConfigSection configSection = this.m_configSections.get(configName);
                try {
                    configSection.closeConfig();
                }
                catch (Exception ex) {}
            }
            this.m_configSections.clear();
        }
    }
}

