/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.alfresco.jlan.locking.FileLock;
import org.alfresco.jlan.locking.LockConflictException;
import org.alfresco.jlan.locking.NotLockedException;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.filesys.ExistingOpLockException;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.FileStateCache;
import org.alfresco.jlan.server.filesys.cache.NetworkFileStateInterface;
import org.alfresco.jlan.server.locking.LockManager;
import org.alfresco.jlan.server.locking.OpLockDetails;
import org.alfresco.jlan.server.locking.OpLockManager;
import org.alfresco.jlan.server.thread.ThreadRequestPool;
import org.alfresco.jlan.server.thread.TimedThreadRequest;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;

public class FileStateLockManager
implements LockManager,
OpLockManager,
Runnable {
    private static final long OpLockBreakTimeout = 5000L;
    private FileStateCache m_stateCache;
    private Hashtable<String, OpLockDetails> m_oplockQueue;
    private Thread m_expiryThread;
    private boolean m_shutdown;
    private ThreadRequestPool m_threadPool;
    private OplockExpiryTimedRequest m_threadReq;

    public FileStateLockManager(FileStateCache stateCache) {
        this.m_stateCache = stateCache;
        this.m_oplockQueue = new Hashtable();
    }

    public void lockFile(SrvSession sess, TreeConnection tree, NetworkFile file, FileLock lock) throws LockConflictException, IOException {
        if (!(file instanceof NetworkFileStateInterface)) {
            throw new IllegalArgumentException("NetworkFile does not implement NetworkFileStateInterface, path=" + file.getFullName());
        }
        NetworkFileStateInterface fstateIface = (NetworkFileStateInterface)((Object)file);
        FileState fstate = fstateIface.getFileState();
        if (fstate == null) {
            throw new IOException("Open file without state (lock)");
        }
        fstate.addLock(lock);
        file.addLock(lock);
    }

    public void unlockFile(SrvSession sess, TreeConnection tree, NetworkFile file, FileLock lock) throws NotLockedException, IOException {
        if (!(file instanceof NetworkFileStateInterface)) {
            throw new IllegalArgumentException("NetworkFile does not implement NetworkFileStateInterface");
        }
        NetworkFileStateInterface fstateIface = (NetworkFileStateInterface)((Object)file);
        FileState fstate = fstateIface.getFileState();
        if (fstate == null) {
            throw new IOException("Open file without state (unlock)");
        }
        fstate.removeLock(lock);
        file.removeLock(lock);
    }

    public FileLock createLockObject(SrvSession sess, TreeConnection tree, NetworkFile file, long offset, long len, int pid) {
        return new FileLock(offset, len, pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseLocksForFile(SrvSession sess, TreeConnection tree, NetworkFile file) {
        if (!file.hasLocks()) return;
        NetworkFile networkFile = file;
        synchronized (networkFile) {
            while (file.numberOfLocks() > 0) {
                FileLock curLock = file.getLockAt(0);
                try {
                    this.unlockFile(sess, tree, file, curLock);
                }
                catch (Exception ex) {}
            }
            return;
        }
    }

    public int hasOpLock(String path) {
        OpLockDetails oplock;
        FileState fstate = this.m_stateCache.findFileState(path);
        if (fstate != null && fstate.hasOpLock() && (oplock = fstate.getOpLock()) != null) {
            return oplock.getLockType();
        }
        return 0;
    }

    public OpLockDetails getOpLockDetails(String path) {
        FileState fstate = this.m_stateCache.findFileState(path);
        if (fstate != null) {
            return fstate.getOpLock();
        }
        return null;
    }

    public boolean grantOpLock(String path, OpLockDetails oplock) throws ExistingOpLockException {
        FileState fstate = this.m_stateCache.findFileState(path, true);
        if (fstate.getOpenCount() != 1) {
            return false;
        }
        fstate.setOpLock(oplock);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informOpLockBreakInProgress(String path, OpLockDetails oplock) {
        Hashtable<String, OpLockDetails> hashtable = this.m_oplockQueue;
        synchronized (hashtable) {
            this.m_oplockQueue.put(path, oplock);
            if (this.m_threadPool == null) {
                this.m_oplockQueue.notify();
            } else {
                this.m_threadReq.restartRequest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseOpLock(String path) {
        FileState fstate = this.m_stateCache.findFileState(path);
        if (fstate != null) {
            fstate.clearOpLock();
        }
        Hashtable<String, OpLockDetails> hashtable = this.m_oplockQueue;
        synchronized (hashtable) {
            this.m_oplockQueue.remove(path);
        }
    }

    public int checkExpiredOplockBreaks() {
        if (this.m_oplockQueue.size() == 0) {
            return 0;
        }
        int expireCnt = 0;
        long timeNow = System.currentTimeMillis();
        Enumeration<String> opBreakKeys = this.m_oplockQueue.keys();
        while (opBreakKeys.hasMoreElements()) {
            String path = opBreakKeys.nextElement();
            OpLockDetails opLock = this.m_oplockQueue.get(path);
            if (opLock == null || !opLock.hasDeferredSession() || opLock.getOplockBreakTime() + 5000L > timeNow) continue;
            SMBSrvSession sess = opLock.getDeferredSession();
            SMBSrvPacket pkt = opLock.getDeferredPacket();
            try {
                if (sess.sendAsyncErrorResponseSMB(pkt, -1073741790, 6)) {
                    if (sess.hasDebug(0x8000000)) {
                        sess.debugPrintln("Oplock break timeout, oplock=" + opLock);
                    }
                    sess.getPacketPool().releasePacket(pkt);
                } else if (sess.hasDebug(0x8000000)) {
                    sess.debugPrintln("Failed to send open reject, oplock break timed out, oplock=" + opLock);
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.m_oplockQueue.remove(path);
            opLock.clearDeferredSession();
            opLock.setOplockBreakFailed();
            ++expireCnt;
        }
        return expireCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.m_shutdown = false;
        while (!this.m_shutdown) {
            try {
                Hashtable<String, OpLockDetails> hashtable = this.m_oplockQueue;
                synchronized (hashtable) {
                    if (this.m_oplockQueue.size() == 0) {
                        this.m_oplockQueue.wait();
                    }
                }
                if (this.m_oplockQueue.size() > 0) {
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.m_shutdown) {
                return;
            }
            this.checkExpiredOplockBreaks();
        }
    }

    public final void shutdownRequest() {
        this.m_shutdown = true;
        if (this.m_expiryThread != null) {
            try {
                this.m_expiryThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void startLockManager(String threadName, ThreadRequestPool threadPool) {
        this.m_threadPool = threadPool;
        if (this.m_threadPool == null) {
            this.m_expiryThread = new Thread(this);
            this.m_expiryThread.setDaemon(true);
            this.m_expiryThread.setName(threadName);
            this.m_expiryThread.start();
        } else {
            this.m_threadReq = new OplockExpiryTimedRequest(threadName, 5L);
            this.m_threadPool.queueTimedRequest(this.m_threadReq);
        }
    }

    private class OplockExpiryTimedRequest
    extends TimedThreadRequest {
        public OplockExpiryTimedRequest(String name, long interval) {
            super(name, 0L, interval);
        }

        protected void runTimedRequest() {
            FileStateLockManager.this.checkExpiredOplockBreaks();
            if (FileStateLockManager.this.m_shutdown) {
                this.setRepeatInterval(0L);
            } else if (FileStateLockManager.this.m_oplockQueue.size() == 0) {
                this.setRunAtTime(0L);
            }
        }
    }
}

