/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.locking;

import org.alfresco.jlan.smb.OpLock;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;

public class OpLockDetails {
    private SMBSrvSession m_ownerSess;
    private int m_pid;
    private int m_uid;
    private int m_treeId;
    private int m_fileId;
    private int m_type;
    private String m_path;
    private boolean m_folder;
    private SMBSrvSession m_deferredSess;
    private SMBSrvPacket m_deferredPkt;
    private long m_opBreakTime;
    private boolean m_failedBreak;

    public OpLockDetails(int lockTyp, String path, SMBSrvSession sess, int pid, int uid, int treeId, int fileId, boolean folder) {
        this.m_type = lockTyp;
        this.m_path = path;
        this.m_ownerSess = sess;
        this.m_pid = pid;
        this.m_uid = uid;
        this.m_treeId = treeId;
        this.m_fileId = fileId;
        this.m_folder = folder;
    }

    public OpLockDetails(int lockTyp, String path, SMBSrvSession sess, SMBSrvPacket pkt, boolean folder) {
        this.m_type = lockTyp;
        this.m_path = path;
        this.m_ownerSess = sess;
        this.m_pid = pkt.getProcessId();
        this.m_uid = pkt.getUserId();
        this.m_treeId = pkt.getTreeId();
        this.m_fileId = -1;
        this.m_folder = folder;
    }

    public final int getLockType() {
        return this.m_type;
    }

    public final String getPath() {
        return this.m_path;
    }

    public final boolean isFolder() {
        return this.m_folder;
    }

    public final SMBSrvSession getOwnerSession() {
        return this.m_ownerSess;
    }

    public final int getOwnerPID() {
        return this.m_pid;
    }

    public final int getOwnerUID() {
        return this.m_uid;
    }

    public final int getOwnerTreeId() {
        return this.m_treeId;
    }

    public final int getOwnerFileId() {
        return this.m_fileId;
    }

    public final boolean hasDeferredSession() {
        return this.m_deferredSess != null;
    }

    public final SMBSrvSession getDeferredSession() {
        return this.m_deferredSess;
    }

    public final SMBSrvPacket getDeferredPacket() {
        return this.m_deferredPkt;
    }

    public final long getOplockBreakTime() {
        return this.m_opBreakTime;
    }

    public final boolean hasOplockBreakFailed() {
        return this.m_failedBreak;
    }

    public final void setOwnerFileId(int fileId) {
        this.m_fileId = fileId;
    }

    public final void setDeferredSession(SMBSrvSession deferredSess, SMBSrvPacket deferredPkt) {
        this.m_deferredSess = deferredSess;
        this.m_deferredPkt = deferredPkt;
        this.m_opBreakTime = System.currentTimeMillis();
        deferredPkt.incrementDeferredCount();
    }

    public final void clearDeferredSession() {
        this.m_deferredSess = null;
        this.m_deferredPkt = null;
    }

    public final void setOplockBreakFailed() {
        this.m_failedBreak = true;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Type=");
        str.append(OpLock.getTypeAsString(this.getLockType()));
        str.append(",");
        str.append(this.getPath());
        str.append(",Owner=");
        str.append(this.getOwnerSession().getUniqueId());
        str.append(",PID=");
        str.append(this.getOwnerPID());
        str.append(",UID=");
        str.append(this.getOwnerUID());
        str.append(",TreeID=");
        str.append(this.getOwnerTreeId());
        str.append(",FileId=");
        str.append(this.getOwnerFileId());
        if (this.hasDeferredSession()) {
            str.append(",Deferred=");
            str.append(this.getDeferredSession());
        }
        if (this.hasOplockBreakFailed()) {
            str.append("BreakFailed");
        }
        str.append("]");
        return str.toString();
    }
}

