/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.thread;

import java.util.Vector;
import java.util.concurrent.PriorityBlockingQueue;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.thread.ThreadRequest;
import org.alfresco.jlan.server.thread.ThreadRequestQueue;
import org.alfresco.jlan.server.thread.TimedThreadRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadRequestPool {
    public static final int DefaultWorkerThreads = 25;
    public static final int MinimumWorkerThreads = 4;
    public static final int MaximumWorkerThreads = 250;
    public static final int TimedQueueInitialSize = 20;
    private static long WaitForRequestSleep = 86400000L;
    private ThreadRequestQueue m_queue = new ThreadRequestQueue();
    private PriorityBlockingQueue<TimedThreadRequest> m_timedQueue = new PriorityBlockingQueue(20);
    private TimedRequestProcessor m_timedProcessor;
    private ThreadWorker[] m_workers;
    protected boolean m_debug;
    protected boolean m_timedDebug;

    public ThreadRequestPool(String threadName) {
        this(threadName, 25);
    }

    public ThreadRequestPool(String threadName, int poolSize) {
        if (poolSize < 4) {
            poolSize = 4;
        }
        this.m_workers = new ThreadWorker[poolSize];
        for (int i = 0; i < this.m_workers.length; ++i) {
            this.m_workers[i] = new ThreadWorker(threadName + (i + 1));
        }
        this.m_timedProcessor = new TimedRequestProcessor();
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final boolean hasTimedDebug() {
        return this.m_timedDebug;
    }

    public final int getNumberOfRequests() {
        return this.m_queue.numberOfRequests();
    }

    public final void queueRequest(ThreadRequest req) {
        this.m_queue.addRequest(req);
    }

    public final void queueRequests(Vector<ThreadRequest> reqList) {
        this.m_queue.addRequests(reqList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void queueTimedRequest(TimedThreadRequest timedReq) {
        if (timedReq.hasThreadRequestPool()) {
            boolean wasRemoved = timedReq.getThreadRequestPool().removeTimedRequest(timedReq);
            if (this.hasTimedDebug()) {
                Debug.println("Removed timed request " + timedReq + ", removed=" + wasRemoved);
            }
        }
        PriorityBlockingQueue<TimedThreadRequest> priorityBlockingQueue = this.m_timedQueue;
        synchronized (priorityBlockingQueue) {
            TimedThreadRequest queueHead = this.m_timedQueue.peek();
            this.m_timedQueue.add(timedReq);
            timedReq.setThreadRequestPool(this);
            if (this.hasTimedDebug()) {
                Debug.println("Queued timed request " + timedReq);
            }
            if (queueHead == null || timedReq.getRunAtTime() < queueHead.getRunAtTime()) {
                if (this.hasTimedDebug()) {
                    Debug.println("New head of timed request queue, waking processor thread ...");
                }
                this.m_timedProcessor.wakeupProcessor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeTimedRequest(TimedThreadRequest timedReq) {
        boolean wasRemoved = false;
        PriorityBlockingQueue<TimedThreadRequest> priorityBlockingQueue = this.m_timedQueue;
        synchronized (priorityBlockingQueue) {
            wasRemoved = this.m_timedQueue.remove(timedReq);
            timedReq.setThreadRequestPool(null);
        }
        return wasRemoved;
    }

    public void shutdownThreadPool() {
        if (this.m_workers != null) {
            for (int i = 0; i < this.m_workers.length; ++i) {
                this.m_workers[i].shutdownRequest();
            }
        }
    }

    public final void setDebug(boolean ena) {
        this.m_debug = ena;
    }

    public final void setTimedDebug(boolean ena) {
        this.m_timedDebug = ena;
    }

    protected class TimedRequestProcessor
    implements Runnable {
        private Thread mi_thread = new Thread(this);
        private boolean mi_shutdown = false;

        public TimedRequestProcessor() {
            this.mi_thread.setName("TimedRequestProcessor");
            this.mi_thread.setDaemon(true);
            this.mi_thread.start();
        }

        public final void shutdownRequest() {
            this.mi_shutdown = true;
            try {
                this.mi_thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void run() {
            while (!this.mi_shutdown) {
                try {
                    if (ThreadRequestPool.this.m_timedQueue.size() == 0) {
                        if (ThreadRequestPool.this.hasTimedDebug()) {
                            Debug.println("Waiting for timed request ...");
                        }
                        Thread.sleep(WaitForRequestSleep);
                        continue;
                    }
                    TimedThreadRequest queueHead = (TimedThreadRequest)ThreadRequestPool.this.m_timedQueue.peek();
                    if (queueHead == null) continue;
                    if (!queueHead.isPaused()) {
                        long sleepTime = queueHead.getRunAtTime() - System.currentTimeMillis();
                        if (sleepTime > 0L) {
                            if (ThreadRequestPool.this.hasTimedDebug()) {
                                Debug.println("Next timed request due in " + sleepTime + "ms ...");
                            }
                            Thread.sleep(sleepTime);
                        }
                        if ((queueHead = (TimedThreadRequest)ThreadRequestPool.this.m_timedQueue.poll()) == null) continue;
                        if (ThreadRequestPool.this.hasTimedDebug()) {
                            Debug.println("Passing timed request to thread pool - " + queueHead + ", queue size = " + ThreadRequestPool.this.m_timedQueue.size());
                        }
                        ThreadRequestPool.this.queueRequest(queueHead);
                        continue;
                    }
                    if (ThreadRequestPool.this.hasTimedDebug()) {
                        Debug.println("Waiting for timed request, none active (" + ThreadRequestPool.this.m_timedQueue.size() + ") ...");
                    }
                    Thread.sleep(WaitForRequestSleep);
                }
                catch (InterruptedException ex) {
                    if (!this.mi_shutdown) continue;
                    break;
                }
                catch (Throwable ex2) {
                    ex2.printStackTrace();
                }
            }
        }

        public final void wakeupProcessor() {
            this.mi_thread.interrupt();
        }
    }

    protected class ThreadWorker
    implements Runnable {
        private Thread mi_thread = new Thread(this);
        private boolean mi_shutdown = false;

        public ThreadWorker(String name) {
            this.mi_thread.setName(name);
            this.mi_thread.setDaemon(true);
            this.mi_thread.start();
        }

        public final void shutdownRequest() {
            this.mi_shutdown = true;
            try {
                this.mi_thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void run() {
            ThreadRequest threadReq = null;
            while (!this.mi_shutdown) {
                try {
                    threadReq = ThreadRequestPool.this.m_queue.removeRequest();
                }
                catch (InterruptedException ex) {
                    if (this.mi_shutdown) {
                        break;
                    }
                }
                catch (Throwable ex2) {
                    ex2.printStackTrace();
                }
                if (threadReq == null) continue;
                if (ThreadRequestPool.this.hasDebug()) {
                    Debug.println("Worker " + Thread.currentThread().getName() + ": Req=" + threadReq);
                }
                try {
                    threadReq.runRequest();
                }
                catch (Throwable ex) {
                    if (this.mi_shutdown) continue;
                    Debug.println("Worker " + Thread.currentThread().getName() + ":");
                    Debug.println(ex);
                }
            }
        }
    }
}

