/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.dcerpc.server;

import java.io.IOException;
import org.alfresco.jlan.smb.dcerpc.DCEBuffer;
import org.alfresco.jlan.smb.dcerpc.DCEBufferException;
import org.alfresco.jlan.smb.dcerpc.Wkssvc;
import org.alfresco.jlan.smb.dcerpc.info.WorkstationInfo;
import org.alfresco.jlan.smb.dcerpc.server.DCEHandler;
import org.alfresco.jlan.smb.dcerpc.server.DCEPipeFile;
import org.alfresco.jlan.smb.server.CIFSConfigSection;
import org.alfresco.jlan.smb.server.SMBServer;
import org.alfresco.jlan.smb.server.SMBSrvException;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;

public class WkssvcDCEHandler
implements DCEHandler {
    public void processRequest(SMBSrvSession sess, DCEBuffer inBuf, DCEPipeFile pipeFile, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        int opNum = inBuf.getHeaderValue(9);
        try {
            inBuf.skipBytes(24);
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        if (sess.hasDebug(131072)) {
            sess.debugPrintln("DCE/RPC WksSvc request=" + Wkssvc.getOpcodeName(opNum));
        }
        DCEBuffer outBuf = new DCEBuffer();
        outBuf.putResponseHeader(inBuf.getHeaderValue(7), 0);
        boolean processed = false;
        switch (opNum) {
            case 0: {
                processed = this.netWkstaGetInfo(sess, inBuf, outBuf);
                break;
            }
        }
        if (!processed) {
            sess.sendErrorResponseSMB(smbPkt, 65535, 2);
            return;
        }
        outBuf.setHeaderValue(8, outBuf.getLength());
        pipeFile.setBufferedData(outBuf);
    }

    protected final boolean netWkstaGetInfo(SMBSrvSession sess, DCEBuffer inBuf, DCEBuffer outBuf) {
        String srvName = null;
        int infoLevel = 0;
        try {
            inBuf.skipPointer();
            srvName = inBuf.getString(1);
            infoLevel = inBuf.getInt();
        }
        catch (DCEBufferException ex) {
            return false;
        }
        if (sess.hasDebug(131072)) {
            sess.debugPrintln("NetWkstaGetInfo srvName=" + srvName + ", infoLevel=" + infoLevel);
        }
        WorkstationInfo wkstaInfo = new WorkstationInfo(infoLevel);
        SMBServer srv = sess.getSMBServer();
        wkstaInfo.setWorkstationName(srv.getServerName());
        wkstaInfo.setDomain(srv.getCIFSConfiguration().getDomainName());
        CIFSConfigSection cifsConfig = sess.getSMBServer().getCIFSConfiguration();
        if (cifsConfig != null && cifsConfig.getEnabledDialects().hasDialect(7)) {
            wkstaInfo.setPlatformId(500);
            wkstaInfo.setVersion(5, 1);
        } else {
            wkstaInfo.setPlatformId(400);
            wkstaInfo.setVersion(4, 0);
        }
        wkstaInfo.writeObject(outBuf, outBuf);
        outBuf.putInt(0);
        return true;
    }
}

