/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server;

import org.alfresco.jlan.server.thread.ThreadRequest;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;

public class CIFSThreadRequest
implements ThreadRequest {
    private SMBSrvSession m_sess;
    private SMBSrvPacket m_smbPkt;

    public CIFSThreadRequest(SMBSrvSession sess, SMBSrvPacket smbPkt) {
        this.m_sess = sess;
        this.m_smbPkt = smbPkt;
    }

    public void runRequest() {
        if (!this.m_sess.isShutdown()) {
            this.m_sess.processPacket(this.m_smbPkt);
        } else {
            this.m_sess.getPacketPool().releasePacket(this.m_smbPkt);
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[CIFS Sess=");
        str.append(this.m_sess.getUniqueId());
        str.append(", pkt=");
        str.append(this.m_smbPkt.toString());
        str.append("]");
        return str.toString();
    }
}

