/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server;

import java.io.IOException;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.DiskSizeInterface;
import org.alfresco.jlan.server.filesys.DiskVolumeInterface;
import org.alfresco.jlan.server.filesys.SrvDiskInfo;
import org.alfresco.jlan.server.filesys.TooManyConnectionsException;
import org.alfresco.jlan.server.filesys.VolumeInfo;
import org.alfresco.jlan.smb.server.SMBSrvException;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;

abstract class ProtocolHandler {
    protected SMBSrvSession m_sess;

    protected ProtocolHandler() {
    }

    protected ProtocolHandler(SMBSrvSession sess) {
        this.m_sess = sess;
    }

    public abstract String getName();

    public abstract boolean runProtocol(SMBSrvPacket var1) throws IOException, SMBSrvException, TooManyConnectionsException;

    protected final SMBSrvSession getSession() {
        return this.m_sess;
    }

    protected final void setSession(SMBSrvSession sess) {
        this.m_sess = sess;
    }

    protected final boolean hasChainedCommand(SMBSrvPacket pkt) {
        int cmd = pkt.getCommand();
        if (cmd == 115 || cmd == 117 || cmd == 45 || cmd == 47 || cmd == 46 || cmd == 116 || cmd == 36 || cmd == 162) {
            return pkt.hasAndXCommand();
        }
        return false;
    }

    protected final SrvDiskInfo getDiskInformation(DiskInterface disk, DiskDeviceContext ctx) throws IOException {
        SrvDiskInfo diskInfo = ctx.getDiskInformation();
        if (diskInfo == null) {
            diskInfo = new SrvDiskInfo();
        }
        if (disk instanceof DiskSizeInterface) {
            DiskSizeInterface sizeInterface = (DiskSizeInterface)((Object)disk);
            sizeInterface.getDiskInformation(ctx, diskInfo);
        }
        return diskInfo;
    }

    protected final VolumeInfo getVolumeInformation(DiskInterface disk, DiskDeviceContext ctx) {
        VolumeInfo volInfo = ctx.getVolumeInformation();
        if (disk instanceof DiskVolumeInterface) {
            DiskVolumeInterface volInterface = (DiskVolumeInterface)((Object)disk);
            volInfo = volInterface.getVolumeInformation(ctx);
        }
        if (volInfo == null) {
            volInfo = new VolumeInfo("");
        }
        return volInfo;
    }
}

