/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server.win32;

import java.io.IOException;
import java.util.ArrayList;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.netbios.NetBIOSName;
import org.alfresco.jlan.netbios.win32.NetBIOS;
import org.alfresco.jlan.netbios.win32.NetBIOSSocket;
import org.alfresco.jlan.netbios.win32.Win32NetBIOS;
import org.alfresco.jlan.netbios.win32.WinsockNetBIOSException;
import org.alfresco.jlan.server.NetworkServer;
import org.alfresco.jlan.server.SessionHandlerBase;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.smb.mailslot.win32.Win32NetBIOSHostAnnouncer;
import org.alfresco.jlan.smb.server.CIFSConfigSection;
import org.alfresco.jlan.smb.server.SMBServer;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.jlan.smb.server.win32.LanaListener;
import org.alfresco.jlan.smb.server.win32.Win32NetBIOSLanaMonitor;
import org.alfresco.jlan.smb.server.win32.Win32NetBIOSPacketHandler;
import org.alfresco.jlan.smb.server.win32.WinsockNetBIOSPacketHandler;

public class Win32NetBIOSSessionSocketHandler
extends SessionHandlerBase
implements Runnable,
LanaListener {
    public static final long LANAPollingInterval = 5000L;
    private static final ThreadGroup Win32NetBIOSGroup = new ThreadGroup("Win32NetBIOSSessions");
    private String m_srvName;
    private byte[] m_acceptClient;
    private boolean m_acceptAny;
    private String m_acceptClientStr;
    private NetBIOSName m_nbName;
    private int m_nameNum;
    private NetBIOSName m_wksNbName;
    private int m_wksNameNum;
    private int m_lana = -1;
    private boolean m_lanaValid;
    private long m_lanaPoll;
    private boolean m_useWinsock;
    private NetBIOSSocket m_nbSocket;
    private NetBIOSSocket m_wksSocket;

    public Win32NetBIOSSessionSocketHandler(SMBServer srv, boolean debug) {
        super("Win32 NetBIOS", "SMB", srv, null, 0);
        this.setDebug(debug);
        this.m_srvName = srv.getCIFSConfiguration().getWin32ServerName() != null ? srv.getCIFSConfiguration().getWin32ServerName() : srv.getCIFSConfiguration().getServerName();
        this.m_acceptClientStr = srv.getCIFSConfiguration().getWin32ClientAccept();
        NetBIOSName accName = new NetBIOSName(this.m_acceptClientStr, '\u0000', false);
        this.m_acceptClient = accName.getNetBIOSName();
        if (srv.getCIFSConfiguration().getWin32ClientAccept().equals("*")) {
            this.m_acceptAny = true;
        }
        this.m_lana = srv.getCIFSConfiguration().getWin32LANA();
        this.m_useWinsock = srv.getCIFSConfiguration().useWinsockNetBIOS();
        if (this.hasDebug()) {
            Debug.println("[SMB] Win32 NetBIOS server " + this.m_srvName + " (using " + (this.isUsingWinsock() ? "Winsock" : "Netbios() API") + ")");
        }
        this.m_lanaPoll = 5000L;
    }

    public Win32NetBIOSSessionSocketHandler(SMBServer srv, int lana, boolean debug) {
        super("Win32 NetBIOS", "SMB", srv, null, 0);
        this.setDebug(debug);
        this.m_srvName = srv.getCIFSConfiguration().getWin32ServerName() != null ? srv.getCIFSConfiguration().getWin32ServerName() : srv.getCIFSConfiguration().getServerName();
        this.m_acceptClientStr = srv.getCIFSConfiguration().getWin32ClientAccept();
        NetBIOSName accName = new NetBIOSName(this.m_acceptClientStr, '\u0000', false);
        this.m_acceptClient = accName.getNetBIOSName();
        if (srv.getCIFSConfiguration().getWin32ClientAccept().equals("*")) {
            this.m_acceptAny = true;
        }
        this.m_lana = lana;
        this.m_useWinsock = srv.getCIFSConfiguration().useWinsockNetBIOS();
        if (this.hasDebug()) {
            Debug.println("[SMB] Win32 NetBIOS server " + this.m_srvName + " (using " + (this.isUsingWinsock() ? "Winsock" : "Netbios() API") + ")");
        }
        this.m_lanaPoll = 5000L;
    }

    public final int getLANANumber() {
        return this.m_lana;
    }

    public final long getLANAOfflinePollingInterval() {
        return this.m_lanaPoll;
    }

    public final int getNameNumber() {
        return this.m_nameNum;
    }

    public final String getServerName() {
        return this.m_srvName;
    }

    public final boolean isUsingWinsock() {
        return this.m_useWinsock;
    }

    public void initializeSessionHandler(NetworkServer server) throws IOException {
        int[] lanas = Win32NetBIOS.LanaEnumerate();
        if (lanas.length > 0) {
            if (this.m_lana == -1) {
                this.m_lana = lanas[0];
            } else {
                boolean lanaOnline = false;
                int idx = 0;
                while (idx < lanas.length && !lanaOnline) {
                    if (lanas[idx++] != this.getLANANumber()) continue;
                    lanaOnline = true;
                }
                if (!lanaOnline) {
                    this.m_lanaValid = false;
                    return;
                }
            }
        } else {
            if (this.m_lana == -1) {
                throw new IOException("No Win32 NetBIOS LANAs available");
            }
            this.m_lanaValid = false;
            return;
        }
        this.m_nbName = new NetBIOSName(this.m_srvName, ' ', false);
        this.m_wksNbName = new NetBIOSName(this.m_srvName, '\u0000', false);
        if (this.isUsingWinsock()) {
            this.initializeWinsockNetBIOS();
        } else {
            this.initializeNetbiosAPI();
        }
        ((SMBServer)this.getServer()).fireNetBIOSNamesAddedEvent(this.m_lana);
        this.m_lanaValid = true;
    }

    private final void initializeNetbiosAPI() throws IOException {
        Win32NetBIOS.Reset(this.m_lana);
        this.m_nameNum = Win32NetBIOS.AddName(this.m_lana, this.m_nbName.getNetBIOSName());
        if (this.m_nameNum < 0) {
            throw new IOException("Win32 NetBIOS AddName failed (file server), status = 0x" + Integer.toHexString(-this.m_nameNum) + ", " + NetBIOS.getErrorString(-this.m_nameNum));
        }
        this.m_wksNameNum = Win32NetBIOS.AddName(this.m_lana, this.m_wksNbName.getNetBIOSName());
        if (this.m_wksNameNum < 0) {
            throw new IOException("Win32 NetBIOS AddName failed (workstation), status = 0x" + Integer.toHexString(-this.m_wksNameNum) + ", " + NetBIOS.getErrorString(-this.m_wksNameNum));
        }
    }

    private final void initializeWinsockNetBIOS() throws IOException {
        this.m_nbSocket = NetBIOSSocket.createListenerSocket(this.getLANANumber(), this.m_nbName);
        this.m_wksSocket = NetBIOSSocket.createListenerSocket(this.getLANANumber(), this.m_wksNbName);
    }

    public final boolean isLANAValid() {
        return this.m_lanaValid;
    }

    public void closeSessionHandler(NetworkServer server) {
        this.setShutdown(true);
        if (this.isLANAValid()) {
            Win32NetBIOS.Reset(this.m_lana);
        }
        if (this.isUsingWinsock()) {
            if (this.m_nbSocket != null) {
                this.m_nbSocket.closeSocket();
                this.m_nbSocket = null;
            }
            if (this.m_wksSocket != null) {
                this.m_wksSocket.closeSocket();
                this.m_wksSocket = null;
            }
        }
    }

    public void run() {
        block11: {
            try {
                this.clearShutdown();
                while (!this.hasShutdown()) {
                    block10: {
                        if (this.isLANAValid()) {
                            if (this.isUsingWinsock()) {
                                this.runWinsock();
                                continue;
                            }
                            this.runNetBIOS();
                            continue;
                        }
                        try {
                            Thread.sleep(this.getLANAOfflinePollingInterval());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            this.initializeSessionHandler(this.getServer());
                        }
                        catch (Exception ex) {
                            if (!this.hasDebug()) break block10;
                            Debug.println("[SMB] Win32 NetBIOS Failed To ReInitialize LANA");
                            Debug.println("  " + ex.getMessage());
                        }
                    }
                    if (!this.hasDebug() || !this.isLANAValid()) continue;
                    Debug.println("[SMB] Win32 NetBIOS LANA " + this.getLANANumber() + " Back Online");
                }
            }
            catch (Exception ex) {
                if (this.hasShutdown()) break block11;
                Debug.println("[SMB] Win32 NetBIOS Server error : " + ex.toString());
                Debug.println(ex);
            }
        }
        if (this.hasDebug()) {
            Debug.println("[SMB] Win32 NetBIOS session handler closed");
        }
    }

    private final void runNetBIOS() throws Exception {
        block13: {
            if (this.hasDebug()) {
                Debug.println("[SMB] Waiting for Win32 NetBIOS session request (Netbios API) ...");
            }
            byte[] callerNameBuf = new byte[16];
            String callerName = null;
            callerNameBuf[0] = 0;
            callerName = null;
            int lsn = Win32NetBIOS.Listen(this.m_lana, this.m_nbName.getNetBIOSName(), this.m_acceptClient, callerNameBuf);
            if (this.hasShutdown()) {
                return;
            }
            callerName = callerNameBuf[0] != 0 ? new String(callerNameBuf).trim() : "";
            if (lsn >= 0) {
                try {
                    if (this.hasDebug()) {
                        Debug.println("[SMB] Win32 NetBIOS session request received, lsn=" + lsn + ", caller=[" + callerName + "]");
                    }
                    if (this.acceptCaller(callerName)) {
                        SMBServer smbServer = (SMBServer)this.getServer();
                        Win32NetBIOSPacketHandler pktHandler = new Win32NetBIOSPacketHandler(this.m_lana, lsn, callerName, smbServer.getPacketPool());
                        SMBSrvSession srvSess = SMBSrvSession.createSession(pktHandler, smbServer, this.getNextSessionId());
                        Thread srvThread = new Thread(Win32NetBIOSGroup, srvSess);
                        srvThread.setDaemon(true);
                        srvThread.setName("Sess_W" + srvSess.getSessionId() + "_LSN" + lsn);
                        srvThread.start();
                        break block13;
                    }
                    if (this.hasDebug()) {
                        Debug.println("[SMB] Win32 NetBIOS Reject client " + callerName);
                    }
                    Win32NetBIOS.Hangup(this.m_lana, lsn);
                }
                catch (Exception ex) {
                    if (this.hasDebug()) {
                        Debug.println("[SMB] Win32 NetBIOS Failed to create session, " + ex.toString());
                    }
                    break block13;
                }
            }
            int sts = -lsn;
            if (sts == 35) {
                this.m_lanaValid = false;
                if (this.hasDebug()) {
                    Debug.println("[SMB] Win32 NetBIOS LANA offline/disabled, LANA=" + this.getLANANumber());
                }
            } else if (this.hasDebug()) {
                Debug.println("[SMB] Win32 NetBIOS Listen error, 0x" + Integer.toHexString(-lsn) + ", " + NetBIOS.getErrorString(-lsn));
            }
        }
    }

    private final void runWinsock() throws Exception {
        block17: {
            NetBIOSSocket sessSock;
            block16: {
                if (this.hasDebug()) {
                    Debug.println("[SMB] Waiting for Win32 NetBIOS session request (Winsock) ...");
                }
                sessSock = null;
                try {
                    sessSock = this.m_nbSocket.accept();
                }
                catch (WinsockNetBIOSException ex) {
                    if (ex.getErrorCode() == 10050) {
                        if (!this.isLANAOnline(this.m_lana)) {
                            if (this.m_nbSocket != null) {
                                this.m_nbSocket.closeSocket();
                                this.m_nbSocket = null;
                            }
                            if (this.m_wksSocket != null) {
                                this.m_wksSocket.closeSocket();
                                this.m_wksSocket = null;
                            }
                            this.m_lanaValid = false;
                            if (this.hasDebug()) {
                                Debug.println("[SMB] Winsock NetBIOS network down, LANA=" + this.m_lana);
                            }
                        }
                    }
                    if (this.hasShutdown() || !this.hasDebug()) break block16;
                    Debug.println("[SMB] Winsock NetBIOS listen error, " + ex.getMessage());
                }
            }
            if (this.hasShutdown()) {
                return;
            }
            if (sessSock != null) {
                try {
                    if (this.hasDebug()) {
                        Debug.println("[SMB] Winsock NetBIOS session request received, caller=" + sessSock.getName());
                    }
                    if (this.acceptCaller(sessSock.getName())) {
                        SMBServer smbServer = (SMBServer)this.getServer();
                        WinsockNetBIOSPacketHandler pktHandler = new WinsockNetBIOSPacketHandler(this.m_lana, sessSock, smbServer.getPacketPool(), false);
                        SMBSrvSession srvSess = SMBSrvSession.createSession(pktHandler, smbServer, this.getNextSessionId());
                        Thread srvThread = new Thread(Win32NetBIOSGroup, srvSess);
                        srvThread.setDaemon(true);
                        srvThread.setName("Sess_WS" + srvSess.getSessionId());
                        srvThread.start();
                    } else {
                        if (this.hasDebug()) {
                            Debug.println("[SMB] Winsock NetBIOS Reject client " + sessSock.getName());
                        }
                        sessSock.closeSocket();
                    }
                }
                catch (Exception ex) {
                    if (!this.hasDebug()) break block17;
                    Debug.println("[SMB] Winsock NetBIOS Failed to create session, " + ex.toString());
                }
            }
        }
    }

    public static final void createSessionHandlers(SMBServer server, boolean sockDbg) {
        ServerConfiguration config = server.getConfiguration();
        CIFSConfigSection cifsConfig = (CIFSConfigSection)config.getConfigSection("CIFS");
        if (sockDbg) {
            int[] lanas = Win32NetBIOS.LanaEnumerate();
            StringBuffer lanaStr = new StringBuffer();
            if (lanas != null && lanas.length > 0) {
                for (int i = 0; i < lanas.length; ++i) {
                    lanaStr.append(Integer.toString(lanas[i]));
                    lanaStr.append(" ");
                }
            }
            Debug.println("[SMB] Win32 NetBIOS Available LANAs: " + lanaStr.toString());
        }
        Win32NetBIOSSessionSocketHandler sessHandler = null;
        ArrayList<Win32NetBIOSSessionSocketHandler> lanaListeners = new ArrayList<Win32NetBIOSSessionSocketHandler>();
        if (cifsConfig.getWin32LANA() != -1) {
            block20: {
                sessHandler = new Win32NetBIOSSessionSocketHandler(server, cifsConfig.getWin32LANA(), sockDbg);
                try {
                    sessHandler.initializeSessionHandler(server);
                }
                catch (Exception ex) {
                    if (!sockDbg) break block20;
                    Debug.println("[SMB] Win32 NetBIOS failed to create session handler for LANA " + cifsConfig.getWin32LANA());
                    Debug.println("      " + ex.getMessage());
                }
            }
            Thread nbThread = new Thread(sessHandler);
            nbThread.setName("Win32NB_Handler_" + cifsConfig.getWin32LANA());
            nbThread.start();
            if (sockDbg) {
                Debug.println("[SMB] Win32 NetBIOS created session handler on LANA " + cifsConfig.getWin32LANA());
            }
            if (cifsConfig.hasWin32EnableAnnouncer()) {
                Win32NetBIOSHostAnnouncer hostAnnouncer = new Win32NetBIOSHostAnnouncer(sessHandler, cifsConfig.getDomainName(), cifsConfig.getWin32HostAnnounceInterval());
                hostAnnouncer.setDebug(sockDbg);
                hostAnnouncer.start();
                if (sockDbg) {
                    Debug.println("[SMB] Win32 NetBIOS host announcer enabled on LANA " + cifsConfig.getWin32LANA());
                }
            }
            if (sessHandler instanceof LanaListener) {
                lanaListeners.add(sessHandler);
            }
        } else {
            int[] lanas = Win32NetBIOS.LanaEnumerate();
            if (lanas != null && lanas.length > 0) {
                for (int i = 0; i < lanas.length; ++i) {
                    int lana;
                    block21: {
                        lana = lanas[i];
                        sessHandler = new Win32NetBIOSSessionSocketHandler(server, lana, sockDbg);
                        try {
                            sessHandler.initializeSessionHandler(server);
                        }
                        catch (Exception ex) {
                            if (!sockDbg) break block21;
                            Debug.println("[SMB] Win32 NetBIOS failed to create session handler for LANA " + lana);
                            Debug.println("      " + ex.getMessage());
                        }
                    }
                    Thread nbThread = new Thread(sessHandler);
                    nbThread.setName("Win32NB_Handler_" + lana);
                    nbThread.start();
                    if (sockDbg) {
                        Debug.println("[SMB] Win32 NetBIOS created session handler on LANA " + lana);
                    }
                    if (cifsConfig.hasWin32EnableAnnouncer()) {
                        Win32NetBIOSHostAnnouncer hostAnnouncer = new Win32NetBIOSHostAnnouncer(sessHandler, cifsConfig.getDomainName(), cifsConfig.getWin32HostAnnounceInterval());
                        hostAnnouncer.setDebug(sockDbg);
                        hostAnnouncer.start();
                        if (sockDbg) {
                            Debug.println("[SMB] Win32 NetBIOS host announcer enabled on LANA " + lana);
                        }
                    }
                    if (!(sessHandler instanceof LanaListener)) continue;
                    lanaListeners.add(sessHandler);
                }
            }
            Win32NetBIOSLanaMonitor lanaMonitor = new Win32NetBIOSLanaMonitor(server, lanas, 5000L, sockDbg);
            if (lanaListeners.size() > 0) {
                for (int i = 0; i < lanaListeners.size(); ++i) {
                    Win32NetBIOSSessionSocketHandler handler = (Win32NetBIOSSessionSocketHandler)lanaListeners.get(i);
                    lanaMonitor.addLanaListener(handler.getLANANumber(), handler);
                }
            }
        }
    }

    private final boolean isLANAOnline(int lana) {
        int[] lanas = Win32NetBIOS.LanaEnumerate();
        if (lanas != null && lanas.length > 0) {
            for (int i = 0; i < lanas.length; ++i) {
                if (lanas[i] != lana) continue;
                return true;
            }
        }
        return false;
    }

    public void lanaStatusChange(int lana, boolean online) {
        if (!online) {
            this.m_lanaValid = false;
            if (this.m_nbSocket != null) {
                this.m_nbSocket.closeSocket();
                this.m_nbSocket = null;
            }
            if (this.m_wksSocket != null) {
                this.m_wksSocket.closeSocket();
                this.m_wksSocket = null;
            }
        }
    }

    private final boolean acceptCaller(String callerName) {
        if (this.m_acceptAny) {
            return true;
        }
        return callerName.equalsIgnoreCase(this.m_acceptClientStr);
    }

    private final boolean acceptCaller(NetBIOSName callerNBName) {
        if (this.m_acceptAny) {
            return true;
        }
        byte[] callerName = callerNBName.getNetBIOSName();
        for (int i = 0; i < 15; ++i) {
            if (callerName[i] == this.m_acceptClient[i]) continue;
            return false;
        }
        return true;
    }
}

