/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail;

import com.icegreen.greenmail.Managers;
import com.icegreen.greenmail.util.DummySSLServerSocketFactory;
import com.icegreen.greenmail.util.ServerSetup;
import com.icegreen.greenmail.util.Service;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.net.ssl.SSLServerSocket;

public abstract class AbstractServer
extends Service {
    protected InetAddress bindTo;
    protected ServerSocket serverSocket = null;
    protected Vector handlers = null;
    protected Managers managers;
    protected ServerSetup setup;

    protected AbstractServer(ServerSetup setup, Managers managers) {
        try {
            this.setup = setup;
            this.bindTo = InetAddress.getByName(setup.getBindAddress());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        this.managers = managers;
        this.handlers = new Vector();
    }

    protected synchronized ServerSocket openServerSocket() throws IOException {
        ServerSocket ret = this.setup.isSecure() ? (SSLServerSocket)DummySSLServerSocketFactory.getDefault().createServerSocket(this.setup.getPort(), 0, this.bindTo) : new ServerSocket(this.setup.getPort(), 0, this.bindTo);
        return ret;
    }

    public String getBindTo() {
        return this.bindTo.getHostAddress();
    }

    public int getPort() {
        return this.setup.getPort();
    }

    public String getProtocol() {
        return this.setup.getProtocol();
    }

    public ServerSetup getServerSetup() {
        return this.setup;
    }

    public String toString() {
        return this.setup != null ? String.valueOf(this.setup.getProtocol()) + ':' + this.setup.getPort() : super.toString();
    }
}

