/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap;

import com.icegreen.greenmail.imap.AuthorizationException;
import com.icegreen.greenmail.imap.ImapConstants;
import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.InMemoryStore;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.Store;
import com.icegreen.greenmail.user.GreenMailUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ImapHostManagerImpl
implements ImapHostManager,
ImapConstants {
    private Store store;
    private MailboxSubscriptions subscriptions;

    public ImapHostManagerImpl() {
        this.store = new InMemoryStore();
        this.subscriptions = new MailboxSubscriptions();
    }

    public ImapHostManagerImpl(Store store) {
        this.store = store;
        this.subscriptions = new MailboxSubscriptions();
    }

    public List getAllMessages() {
        ArrayList ret = new ArrayList();
        try {
            Collection boxes = this.store.listMailboxes("*");
            for (MailFolder folder : boxes) {
                List messages = folder.getMessages();
                int i = 0;
                while (i < messages.size()) {
                    ret.add(messages.get(i));
                    ++i;
                }
            }
        }
        catch (FolderException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public char getHierarchyDelimiter() {
        return '/';
    }

    public MailFolder getFolder(GreenMailUser user, String mailboxName) {
        String name = this.getQualifiedMailboxName(user, mailboxName);
        MailFolder folder = this.store.getMailbox(name);
        return this.checkViewable(folder);
    }

    public MailFolder getFolder(GreenMailUser user, String mailboxName, boolean mustExist) throws FolderException {
        MailFolder folder = this.getFolder(user, mailboxName);
        if (mustExist && folder == null) {
            throw new FolderException("No such store.");
        }
        return folder;
    }

    private MailFolder checkViewable(MailFolder folder) {
        return folder;
    }

    public MailFolder getInbox(GreenMailUser user) throws FolderException {
        return this.getFolder(user, "INBOX");
    }

    public void createPrivateMailAccount(GreenMailUser user) throws FolderException {
        MailFolder root = this.store.getMailbox("#mail");
        MailFolder userRoot = this.store.createMailbox(root, user.getQualifiedMailboxName(), false);
        this.store.createMailbox(userRoot, "INBOX", true);
    }

    /*
     * Unable to fully structure code
     */
    public MailFolder createMailbox(GreenMailUser user, String mailboxName) throws AuthorizationException, FolderException {
        qualifiedName = this.getQualifiedMailboxName(user, mailboxName);
        if (this.store.getMailbox(qualifiedName) != null) {
            throw new FolderException("Mailbox already exists.");
        }
        tokens = new StringTokenizer(qualifiedName, ImapHostManagerImpl.HIERARCHY_DELIMITER);
        if (tokens.countTokens() < 2) {
            throw new FolderException("Cannot create store at namespace level.");
        }
        namespaceRoot = tokens.nextToken();
        folder = this.store.getMailbox(namespaceRoot);
        if (folder != null) ** GOTO lbl17
        throw new FolderException("Invalid namespace.");
lbl-1000:
        // 1 sources

        {
            childName = tokens.nextToken();
            child = this.store.getMailbox(folder, childName);
            if (child == null) {
                makeSelectable = tokens.hasMoreTokens() == false;
                child = this.store.createMailbox(folder, childName, makeSelectable);
            }
            folder = child;
lbl17:
            // 2 sources

            ** while (tokens.hasMoreTokens())
        }
lbl18:
        // 1 sources

        return folder;
    }

    public void deleteMailbox(GreenMailUser user, String mailboxName) throws FolderException, AuthorizationException {
        MailFolder toDelete = this.getFolder(user, mailboxName, true);
        if (this.store.getChildren(toDelete).isEmpty()) {
            toDelete.deleteAllMessages();
            toDelete.signalDeletion();
            this.store.deleteMailbox(toDelete);
        } else if (toDelete.isSelectable()) {
            toDelete.deleteAllMessages();
            this.store.setSelectable(toDelete, false);
        } else {
            throw new FolderException("Can't delete a non-selectable store with children.");
        }
    }

    public void renameMailbox(GreenMailUser user, String oldMailboxName, String newMailboxName) throws FolderException, AuthorizationException {
        MailFolder existingFolder = this.getFolder(user, oldMailboxName, true);
        String userInboxName = this.getQualifiedMailboxName(user, "INBOX");
        if (userInboxName.equals(existingFolder.getFullName())) {
            MailFolder inbox = existingFolder;
            MailFolder newBox = this.createMailbox(user, newMailboxName);
            long[] uids = inbox.getMessageUids();
            int i = 0;
            while (i < uids.length) {
                long uid = uids[i];
                inbox.copyMessage(uid, newBox);
                ++i;
            }
            inbox.deleteAllMessages();
            return;
        }
        this.store.renameMailbox(existingFolder, newMailboxName);
    }

    public Collection listSubscribedMailboxes(GreenMailUser user, String mailboxPattern) throws FolderException {
        return this.listMailboxes(user, mailboxPattern, true);
    }

    public Collection listMailboxes(GreenMailUser user, String mailboxPattern) throws FolderException {
        return this.listMailboxes(user, mailboxPattern, false);
    }

    private Collection listMailboxes(GreenMailUser user, String mailboxPattern, boolean subscribedOnly) throws FolderException {
        ArrayList<MailFolder> mailboxes = new ArrayList<MailFolder>();
        String qualifiedPattern = this.getQualifiedMailboxName(user, mailboxPattern);
        for (MailFolder folder : this.store.listMailboxes(qualifiedPattern)) {
            if (subscribedOnly && !this.subscriptions.isSubscribed(user, folder)) {
                folder = null;
            }
            if ((folder = this.checkViewable(folder)) == null) continue;
            mailboxes.add(folder);
        }
        return mailboxes;
    }

    public void subscribe(GreenMailUser user, String mailboxName) throws FolderException {
        MailFolder folder = this.getFolder(user, mailboxName, true);
        this.subscriptions.subscribe(user, folder);
    }

    public void unsubscribe(GreenMailUser user, String mailboxName) throws FolderException {
        MailFolder folder = this.getFolder(user, mailboxName, true);
        this.subscriptions.unsubscribe(user, folder);
    }

    private String getQualifiedMailboxName(GreenMailUser user, String mailboxName) {
        String userNamespace = user.getQualifiedMailboxName();
        if ("INBOX".equalsIgnoreCase(mailboxName)) {
            return "#mail" + HIERARCHY_DELIMITER + userNamespace + HIERARCHY_DELIMITER + "INBOX";
        }
        if (mailboxName.startsWith(NAMESPACE_PREFIX)) {
            return mailboxName;
        }
        if (mailboxName.length() == 0) {
            return "#mail" + HIERARCHY_DELIMITER + userNamespace;
        }
        return "#mail" + HIERARCHY_DELIMITER + userNamespace + HIERARCHY_DELIMITER + mailboxName;
    }

    private class MailboxSubscriptions {
        private Map userSubs = new HashMap();

        private MailboxSubscriptions() {
        }

        void subscribe(GreenMailUser user, MailFolder folder) throws FolderException {
            this.getUserSubs(user).add(folder.getFullName());
        }

        void unsubscribe(GreenMailUser user, MailFolder folder) throws FolderException {
            this.getUserSubs(user).remove(folder.getFullName());
        }

        boolean isSubscribed(GreenMailUser user, MailFolder folder) {
            return this.getUserSubs(user).contains(folder.getFullName());
        }

        private Collection getUserSubs(GreenMailUser user) {
            ArrayList subs = (ArrayList)this.userSubs.get(user.getLogin());
            if (subs == null) {
                subs = new ArrayList();
                this.userSubs.put(user.getLogin(), subs);
            }
            return subs;
        }
    }
}

