/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionFolder;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.imap.commands.SelectedStateCommand;
import com.icegreen.greenmail.imap.commands.UidEnabledCommand;
import com.icegreen.greenmail.store.FolderException;
import javax.mail.Message;
import javax.mail.search.SearchTerm;

class SearchCommand
extends SelectedStateCommand
implements UidEnabledCommand {
    public static final String NAME = "SEARCH";
    public static final String ARGS = "<search term>";
    private SearchCommandParser parser = new SearchCommandParser();

    SearchCommand() {
    }

    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException {
        this.doProcess(request, response, session, false);
    }

    public void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session, boolean useUids) throws ProtocolException, FolderException {
        SearchTerm searchTerm = this.parser.searchTerm(request);
        this.parser.endLine(request);
        ImapSessionFolder folder = session.getSelected();
        long[] uids = folder.search(searchTerm);
        StringBuffer idList = new StringBuffer();
        int i = 0;
        while (i < uids.length) {
            if (i > 0) {
                idList.append(" ");
            }
            long uid = uids[i];
            if (useUids) {
                idList.append(uid);
            } else {
                int msn = folder.getMsn(uid);
                idList.append(msn);
            }
            ++i;
        }
        response.commandResponse(this, idList.toString());
        boolean omitExpunged = !useUids;
        session.unsolicitedResponses(response, omitExpunged);
        response.commandComplete(this);
    }

    public String getName() {
        return NAME;
    }

    public String getArgSyntax() {
        return ARGS;
    }

    private class SearchCommandParser
    extends CommandParser {
        private SearchCommandParser() {
        }

        public SearchTerm searchTerm(ImapRequestLineReader request) throws ProtocolException {
            char next = request.nextChar();
            while (next != '\n') {
                request.consume();
                next = request.nextChar();
            }
            return new SearchTerm(){

                public boolean match(Message message) {
                    return true;
                }
            };
        }
    }
}

