/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.store;

import com.icegreen.greenmail.foedus.util.MsgRangeFilter;
import com.icegreen.greenmail.imap.ImapConstants;
import com.icegreen.greenmail.mail.MovingMessage;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.FolderListener;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.MessageFlags;
import com.icegreen.greenmail.store.SimpleStoredMessage;
import com.icegreen.greenmail.store.Store;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.search.SearchTerm;

public class InMemoryStore
implements Store,
ImapConstants {
    private RootFolder rootMailbox = new RootFolder();
    private static final Flags PERMANENT_FLAGS = new Flags();

    static {
        PERMANENT_FLAGS.add(Flags.Flag.ANSWERED);
        PERMANENT_FLAGS.add(Flags.Flag.DELETED);
        PERMANENT_FLAGS.add(Flags.Flag.DRAFT);
        PERMANENT_FLAGS.add(Flags.Flag.FLAGGED);
        PERMANENT_FLAGS.add(Flags.Flag.SEEN);
    }

    public MailFolder getMailbox(String absoluteMailboxName) {
        StringTokenizer tokens = new StringTokenizer(absoluteMailboxName, HIERARCHY_DELIMITER);
        if (!tokens.hasMoreTokens() || !tokens.nextToken().equalsIgnoreCase("#mail")) {
            return null;
        }
        HierarchicalFolder parent = this.rootMailbox;
        while (parent != null && tokens.hasMoreTokens()) {
            String childName = tokens.nextToken();
            parent = parent.getChild(childName);
        }
        return parent;
    }

    public MailFolder getMailbox(MailFolder parent, String name) {
        return ((HierarchicalFolder)parent).getChild(name);
    }

    public MailFolder createMailbox(MailFolder parent, String mailboxName, boolean selectable) throws FolderException {
        if (mailboxName.indexOf(47) != -1) {
            throw new FolderException("Invalid mailbox name.");
        }
        HierarchicalFolder castParent = (HierarchicalFolder)parent;
        HierarchicalFolder child = new HierarchicalFolder(castParent, mailboxName);
        castParent.getChildren().add(child);
        child.setSelectable(selectable);
        return child;
    }

    public void deleteMailbox(MailFolder folder) throws FolderException {
        HierarchicalFolder toDelete = (HierarchicalFolder)folder;
        if (!toDelete.getChildren().isEmpty()) {
            throw new FolderException("Cannot delete mailbox with children.");
        }
        if (toDelete.getMessageCount() != 0) {
            throw new FolderException("Cannot delete non-empty mailbox");
        }
        HierarchicalFolder parent = toDelete.getParent();
        parent.getChildren().remove(toDelete);
    }

    public void renameMailbox(MailFolder existingFolder, String newName) throws FolderException {
        HierarchicalFolder toRename = (HierarchicalFolder)existingFolder;
        toRename.setName(newName);
    }

    public Collection getChildren(MailFolder parent) {
        Collection children = ((HierarchicalFolder)parent).getChildren();
        return Collections.unmodifiableCollection(children);
    }

    public MailFolder setSelectable(MailFolder folder, boolean selectable) {
        ((HierarchicalFolder)folder).setSelectable(selectable);
        return folder;
    }

    public Collection listMailboxes(String searchPattern) throws FolderException {
        int starIndex = searchPattern.indexOf(42);
        int percentIndex = searchPattern.indexOf(37);
        if (starIndex > -1 && starIndex < searchPattern.length() - 1 || percentIndex > -1 && percentIndex < searchPattern.length() - 1) {
            throw new FolderException("WIldcard characters are only handled as the last character of a list argument.");
        }
        ArrayList<MailFolder> mailboxes = new ArrayList<MailFolder>();
        if (starIndex != -1 || percentIndex != -1) {
            int lastDot = searchPattern.lastIndexOf(HIERARCHY_DELIMITER);
            String parentName = lastDot < 0 ? "#mail" : searchPattern.substring(0, lastDot);
            String matchPattern = searchPattern.substring(lastDot + 1, searchPattern.length() - 1);
            HierarchicalFolder parent = (HierarchicalFolder)this.getMailbox(parentName);
            if (parent != null) {
                for (HierarchicalFolder child : parent.getChildren()) {
                    if (!child.getName().startsWith(matchPattern)) continue;
                    mailboxes.add(child);
                    if (starIndex == -1) continue;
                    this.addAllChildren(child, mailboxes);
                }
            }
        } else {
            MailFolder folder = this.getMailbox(searchPattern);
            if (folder != null) {
                mailboxes.add(folder);
            }
        }
        return mailboxes;
    }

    private void addAllChildren(HierarchicalFolder mailbox, Collection mailboxes) {
        Collection children = mailbox.getChildren();
        for (HierarchicalFolder child : children) {
            mailboxes.add(child);
            this.addAllChildren(child, mailboxes);
        }
    }

    private class HierarchicalFolder
    implements MailFolder {
        private Collection children;
        private HierarchicalFolder parent;
        protected String name;
        private boolean isSelectable = false;
        private List mailMessages = Collections.synchronizedList(new LinkedList());
        private long nextUid = 1L;
        private long uidValidity;
        private List _mailboxListeners = Collections.synchronizedList(new LinkedList());

        public HierarchicalFolder(HierarchicalFolder parent, String name) {
            this.name = name;
            this.children = new ArrayList();
            this.parent = parent;
            this.uidValidity = System.currentTimeMillis();
        }

        public Collection getChildren() {
            return this.children;
        }

        public HierarchicalFolder getParent() {
            return this.parent;
        }

        public HierarchicalFolder getChild(String name) {
            for (HierarchicalFolder child : this.children) {
                if (!child.getName().equalsIgnoreCase(name)) continue;
                return child;
            }
            return null;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getFullName() {
            return String.valueOf(this.parent.getFullName()) + '/' + this.name;
        }

        public Flags getPermanentFlags() {
            return PERMANENT_FLAGS;
        }

        public int getMessageCount() {
            return this.mailMessages.size();
        }

        public long getUidValidity() {
            return this.uidValidity;
        }

        public long getUidNext() {
            return this.nextUid;
        }

        public int getUnseenCount() {
            int count = 0;
            int i = 0;
            while (i < this.mailMessages.size()) {
                SimpleStoredMessage message = (SimpleStoredMessage)this.mailMessages.get(i);
                if (!message.getFlags().contains(Flags.Flag.SEEN)) {
                    ++count;
                }
                ++i;
            }
            return count;
        }

        public int getFirstUnseen() {
            int i = 0;
            while (i < this.mailMessages.size()) {
                SimpleStoredMessage message = (SimpleStoredMessage)this.mailMessages.get(i);
                if (!message.getFlags().contains(Flags.Flag.SEEN)) {
                    return i + 1;
                }
                ++i;
            }
            return -1;
        }

        public int getRecentCount(boolean reset) {
            int count = 0;
            int i = 0;
            while (i < this.mailMessages.size()) {
                SimpleStoredMessage message = (SimpleStoredMessage)this.mailMessages.get(i);
                if (message.getFlags().contains(Flags.Flag.RECENT)) {
                    ++count;
                    if (reset) {
                        message.getFlags().remove(Flags.Flag.RECENT);
                    }
                }
                ++i;
            }
            return count;
        }

        public int getMsn(long uid) throws FolderException {
            int i = 0;
            while (i < this.mailMessages.size()) {
                SimpleStoredMessage message = (SimpleStoredMessage)this.mailMessages.get(i);
                if (message.getUid() == uid) {
                    return i + 1;
                }
                ++i;
            }
            throw new FolderException("No such message.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void signalDeletion() {
            List list = this._mailboxListeners;
            synchronized (list) {
                int j = 0;
                while (j < this._mailboxListeners.size()) {
                    FolderListener listener = (FolderListener)this._mailboxListeners.get(j);
                    listener.mailboxDeleted();
                    ++j;
                }
            }
        }

        public List getMessages(MsgRangeFilter range) {
            ArrayList ret = new ArrayList();
            int i = 0;
            while (i < this.mailMessages.size()) {
                if (range.includes(i + 1)) {
                    ret.add(this.mailMessages.get(i));
                }
                ++i;
            }
            return ret;
        }

        public List getMessages() {
            return this.mailMessages;
        }

        public List getNonDeletedMessages() {
            ArrayList<SimpleStoredMessage> ret = new ArrayList<SimpleStoredMessage>();
            int i = 0;
            while (i < this.mailMessages.size()) {
                SimpleStoredMessage message = (SimpleStoredMessage)this.mailMessages.get(i);
                if (!message.getFlags().contains(Flags.Flag.DELETED)) {
                    ret.add(message);
                }
                ++i;
            }
            return ret;
        }

        public boolean isSelectable() {
            return this.isSelectable;
        }

        public void setSelectable(boolean selectable) {
            this.isSelectable = selectable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long appendMessage(MimeMessage message, Flags flags, Date internalDate) {
            long uid = this.nextUid++;
            SimpleStoredMessage storedMessage = new SimpleStoredMessage(message, flags, internalDate, uid);
            storedMessage.getFlags().add(Flags.Flag.RECENT);
            this.mailMessages.add(storedMessage);
            int newMsn = this.mailMessages.size();
            List list = this._mailboxListeners;
            synchronized (list) {
                int j = 0;
                while (j < this._mailboxListeners.size()) {
                    FolderListener listener = (FolderListener)this._mailboxListeners.get(j);
                    listener.added(newMsn);
                    ++j;
                }
            }
            return uid;
        }

        public void setFlags(Flags flags, boolean value, long uid, FolderListener silentListener, boolean addUid) throws FolderException {
            int msn = this.getMsn(uid);
            SimpleStoredMessage message = (SimpleStoredMessage)this.mailMessages.get(msn - 1);
            if (value) {
                message.getFlags().add(flags);
            } else {
                message.getFlags().remove(flags);
            }
            Long uidNotification = null;
            if (addUid) {
                uidNotification = new Long(uid);
            }
            this.notifyFlagUpdate(msn, message.getFlags(), uidNotification, silentListener);
        }

        public void replaceFlags(Flags flags, long uid, FolderListener silentListener, boolean addUid) throws FolderException {
            int msn = this.getMsn(uid);
            SimpleStoredMessage message = (SimpleStoredMessage)this.mailMessages.get(msn - 1);
            message.getFlags().remove(MessageFlags.ALL_FLAGS);
            message.getFlags().add(flags);
            Long uidNotification = null;
            if (addUid) {
                uidNotification = new Long(uid);
            }
            this.notifyFlagUpdate(msn, message.getFlags(), uidNotification, silentListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyFlagUpdate(int msn, Flags flags, Long uidNotification, FolderListener silentListener) {
            List list = this._mailboxListeners;
            synchronized (list) {
                int i = 0;
                while (i < this._mailboxListeners.size()) {
                    FolderListener listener = (FolderListener)this._mailboxListeners.get(i);
                    if (listener != silentListener) {
                        listener.flagsUpdated(msn, flags, uidNotification);
                    }
                    ++i;
                }
            }
        }

        public void deleteAllMessages() {
            this.mailMessages.clear();
        }

        public void store(MovingMessage mail) throws Exception {
            this.store(mail.getMessage());
        }

        public void store(MimeMessage message) throws Exception {
            Date internalDate = new Date();
            Flags flags = new Flags();
            this.appendMessage(message, flags, internalDate);
        }

        public SimpleStoredMessage getMessage(long uid) {
            int i = 0;
            while (i < this.mailMessages.size()) {
                SimpleStoredMessage message = (SimpleStoredMessage)this.mailMessages.get(i);
                if (message.getUid() == uid) {
                    return message;
                }
                ++i;
            }
            return null;
        }

        public long[] getMessageUids() {
            long[] uids = new long[this.mailMessages.size()];
            int i = 0;
            while (i < this.mailMessages.size()) {
                SimpleStoredMessage message = (SimpleStoredMessage)this.mailMessages.get(i);
                uids[i] = message.getUid();
                ++i;
            }
            return uids;
        }

        private void deleteMessage(int msn) {
            this.mailMessages.remove(msn - 1);
        }

        public long[] search(SearchTerm searchTerm) {
            ArrayList<SimpleStoredMessage> matchedMessages = new ArrayList<SimpleStoredMessage>();
            int i = 0;
            while (i < this.mailMessages.size()) {
                SimpleStoredMessage message = (SimpleStoredMessage)this.mailMessages.get(i);
                if (searchTerm.match((Message)message.getMimeMessage())) {
                    matchedMessages.add(message);
                }
                ++i;
            }
            long[] matchedUids = new long[matchedMessages.size()];
            int i2 = 0;
            while (i2 < matchedUids.length) {
                long uid;
                SimpleStoredMessage storedMessage = (SimpleStoredMessage)matchedMessages.get(i2);
                matchedUids[i2] = uid = storedMessage.getUid();
                ++i2;
            }
            return matchedUids;
        }

        public void copyMessage(long uid, MailFolder toFolder) throws FolderException {
            SimpleStoredMessage originalMessage = this.getMessage(uid);
            MimeMessage newMime = null;
            try {
                newMime = new MimeMessage(originalMessage.getMimeMessage());
            }
            catch (MessagingException e) {
                throw new FolderException("Messaging exception: " + e.getMessage());
            }
            Flags newFlags = new Flags();
            newFlags.add(originalMessage.getFlags());
            Date newDate = originalMessage.getInternalDate();
            toFolder.appendMessage(newMime, newFlags, newDate);
        }

        public void expunge() throws FolderException {
            int i = 0;
            while (i < this.mailMessages.size()) {
                SimpleStoredMessage message = (SimpleStoredMessage)this.mailMessages.get(i);
                if (message.getFlags().contains(Flags.Flag.DELETED)) {
                    this.expungeMessage(i + 1);
                }
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void expungeMessage(int msn) {
            List list = this._mailboxListeners;
            synchronized (list) {
                this.deleteMessage(msn);
                int j = 0;
                while (j < this._mailboxListeners.size()) {
                    FolderListener expungeListener = (FolderListener)this._mailboxListeners.get(j);
                    expungeListener.expunged(msn);
                    ++j;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(FolderListener listener) {
            List list = this._mailboxListeners;
            synchronized (list) {
                this._mailboxListeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(FolderListener listener) {
            List list = this._mailboxListeners;
            synchronized (list) {
                this._mailboxListeners.remove(listener);
            }
        }
    }

    private class RootFolder
    extends HierarchicalFolder {
        public RootFolder() {
            super(null, "#mail");
        }

        public String getFullName() {
            return this.name;
        }
    }
}

