/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.client;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CMISValidator {
    private DocumentBuilder documentBuilder = null;
    private Validator appValidator = null;
    private Validator atomValidator = null;

    public DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (this.documentBuilder == null) {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            this.documentBuilder = builderFactory.newDocumentBuilder();
        }
        return this.documentBuilder;
    }

    public Validator getAppValidator() throws IOException, SAXException {
        if (this.appValidator == null) {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Source[] schemas = new Source[]{this.getAPPSource(), this.getCMISCoreSource(), this.getCMISRestAtomSource()};
            Schema schema = factory.newSchema(schemas);
            this.appValidator = schema.newValidator();
        }
        return this.appValidator;
    }

    public Validator getCMISAtomValidator() throws IOException, SAXException {
        if (this.atomValidator == null) {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Source[] schemas = new Source[]{this.getATOMSource(), this.getCMISCoreSource(), this.getCMISRestAtomSource()};
            Schema schema = factory.newSchema(schemas);
            this.atomValidator = schema.newValidator();
        }
        return this.atomValidator;
    }

    public void validateXML(String xml, Validator validator) throws IOException, ParserConfigurationException, SAXException {
        Document document = this.getDocumentBuilder().parse(new InputSource(new StringReader(xml)));
        validator.validate(new DOMSource(document));
    }

    private Source getATOMSource() {
        return new StreamSource(this.getClass().getResourceAsStream("/org/apache/chemistry/tck/atompub/xsd/ATOM.xsd"), this.getClass().getResource("/org/apache/chemistry/tck/atompub/xsd/ATOM.xsd").toExternalForm());
    }

    private Source getAPPSource() {
        return new StreamSource(this.getClass().getResourceAsStream("/org/apache/chemistry/tck/atompub/xsd/APP.xsd"), this.getClass().getResource("/org/apache/chemistry/tck/atompub/xsd/APP.xsd").toExternalForm());
    }

    private Source getCMISCoreSource() {
        return new StreamSource(this.getClass().getResourceAsStream("/org/apache/chemistry/tck/atompub/xsd/CMIS-Core.xsd"), this.getClass().getResource("/org/apache/chemistry/tck/atompub/xsd/CMIS-Core.xsd").toExternalForm());
    }

    private Source getCMISRestAtomSource() {
        return new StreamSource(this.getClass().getResourceAsStream("/org/apache/chemistry/tck/atompub/xsd/CMIS-RestAtom.xsd"), this.getClass().getResource("/org/apache/chemistry/tck/atompub/xsd/CMIS-RestAtom.xsd").toExternalForm());
    }

    public String toString(SAXException e, String xml) {
        StringBuffer fail = new StringBuffer(e.toString());
        if (e instanceof SAXParseException) {
            fail.append("\n");
            fail.append("line: ").append(((SAXParseException)e).getLineNumber()).append("\n");
            fail.append("col: ").append(((SAXParseException)e).getColumnNumber()).append("\n");
        }
        if (xml != null) {
            fail.append("\n");
            fail.append(xml);
        }
        return fail.toString();
    }
}

