/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.fixture;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.chemistry.abdera.ext.CMISAccessControlList;
import org.apache.chemistry.abdera.ext.CMISChangeEventInfo;
import org.apache.chemistry.abdera.ext.CMISConstants;
import org.apache.chemistry.abdera.ext.CMISObject;
import org.apache.chemistry.abdera.ext.utils.CMISAppModel;
import org.apache.chemistry.tck.atompub.client.CMISClient;
import org.apache.chemistry.tck.atompub.fixture.EntryTree;
import org.apache.chemistry.tck.atompub.http.GetRequest;
import org.apache.chemistry.tck.atompub.http.Response;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertChangeTypeInChangeLogVisitor
implements EntryTree.TreeVisitor {
    private String changeType;
    private Set<String> changesOnType;
    private Map<String, Entry> entriesByObjectId;

    public AssertChangeTypeInChangeLogVisitor(CMISClient client, CMISAppModel model, String changeLogToken, Integer maxItems, boolean includeACL, boolean includeProperties, String changeType, Set<String> changesOnType) throws Exception {
        this.changeType = changeType;
        this.changesOnType = changesOnType;
        Feed feed = this.getChangeLog(client, changeLogToken, maxItems, includeACL, includeProperties);
        List entries = feed.getEntries();
        this.entriesByObjectId = new HashMap<String, Entry>(entries.size() * 2);
        while (true) {
            if (maxItems != null) {
                Assert.assertFalse((String)"maxItems exceeded", (entries.size() > maxItems ? 1 : 0) != 0);
            }
            for (Entry entry : entries) {
                CMISObject object = (CMISObject)entry.getExtension(CMISConstants.OBJECT);
                Assert.assertNotNull((Object)object);
                String objectId = object.getObjectId().getStringValue();
                Assert.assertNotNull((Object)objectId);
                CMISChangeEventInfo changeEventInfo = object.getChangeEventInfo();
                Assert.assertNotNull((Object)changeEventInfo);
                if (!changeEventInfo.getChangeType().equals(changeType)) continue;
                this.entriesByObjectId.put(objectId, entry);
                if (includeACL) {
                    CMISAccessControlList accessControlList = object.getAccessControlList();
                    Assert.assertNotNull((String)"Expected ACL", (Object)accessControlList);
                    Link accessControlListLink = entry.getLink("http://docs.oasis-open.org/ns/cmis/link/200908/acl");
                    Assert.assertNotNull((String)"Expected ACL Link", (Object)accessControlListLink);
                    GetRequest req = new GetRequest(accessControlListLink.getHref().toString());
                    Response accessControlListRes = client.executeRequest(req, 200);
                    Assert.assertNotNull((Object)accessControlListRes);
                    Element fetchedAccessControlList = model.parse((Reader)new StringReader(accessControlListRes.getContentAsString()), null);
                    Assert.assertNotNull((Object)fetchedAccessControlList);
                    Assert.assertTrue((boolean)(fetchedAccessControlList instanceof CMISAccessControlList));
                    Assert.assertEquals((Object)accessControlList.getHashedEntries(), (Object)((CMISAccessControlList)fetchedAccessControlList).getHashedEntries());
                }
                HashSet properties = new HashSet(object.getProperties().getIds());
                Assert.assertTrue((boolean)properties.contains("cmis:objectId"));
                if (includeProperties) continue;
                Assert.assertTrue((String)"Unexpected properties in change log", (properties.size() == 1 ? 1 : 0) != 0);
            }
            Link nextPageLink = feed.getLink("next");
            if (nextPageLink == null) break;
            feed = client.getFeed(nextPageLink.getHref());
            entries = feed.getEntries();
        }
    }

    @Override
    public void visit(EntryTree entry) throws Exception {
        if (this.changesOnType.contains(entry.type)) {
            CMISObject object = (CMISObject)entry.entry.getExtension(CMISConstants.OBJECT);
            Assert.assertNotNull((Object)object);
            String objectId = object.getObjectId().getStringValue();
            Assert.assertNotNull((Object)objectId);
            Assert.assertTrue((String)(String.valueOf(this.changeType) + " change log entry should exist for " + objectId), (boolean)this.entriesByObjectId.containsKey(objectId));
        }
    }

    private Feed getChangeLog(CMISClient client, String changeLogToken, Integer maxItems, boolean includeACL, boolean includeProperties) throws Exception {
        Link changesLink = client.getChangesLink(client.getWorkspace());
        Assert.assertNotNull((Object)changesLink);
        HashMap<String, String> args = new HashMap<String, String>(5);
        if (changeLogToken != null) {
            args.put("changeLogToken", changeLogToken);
        }
        if (maxItems != null) {
            args.put("maxItems", maxItems.toString());
        }
        if (includeACL) {
            args.put("includeACL", "true");
        }
        if (includeProperties) {
            args.put("includeProperties", "true");
            args.put("filter", "*");
        }
        Feed changes = client.getFeed(changesLink.getHref(), args);
        Assert.assertNotNull((Object)changes);
        return changes;
    }
}

