/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.fixture;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Link;
import org.apache.chemistry.abdera.ext.CMISCapabilities;
import org.apache.chemistry.abdera.ext.CMISConstants;
import org.apache.chemistry.abdera.ext.CMISObject;
import org.apache.chemistry.abdera.ext.CMISUriTemplate;
import org.apache.chemistry.tck.atompub.TCKSkipCapabilityException;
import org.apache.chemistry.tck.atompub.client.CMISClient;
import org.apache.chemistry.tck.atompub.fixture.EntryTree;
import org.apache.chemistry.tck.atompub.http.GetRequest;
import org.junit.Assert;

public class GatherRenditionsVisitor
implements EntryTree.TreeVisitor {
    private CMISClient client;
    private Set<MimeType> renditionMimeTypes = new HashSet<MimeType>(5);
    private Set<String> renditionKinds = new HashSet<String>(5);
    private Map<String, Map<String, Set<IRI>>> entryRenditionMap = new HashMap<String, Map<String, Set<IRI>>>(5);

    public GatherRenditionsVisitor(CMISClient client) {
        this.client = client;
    }

    private String getObjectId(Entry entry) {
        Assert.assertNotNull((Object)entry);
        CMISObject object = (CMISObject)entry.getExtension(CMISConstants.OBJECT);
        Assert.assertNotNull((Object)object);
        String objectId = object.getObjectId().getStringValue();
        Assert.assertNotNull((Object)objectId);
        return objectId;
    }

    public void visit(EntryTree entry) throws Exception {
        String objectId = this.getObjectId(entry.entry);
        CMISUriTemplate objectByIdTemplate = this.client.getObjectByIdUriTemplate(this.client.getWorkspace());
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("id", objectId);
        variables.put("renditionFilter", "*");
        IRI objectByIdRequest = objectByIdTemplate.generateUri(variables);
        Entry documentById = this.client.getEntry(objectByIdRequest);
        Assert.assertNotNull((Object)documentById);
        String newObjectId = this.getObjectId(documentById);
        Assert.assertEquals((Object)objectId, (Object)newObjectId);
        HashMap entryRenditions = new HashMap();
        this.entryRenditionMap.put(objectId, entryRenditions);
        List<Link> renditions = this.client.getRenditionLinks(documentById);
        for (Link rendition : renditions) {
            MimeType mimeType = rendition.getMimeType();
            Assert.assertNotNull((Object)mimeType);
            String renditionKind = rendition.getAttributeValue(CMISConstants.RENDITION_KIND);
            Assert.assertNotNull((Object)renditionKind);
            IRI renditionLink = rendition.getHref();
            Assert.assertNotNull((Object)renditionLink);
            this.client.executeRequest(new GetRequest(renditionLink.toString()), 200);
            this.renditionMimeTypes.add(mimeType);
            this.renditionKinds.add(renditionKind);
            Set<IRI> typeRenditions = (HashSet<IRI>)entryRenditions.get(mimeType.getBaseType());
            if (typeRenditions == null) {
                typeRenditions = new HashSet<IRI>(5);
                entryRenditions.put(mimeType.getBaseType(), typeRenditions);
            }
            typeRenditions.add(renditionLink);
            typeRenditions = (Set)entryRenditions.get(renditionKind);
            if (typeRenditions == null) {
                typeRenditions = new HashSet(5);
                entryRenditions.put(renditionKind, typeRenditions);
            }
            typeRenditions.add(renditionLink);
        }
    }

    public void testRenditions(EntryTree fixture, EntryGenerator entryGenerator) throws Exception {
        CMISCapabilities capabilities = this.client.getCapabilities();
        if (capabilities.getRenditions().equals("none")) {
            throw new TCKSkipCapabilityException("Renditions", "read", "none");
        }
        fixture.walkTree(this);
        MimeType mimeType = null;
        Iterator<MimeType> mimeTypes = this.renditionMimeTypes.iterator();
        if (mimeTypes.hasNext()) {
            mimeType = mimeTypes.next();
        }
        String kind = null;
        Iterator<String> renditionKinds = this.renditionKinds.iterator();
        if (renditionKinds.hasNext()) {
            kind = renditionKinds.next();
        }
        this.getEntriesWithRenditionFilter(entryGenerator, "cmis:none");
        this.getEntriesWithRenditionFilter(entryGenerator, "*");
        if (mimeType != null) {
            this.getEntriesWithRenditionFilter(entryGenerator, mimeType.getBaseType());
            this.getEntriesWithRenditionFilter(entryGenerator, String.valueOf(mimeType.getPrimaryType()) + "/*");
        }
        if (kind != null) {
            this.getEntriesWithRenditionFilter(entryGenerator, kind);
            if (mimeType != null) {
                this.getEntriesWithRenditionFilter(entryGenerator, String.valueOf(kind) + ',' + mimeType.getBaseType());
                this.getEntriesWithRenditionFilter(entryGenerator, String.valueOf(kind) + ',' + mimeType.getPrimaryType() + "/*");
            }
        }
    }

    private void getEntriesWithRenditionFilter(EntryGenerator entryGenerator, String renditionFilter) throws Exception {
        EntryTree toValidate = entryGenerator.getEntries(renditionFilter);
        toValidate.walkTree(this.getRenditionCheckingVisitor(renditionFilter));
    }

    private EntryTree.TreeVisitor getRenditionCheckingVisitor(final String renditionFilter) {
        return new EntryTree.TreeVisitor(){

            private Set<IRI> predictRenditionsForFilter(Entry entry) {
                if (renditionFilter.equals("cmis:none")) {
                    return Collections.emptySet();
                }
                if (renditionFilter.equals("*")) {
                    HashSet<IRI> result = new HashSet<IRI>(5);
                    Map entryRenditions = (Map)GatherRenditionsVisitor.this.entryRenditionMap.get(GatherRenditionsVisitor.this.getObjectId(entry));
                    for (Set renditions : entryRenditions.values()) {
                        result.addAll(renditions);
                    }
                    return result;
                }
                HashSet<IRI> result = new HashSet<IRI>(5);
                StringTokenizer tkn = new StringTokenizer(renditionFilter, ",");
                Map entryRenditions = (Map)GatherRenditionsVisitor.this.entryRenditionMap.get(GatherRenditionsVisitor.this.getObjectId(entry));
                while (tkn.hasMoreTokens()) {
                    Set renditions;
                    String token = tkn.nextToken();
                    try {
                        MimeType mimeType = new MimeType(token);
                        if (mimeType.getSubType().equals("*")) {
                            String primaryType = mimeType.getPrimaryType();
                            for (Map.Entry typeEntry : entryRenditions.entrySet()) {
                                try {
                                    MimeType candidateType = new MimeType((String)typeEntry.getKey());
                                    if (!candidateType.getPrimaryType().equals(primaryType)) continue;
                                    result.addAll((Collection)typeEntry.getValue());
                                }
                                catch (MimeTypeParseException mimeTypeParseException) {
                                    // empty catch block
                                }
                            }
                            continue;
                        }
                    }
                    catch (MimeTypeParseException primaryType) {
                        // empty catch block
                    }
                    if ((renditions = (Set)entryRenditions.get(token)) == null) continue;
                    result.addAll(renditions);
                }
                return result;
            }

            @Override
            public void visit(EntryTree entry) throws Exception {
                Set<IRI> predictedRenditions = this.predictRenditionsForFilter(entry.entry);
                HashSet<IRI> actualRenditions = new HashSet<IRI>(predictedRenditions.size() * 2);
                List<Link> renditions = GatherRenditionsVisitor.this.client.getRenditionLinks(entry.entry);
                for (Link rendition : renditions) {
                    MimeType mimeType = rendition.getMimeType();
                    Assert.assertNotNull((Object)mimeType);
                    String renditionKind = rendition.getAttributeValue(CMISConstants.RENDITION_KIND);
                    Assert.assertNotNull((Object)renditionKind);
                    IRI renditionLink = rendition.getHref();
                    Assert.assertNotNull((Object)renditionLink);
                    GatherRenditionsVisitor.this.client.executeRequest(new GetRequest(renditionLink.toString()), 200);
                    actualRenditions.add(renditionLink);
                }
                Assert.assertEquals(predictedRenditions, actualRenditions);
            }
        };
    }

    public static interface EntryGenerator {
        public EntryTree getEntries(String var1) throws Exception;
    }
}

