/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.http.httpclient;

import java.io.IOException;
import java.util.Map;
import org.apache.chemistry.tck.atompub.http.Connection;
import org.apache.chemistry.tck.atompub.http.Request;
import org.apache.chemistry.tck.atompub.http.Response;
import org.apache.chemistry.tck.atompub.http.httpclient.HttpClientPatchMethod;
import org.apache.chemistry.tck.atompub.http.httpclient.HttpClientResponse;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public class HttpClientConnection
implements Connection {
    private HttpClient httpClient = new HttpClient();

    public HttpClientConnection(String username, String password) {
        if (username != null) {
            this.httpClient.getParams().setBooleanParameter("http.authentication.preemptive", true);
            this.httpClient.getState().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(username, password));
        }
    }

    public Response executeRequest(Request req) throws IOException {
        Object post;
        GetMethod httpMethod = null;
        String method = req.getMethod();
        if (method.equalsIgnoreCase("GET")) {
            GetMethod get;
            httpMethod = get = new GetMethod(req.getFullUri());
        } else if (method.equalsIgnoreCase("POST")) {
            post = new PostMethod(req.getFullUri());
            post.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(req.getBody(), req.getType()));
            httpMethod = post;
        } else if (method.equalsIgnoreCase("PATCH")) {
            post = new HttpClientPatchMethod(req.getFullUri());
            post.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(req.getBody(), req.getType()));
            httpMethod = post;
        } else if (method.equalsIgnoreCase("PUT")) {
            PutMethod put = new PutMethod(req.getFullUri());
            put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(req.getBody(), req.getType()));
            httpMethod = put;
        } else if (method.equalsIgnoreCase("DELETE")) {
            DeleteMethod del = new DeleteMethod(req.getFullUri());
            httpMethod = del;
        } else {
            throw new RuntimeException("Http Method " + method + " not supported");
        }
        if (req.getHeaders() != null) {
            for (Map.Entry<String, String> header : req.getHeaders().entrySet()) {
                httpMethod.setRequestHeader(header.getKey(), header.getValue());
            }
        }
        this.httpClient.executeMethod((HttpMethod)httpMethod);
        HttpClientResponse res = new HttpClientResponse((HttpMethod)httpMethod);
        return res;
    }
}

