/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.test.spec;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Link;
import org.apache.chemistry.abdera.ext.CMISAccessControlList;
import org.apache.chemistry.abdera.ext.CMISConstants;
import org.apache.chemistry.abdera.ext.CMISObject;
import org.apache.chemistry.abdera.ext.CMISUriTemplate;
import org.apache.chemistry.tck.atompub.TCKSkipCapabilityException;
import org.apache.chemistry.tck.atompub.TCKTest;
import org.apache.chemistry.tck.atompub.fixture.EntryTree;
import org.apache.chemistry.tck.atompub.fixture.ManageAccessControlListVisitor;
import org.apache.chemistry.tck.atompub.http.GetRequest;
import org.apache.chemistry.tck.atompub.http.Response;
import org.junit.Assert;

public class AccessControlListTest
extends TCKTest {
    public void testFolderAccessControlList() throws Exception {
        this.checkACLCapability(false);
        Entry folder = this.fixture.createTestFolder("testAccessControlList");
        Link accessControlListLink = folder.getLink("http://docs.oasis-open.org/ns/cmis/link/200908/acl");
        GetRequest req = new GetRequest(accessControlListLink.getHref().toString());
        Response accessControlListRes = this.client.executeRequest(req, 200);
        Assert.assertNotNull((Object)accessControlListRes);
        Element accessControlList = this.model.parse((Reader)new StringReader(accessControlListRes.getContentAsString()), null);
        Assert.assertNotNull((Object)accessControlList);
        Assert.assertTrue((boolean)(accessControlList instanceof CMISAccessControlList));
        CMISObject childObject = (CMISObject)folder.getExtension(CMISConstants.OBJECT);
        Assert.assertNotNull((Object)childObject);
        String objectId = childObject.getObjectId().getStringValue();
        Assert.assertNotNull((Object)objectId);
        CMISUriTemplate objectByIdTemplate = this.client.getObjectByIdUriTemplate(this.client.getWorkspace());
        HashMap<String, String> variables = new HashMap<String, String>(5);
        variables.put("id", objectId);
        variables.put("includeACL", "true");
        IRI objectByIdRequest = objectByIdTemplate.generateUri(variables);
        folder = this.client.getEntry(objectByIdRequest);
        Assert.assertNotNull((Object)folder);
        childObject = (CMISObject)folder.getExtension(CMISConstants.OBJECT);
        Assert.assertNotNull((Object)childObject);
        CMISAccessControlList objectAccessControlList = (CMISAccessControlList)childObject.getExtension(CMISConstants.ACCESS_CONTROL_LIST);
        Assert.assertNotNull((Object)objectAccessControlList);
        Assert.assertEquals((Object)((CMISAccessControlList)accessControlList).getHashedEntries(), (Object)objectAccessControlList.getHashedEntries());
    }

    public void testDocumentAccessControlList() throws Exception {
        this.checkACLCapability(false);
        Entry document = this.fixture.createTestDocument("testDocumentAccessControlList");
        Link accessControlListLink = document.getLink("http://docs.oasis-open.org/ns/cmis/link/200908/acl");
        GetRequest req = new GetRequest(accessControlListLink.getHref().toString());
        Response accessControlListRes = this.client.executeRequest(req, 200);
        Assert.assertNotNull((Object)accessControlListRes);
        Element accessControlList = this.model.parse((Reader)new StringReader(accessControlListRes.getContentAsString()), null);
        Assert.assertNotNull((Object)accessControlList);
        Assert.assertTrue((boolean)(accessControlList instanceof CMISAccessControlList));
        CMISObject childObject = (CMISObject)document.getExtension(CMISConstants.OBJECT);
        Assert.assertNotNull((Object)childObject);
        String objectId = childObject.getObjectId().getStringValue();
        Assert.assertNotNull((Object)objectId);
        CMISUriTemplate objectByIdTemplate = this.client.getObjectByIdUriTemplate(this.client.getWorkspace());
        HashMap<String, String> variables = new HashMap<String, String>(5);
        variables.put("id", objectId);
        variables.put("includeACL", "true");
        IRI objectByIdRequest = objectByIdTemplate.generateUri(variables);
        document = this.client.getEntry(objectByIdRequest);
        Assert.assertNotNull((Object)document);
        childObject = (CMISObject)document.getExtension(CMISConstants.OBJECT);
        Assert.assertNotNull((Object)childObject);
        CMISAccessControlList objectAccessControlList = (CMISAccessControlList)childObject.getExtension(CMISConstants.ACCESS_CONTROL_LIST);
        Assert.assertNotNull((Object)objectAccessControlList);
        Assert.assertEquals((Object)((CMISAccessControlList)accessControlList).getHashedEntries(), (Object)objectAccessControlList.getHashedEntries());
    }

    public void testManageAccessControlList() throws Exception {
        this.checkACLCapability(true);
        EntryTree folderTree = this.fixture.createTestTree("testManageAccessControlList", 1, 1, null, null);
        folderTree.walkTree(new ManageAccessControlListVisitor(this.client, this.model));
    }

    private void checkACLCapability(boolean manage) throws TCKSkipCapabilityException, Exception {
        String aclCapability = this.client.getCapabilities().getACL();
        if (manage) {
            if (!aclCapability.equals("manage")) {
                throw new TCKSkipCapabilityException("ACL", "manage", aclCapability);
            }
        } else if (aclCapability.equals("none")) {
            throw new TCKSkipCapabilityException("ACL", "read", aclCapability);
        }
        AccessControlListTest.assertNotNull((Object)this.client.getACLCapability());
    }
}

