/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.test.spec;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.chemistry.abdera.ext.CMISConstants;
import org.apache.chemistry.abdera.ext.CMISObject;
import org.apache.chemistry.abdera.ext.CMISPropertyDefinition;
import org.apache.chemistry.abdera.ext.CMISTypeDefinition;
import org.apache.chemistry.abdera.ext.CMISUriTemplate;
import org.apache.chemistry.tck.atompub.TCKTest;
import org.apache.chemistry.tck.atompub.fixture.AssertEntryInFeedVisitor;
import org.apache.chemistry.tck.atompub.fixture.AssertValidFolderParentVisitor;
import org.apache.chemistry.tck.atompub.fixture.CMISTree;
import org.apache.chemistry.tck.atompub.fixture.EntryTree;
import org.apache.chemistry.tck.atompub.fixture.GatherRenditionsVisitor;
import org.junit.Assert;

public class FolderChildrenTest
extends TCKTest {
    public void testGetChildren() throws Exception {
        EntryTree folder = this.fixture.createTestTree("children", 1, 3, null, null);
        Link childrenLink = this.client.getChildrenLink(folder.entry);
        Feed children = this.client.getFeed(childrenLink.getHref());
        Assert.assertEquals((long)3L, (long)children.getEntries().size());
        folder.walkChildren(new AssertEntryInFeedVisitor(children));
    }

    public void testGetChildrenPaging() throws Exception {
        EntryTree folder = this.fixture.createTestTree("children", 1, 15, null, null);
        HashSet<IRI> unread = new HashSet<IRI>();
        for (EntryTree child : folder.children) {
            unread.add(child.entry.getId());
        }
        Assert.assertEquals((long)15L, (long)unread.size());
        Link nextLink = this.client.getChildrenLink(folder.entry);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("maxItems", "4");
        int pageCount = 0;
        while (nextLink != null) {
            IRI nextLinkHref = nextLink.getHref();
            FolderChildrenTest.assertNotNull((Object)nextLinkHref.getHost());
            Feed children = this.client.getFeed(nextLinkHref, args);
            Assert.assertNotNull((Object)children);
            Assert.assertEquals((long)(++pageCount < 4 ? 4 : 3), (long)children.getEntries().size());
            for (Entry entry : children.getEntries()) {
                unread.remove(entry.getId());
            }
            nextLink = children.getLink("next");
            if (pageCount < 4) {
                Assert.assertNotNull((Object)nextLink);
            }
            args = null;
        }
        Assert.assertEquals((long)4L, (long)pageCount);
        Assert.assertEquals((long)0L, (long)unread.size());
    }

    public void testGetChildrenAllPropertyFilter() throws Exception {
        EntryTree folder = this.fixture.createTestTree("children", 1, 1, null, null);
        Link childrenLink = this.client.getChildrenLink(folder.entry);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("filter", "*");
        Feed children = this.client.getFeed(childrenLink.getHref(), args);
        for (Entry entry : children.getEntries()) {
            CMISObject object = (CMISObject)entry.getExtension(CMISConstants.OBJECT);
            Assert.assertNotNull((Object)object.getObjectId().getStringValue());
            Assert.assertNotNull((Object)object.getObjectTypeId().getStringValue());
        }
    }

    public void testGetChildrenNamedPropertyFilter() throws Exception {
        EntryTree folder = this.fixture.createTestTree("children", 1, 1, null, null);
        CMISUriTemplate typeUriTemplate = this.client.getTypeByIdUriTemplate(this.client.getWorkspace());
        Assert.assertNotNull((Object)typeUriTemplate);
        HashMap<String, String> typeVariables = new HashMap<String, String>();
        typeVariables.put("id", "cmis:document");
        IRI docTypeUri = typeUriTemplate.generateUri(typeVariables);
        Entry docTypeEntry = this.client.getEntry(docTypeUri);
        Assert.assertNotNull((Object)docTypeEntry);
        CMISTypeDefinition docType = (CMISTypeDefinition)docTypeEntry.getExtension(CMISConstants.TYPE_DEFINITION);
        Assert.assertNotNull((Object)docType);
        CMISPropertyDefinition objectIdpropDef = docType.getPropertyDefinition("cmis:objectId");
        Assert.assertNotNull((Object)objectIdpropDef);
        String objectIdQueryName = objectIdpropDef.getQueryName();
        Assert.assertNotNull((Object)objectIdQueryName);
        CMISPropertyDefinition objectTypePropDef = docType.getPropertyDefinition("cmis:objectTypeId");
        Assert.assertNotNull((Object)objectTypePropDef);
        String objectTypeIdQueryName = objectTypePropDef.getQueryName();
        Assert.assertNotNull((Object)objectTypeIdQueryName);
        Link childrenLink = this.client.getChildrenLink(folder.entry);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("filter", String.valueOf(objectIdQueryName) + "," + objectTypeIdQueryName);
        Feed children = this.client.getFeed(childrenLink.getHref(), args);
        for (Entry entry : children.getEntries()) {
            CMISObject object = (CMISObject)entry.getExtension(CMISConstants.OBJECT);
            Assert.assertNotNull((Object)object.getObjectId().getStringValue());
            Assert.assertNotNull((Object)object.getObjectTypeId());
        }
    }

    public void testGetParents() throws Exception {
        EntryTree folder = this.fixture.createTestTree("children", 3, 0, null, null);
        folder.walkTree(new AssertValidFolderParentVisitor(this.client));
    }

    public void testGetChildrenRenditions() throws Exception {
        final EntryTree folder = this.fixture.createTestTree("children", 1, 3, null, null);
        final Link childrenLink = this.client.getChildrenLink(folder.entry);
        GatherRenditionsVisitor visitor = new GatherRenditionsVisitor(this.client);
        visitor.testRenditions(folder, new GatherRenditionsVisitor.EntryGenerator(){

            public EntryTree getEntries(String renditionFilter) throws Exception {
                return new CMISTree(folder, FolderChildrenTest.this.client.getFeed(childrenLink.getHref(), Collections.singletonMap("renditionFilter", renditionFilter)));
            }
        });
    }

    public void testGetParentRenditions() throws Exception {
        final EntryTree folder = this.fixture.createTestTree("children", 2, 0, null, null);
        EntryTree child = folder.children.get(0);
        final Link parentLink = this.client.getFolderParentLink(child.entry);
        Assert.assertNotNull((Object)parentLink);
        GatherRenditionsVisitor visitor = new GatherRenditionsVisitor(this.client);
        visitor.testRenditions(folder, new GatherRenditionsVisitor.EntryGenerator(){

            public EntryTree getEntries(String renditionFilter) throws Exception {
                return new CMISTree(folder.entry, FolderChildrenTest.this.client.getEntry(parentLink.getHref(), Collections.singletonMap("renditionFilter", renditionFilter)), "cmis:folder");
            }
        });
    }
}

