/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.command;

import java.io.IOException;
import java.util.List;
import org.subethamail.smtp.MessageHandler;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.server.BaseCommand;
import org.subethamail.smtp.server.ConnectionContext;
import org.subethamail.smtp.server.io.CRLFTerminatedReader;

public class AuthCommand
extends BaseCommand {
    public static final String VERB = "AUTH";
    public static final String AUTH_CANCEL_COMMAND = "*";

    static String getEhloString(MessageHandler handler) {
        List<String> supportedMechanisms = handler.getAuthenticationMechanisms();
        if (supportedMechanisms.isEmpty()) {
            return "";
        }
        return "\r\n250-AUTH " + AuthCommand.getTokenizedString(supportedMechanisms, " ");
    }

    public AuthCommand() {
        super(VERB, "Authentication service", "AUTH <mechanism> [initial-response] \n\t mechanism = a string identifying a SASL authentication mechanism,\n\t an optional base64-encoded response");
    }

    public void execute(String commandString, ConnectionContext context) throws IOException {
        if (context.getSession().isAuthenticated()) {
            context.sendResponse("503 Refusing any other AUTH command.");
            return;
        }
        MessageHandler msgHandler = this.getMessageHandler(context);
        String[] args = this.getArgs(commandString);
        if (args.length < 2) {
            context.sendResponse("501 Syntax: AUTH mechanism [initial-response]");
            return;
        }
        String mechanism = args[1];
        if (!msgHandler.getAuthenticationMechanisms().contains(mechanism.toUpperCase())) {
            context.sendResponse("504 The requested authentication mechanism is not supported");
            return;
        }
        try {
            StringBuffer response = new StringBuffer();
            CRLFTerminatedReader reader = this.instantiateReader(context);
            boolean finished = msgHandler.auth(commandString, response);
            if (!finished) {
                context.sendResponse(response.toString());
            }
            while (!finished) {
                response = new StringBuffer();
                String clientInput = reader.readLine();
                if (clientInput.trim().equals(AUTH_CANCEL_COMMAND)) {
                    context.sendResponse("501 Authentication canceled by client.");
                    return;
                }
                finished = msgHandler.auth(clientInput, response);
                if (finished) continue;
                context.sendResponse(response.toString());
            }
            context.sendResponse("235 Authentication successful.");
            context.getSession().setAuthenticated(true);
        }
        catch (RejectException authFailed) {
            context.sendResponse("535 Authentication failure.");
            context.getSession().setAuthenticated(false);
        }
    }

    public CRLFTerminatedReader instantiateReader(ConnectionContext context) throws IOException {
        return new CRLFTerminatedReader(context.getSocket().getInputStream());
    }

    public MessageHandler getMessageHandler(ConnectionContext context) {
        return context.getSession().getMessageHandler();
    }
}

