/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLNameIdentifier;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLSubject
extends SAMLObject
implements Cloneable {
    protected SAMLNameIdentifier nameId;
    protected ArrayList confirmationMethods;
    protected Element confirmationData;
    protected KeyInfo keyInfo;
    public static final String CONF_ARTIFACT = "urn:oasis:names:tc:SAML:1.0:cm:artifact";
    public static final String CONF_BEARER = "urn:oasis:names:tc:SAML:1.0:cm:bearer";
    public static final String CONF_HOLDER_KEY = "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
    public static final String CONF_SENDER_VOUCHES = "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";

    public SAMLSubject() {
        this.nameId = null;
        this.confirmationMethods = new ArrayList();
        this.confirmationData = null;
        this.keyInfo = null;
    }

    public SAMLSubject(SAMLNameIdentifier sAMLNameIdentifier, Collection collection, Element element, Object object) throws SAMLException {
        block6: {
            this.nameId = null;
            this.confirmationMethods = new ArrayList();
            this.confirmationData = null;
            this.keyInfo = null;
            this.nameId = sAMLNameIdentifier;
            this.confirmationData = element;
            if (collection != null) {
                this.confirmationMethods.addAll(collection);
            }
            if (object != null) {
                try {
                    if (object instanceof KeyInfo) {
                        this.keyInfo = (KeyInfo)object;
                        break block6;
                    }
                    if (object instanceof Element) {
                        this.keyInfo = new KeyInfo((Element)object, null);
                        break block6;
                    }
                    throw new MalformedException("SAMLSubject() unable to handle the provided keyInfo type");
                }
                catch (XMLSecurityException xMLSecurityException) {
                    throw new MalformedException("SAMLSubject() caught an XML security exception", (Exception)((Object)xMLSecurityException));
                }
            }
        }
    }

    public SAMLSubject(Element element) throws SAMLException {
        this.nameId = null;
        this.confirmationMethods = new ArrayList();
        this.confirmationData = null;
        this.keyInfo = null;
        this.fromDOM(element);
    }

    public SAMLSubject(InputStream inputStream) throws SAMLException {
        this.nameId = null;
        this.confirmationMethods = new ArrayList();
        this.confirmationData = null;
        this.keyInfo = null;
        this.fromDOM(SAMLSubject.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Subject")) {
            throw new MalformedException("SAMLSubject.fromDOM() requires saml:Subject at root");
        }
        Element element2 = XML.getFirstChildElement(element, "urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier");
        if (element2 != null) {
            this.nameId = new SAMLNameIdentifier(element2);
            element2 = XML.getNextSiblingElement(element2);
        }
        if (element2 != null && XML.isElementNamed(element2, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation")) {
            Element element3 = XML.getFirstChildElement(element2);
            while (element3 != null && XML.isElementNamed(element3, "urn:oasis:names:tc:SAML:1.0:assertion", "ConfirmationMethod")) {
                this.confirmationMethods.add(element3.getFirstChild().getNodeValue());
                element3 = XML.getNextSiblingElement(element3);
            }
            if (element3 != null && XML.isElementNamed(element3, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmationData")) {
                this.confirmationData = element3;
                element3 = XML.getNextSiblingElement(element3);
            }
            if (element3 != null && XML.isElementNamed(element3, "http://www.w3.org/2000/09/xmldsig#", "KeyInfo")) {
                try {
                    this.keyInfo = new KeyInfo(element3, null);
                }
                catch (XMLSecurityException xMLSecurityException) {
                    throw new MalformedException("SAMLSubject.fromDOM() caught an XML security exception", (Exception)((Object)xMLSecurityException));
                }
            }
        }
        this.checkValidity();
    }

    public SAMLNameIdentifier getName() {
        return this.nameId;
    }

    public void setName(SAMLNameIdentifier sAMLNameIdentifier) throws SAMLException {
        if (this.root != null) {
            Element element = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier");
            if (element != null) {
                this.root.removeChild(element);
            }
            if (sAMLNameIdentifier != null) {
                this.root.insertBefore(sAMLNameIdentifier.toDOM(this.root.getOwnerDocument()), this.root.getFirstChild());
            }
        }
        this.nameId = sAMLNameIdentifier;
    }

    public Iterator getConfirmationMethods() {
        return this.confirmationMethods.iterator();
    }

    public void setConfirmationMethods(Collection collection) {
        while (this.confirmationMethods.size() > 0) {
            this.removeConfirmationMethod(0);
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addConfirmationMethod((String)iterator.next());
            }
        }
    }

    public void addConfirmationMethod(String string) {
        if (!XML.isEmpty(string)) {
            if (this.root != null) {
                Element element = this.root.getOwnerDocument().createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "ConfirmationMethod");
                element.appendChild(this.root.getOwnerDocument().createTextNode(string));
                Element element2 = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation");
                if (element2 == null) {
                    Element element3 = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier");
                    element2 = element3 == null ? (Element)this.root.insertBefore(this.root.getOwnerDocument().createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation"), this.root.getFirstChild()) : (Element)this.root.insertBefore(this.root.getOwnerDocument().createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation"), element3.getNextSibling());
                    element2.appendChild(element);
                } else {
                    Element element4 = XML.getLastChildElement(element2, "urn:oasis:names:tc:SAML:1.0:assertion", "ConfirmationMethod");
                    if (element4 == null) {
                        element2.insertBefore(element, element2.getFirstChild());
                    } else {
                        element2.insertBefore(element, element4.getNextSibling());
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("confirmationMethod cannot be null or empty");
        }
        this.confirmationMethods.add(string);
    }

    public void removeConfirmationMethod(int n) throws IndexOutOfBoundsException {
        this.confirmationMethods.remove(n);
        if (this.root != null) {
            Element element = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation");
            if (this.confirmationMethods.size() == 0 && this.confirmationData == null && this.keyInfo == null) {
                this.root.removeChild(element);
                return;
            }
            Element element2 = XML.getFirstChildElement(element);
            while (element2 != null && n > 0) {
                element2 = XML.getNextSiblingElement(element2);
                --n;
            }
            if (element2 != null) {
                element.removeChild(element2);
            } else {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public Element getConfirmationData() {
        return this.confirmationData;
    }

    public void setConfirmationData(Element element) {
        if (element != null && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmationData")) {
            throw new IllegalArgumentException("confirmationData must be a saml:SubjectConfirmationData element");
        }
        if (this.root != null) {
            Element element2 = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation");
            if (this.confirmationData != null) {
                element2.removeChild(this.confirmationData);
                if (element == null && this.keyInfo == null && this.confirmationMethods.size() == 0) {
                    this.root.removeChild(element2);
                }
            }
            if (element != null) {
                if (element2 == null) {
                    Element element3 = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier");
                    element2 = element3 == null ? (Element)this.root.insertBefore(this.root.getOwnerDocument().createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation"), this.root.getFirstChild()) : (Element)this.root.insertBefore(this.root.getOwnerDocument().createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation"), element3.getNextSibling());
                    element2.appendChild(this.root.getOwnerDocument().adoptNode(element));
                } else {
                    Element element4 = XML.getLastChildElement(element2, "urn:oasis:names:tc:SAML:1.0:assertion", "ConfirmationMethod");
                    if (element4 == null) {
                        element2.insertBefore(this.root.getOwnerDocument().adoptNode(element), element2.getFirstChild());
                    } else {
                        element2.insertBefore(this.root.getOwnerDocument().adoptNode(element), element4.getNextSibling());
                    }
                }
            }
        }
        this.confirmationData = element;
    }

    public Element getKeyInfo() {
        return this.keyInfo != null ? this.keyInfo.getElement() : null;
    }

    public Object getNativeKeyInfo() {
        return this.keyInfo;
    }

    public void setKeyInfo(Object object) throws SAMLException {
        if (object != null && !(object instanceof KeyInfo) && !(object instanceof Element)) {
            throw new IllegalArgumentException("keyInfo must be a ds:KeyInfo element or a native library object");
        }
        KeyInfo keyInfo = null;
        try {
            keyInfo = object instanceof Element ? (this.root != null ? new KeyInfo((Element)this.root.getOwnerDocument().adoptNode((Node)object), null) : new KeyInfo((Element)object, null)) : (KeyInfo)object;
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new SAMLException("setKeyInfo() caught an XML security exception", (Exception)((Object)xMLSecurityException));
        }
        if (this.root != null) {
            Element element = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation");
            if (this.keyInfo != null) {
                element.removeChild(this.keyInfo.getElement());
                if (this.confirmationData == null && object == null && this.confirmationMethods.size() == 0) {
                    this.root.removeChild(element);
                }
            }
            if (object != null) {
                if (element == null) {
                    Element element2 = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier");
                    element = element2 == null ? (Element)this.root.insertBefore(this.root.getOwnerDocument().createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation"), this.root.getFirstChild()) : (Element)this.root.insertBefore(this.root.getOwnerDocument().createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation"), element2.getNextSibling());
                    element.appendChild(keyInfo.getElement());
                } else if (this.confirmationData == null) {
                    Element element3 = XML.getLastChildElement(element, "urn:oasis:names:tc:SAML:1.0:assertion", "ConfirmationMethod");
                    if (element3 == null) {
                        element.insertBefore(keyInfo.getElement(), element.getFirstChild());
                    } else {
                        element.insertBefore(keyInfo.getElement(), element3.getNextSibling());
                    }
                } else {
                    element.insertBefore(keyInfo.getElement(), this.confirmationData.getNextSibling());
                }
            }
        }
        this.keyInfo = keyInfo;
    }

    public Node toDOM() throws SAMLException {
        if (this.confirmationData != null) {
            return this.toDOM(this.confirmationData.getOwnerDocument());
        }
        if (this.keyInfo != null) {
            return this.toDOM(this.keyInfo.getDocument());
        }
        return super.toDOM();
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        this.root = super.toDOM(document, bl);
        if (this.root != null) {
            if (bl) {
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
            }
            return this.root;
        }
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Subject");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        if (this.nameId != null) {
            element.appendChild(this.nameId.toDOM(document, false));
        }
        if (this.confirmationMethods.size() > 0) {
            Element element2 = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation");
            Iterator iterator = this.confirmationMethods.iterator();
            while (iterator.hasNext()) {
                element2.appendChild(document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "ConfirmationMethod")).appendChild(document.createTextNode((String)iterator.next()));
            }
            if (this.confirmationData != null) {
                element2.appendChild(document.adoptNode(this.confirmationData));
            }
            if (this.keyInfo != null) {
                element2.appendChild(document.adoptNode(this.keyInfo.getElement()));
            }
            element.appendChild(element2);
        }
        this.root = element;
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (this.nameId == null && (this.confirmationMethods == null || this.confirmationMethods.size() == 0)) {
            throw new MalformedException("Subject is invalid, requires either NameIdentifier or at least one ConfirmationMethod");
        }
        if (this.confirmationData != null && !XML.isElementNamed(this.confirmationData, "urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmationData")) {
            throw new MalformedException("Subject is invalid, requires that confirmation data be a saml:SubjectConfirmationData element");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLSubject sAMLSubject = (SAMLSubject)super.clone();
        if (this.nameId != null) {
            sAMLSubject.nameId = (SAMLNameIdentifier)this.nameId.clone();
        }
        sAMLSubject.confirmationMethods = (ArrayList)this.confirmationMethods.clone();
        if (this.confirmationData != null) {
            sAMLSubject.confirmationData = (Element)this.confirmationData.cloneNode(true);
        }
        if (this.keyInfo != null) {
            try {
                sAMLSubject.keyInfo = new KeyInfo((Element)this.keyInfo.getElement().cloneNode(true), null);
            }
            catch (XMLSecurityException xMLSecurityException) {
                throw new RuntimeException("SAMLSubject.clone() unable to copy keyInfo");
            }
        }
        return sAMLSubject;
    }
}

