/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.ibatis;

import org.alfresco.error.AlfrescoRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryingCallbackHelper {
    private static final Log logger = LogFactory.getLog(RetryingCallbackHelper.class);
    private int maxRetries = 5;
    private int retryWaitMs = 10;

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setRetryWaitMs(int retryWaitMs) {
        this.retryWaitMs = retryWaitMs;
    }

    public <R> R doWithRetry(RetryingCallback<R> callback) {
        RuntimeException lastException = null;
        for (int count = 0; count == 0 || count < this.maxRetries; ++count) {
            try {
                R result = callback.execute();
                if (logger.isDebugEnabled() && count != 0) {
                    logger.debug((Object)("\nRetrying work succeeded: \n   Thread: " + Thread.currentThread().getName() + "\n" + "   Iteration: " + count));
                }
                return result;
            }
            catch (Throwable e) {
                RuntimeException runtimeException = lastException = e instanceof RuntimeException ? (RuntimeException)e : new AlfrescoRuntimeException("Exception in Transaction.", e);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\nRetrying work failed: \n   Thread: " + Thread.currentThread().getName() + "\n" + "   Iteration: " + count + "\n" + "   Exception follows:"), e);
                } else if (logger.isInfoEnabled()) {
                    String msg = String.format("Retrying %s: count %2d; wait: %3dms; msg: \"%s\"; exception: (%s)", Thread.currentThread().getName(), count, this.retryWaitMs, e.getMessage(), e.getClass().getName());
                    logger.info((Object)msg);
                }
                try {
                    Thread.sleep(this.retryWaitMs);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                continue;
            }
        }
        throw lastException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RetryingCallback<Result> {
        public Result execute() throws Throwable;
    }
}

